/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import java.io.File;
import java.io.Writer;
import java.nio.file.Path;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsContentTypeFormat;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsObjectFormat;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsPropertiesFormat;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTableFormat;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTreeFormat;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.format.plain.NutsFormatPlain;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsObjectFormat
extends DefaultFormatBase<NutsObjectFormat>
implements NutsObjectFormat {
    private Object value;
    private boolean compact;
    private NutsContentType outputFormat;

    public DefaultNutsObjectFormat(NutsSession session) {
        super(session, "object-format");
    }

    public Object getValue() {
        return this.value;
    }

    public NutsObjectFormat setValue(Object value) {
        this.value = value;
        return this;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public DefaultNutsObjectFormat setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    public NutsContentTypeFormat getBase() {
        this.checkSession();
        NutsSession session = this.getSession();
        NutsContentTypeFormat base = this.createObjectFormat();
        base.setSession(session);
        base.configure(true, session.boot().getBootOptions().getOutputFormatOptions());
        base.configure(true, session.getOutputFormatOptions());
        return base;
    }

    public NutsContentTypeFormat createObjectFormat() {
        this.checkSession();
        NutsSession session = this.getSession();
        Object value = this.getValue();
        switch (this.getSession().getOutputFormat()) {
            case XML: 
            case JSON: 
            case TSON: 
            case YAML: {
                NutsElements ee = NutsElements.of((NutsSession)session).setNtf(this.isNtf()).setCompact(this.isCompact()).setContentType(this.getSession().getOutputFormat());
                if (value instanceof NutsString) {
                    NutsTextBuilder builder = ((NutsString)value).builder();
                    Object[] r = builder.lines().map(NutsFunction.of(x -> x.filteredText(), (String)"filteredText")).toArray(Object[]::new);
                    ee.setValue((Object)r);
                } else {
                    ee.setValue(value);
                }
                return ee;
            }
            case PROPS: {
                NutsPropertiesFormat ee = NutsPropertiesFormat.of((NutsSession)session).setNtf(this.isNtf());
                if (value instanceof NutsString) {
                    NutsTextBuilder builder = ((NutsString)value).builder();
                    Object[] r = builder.lines().toArray(Object[]::new);
                    ee.setValue((Object)r);
                } else {
                    ee.setValue(value);
                }
                return ee;
            }
            case TREE: {
                NutsTreeFormat ee = NutsTreeFormat.of((NutsSession)session).setNtf(this.isNtf());
                if (value instanceof NutsString) {
                    NutsTextBuilder builder = ((NutsString)value).builder();
                    Object[] r = builder.lines().toArray(Object[]::new);
                    ee.setValue((Object)r);
                } else {
                    ee.setValue(value);
                }
                return ee;
            }
            case TABLE: {
                NutsTableFormat ee = NutsTableFormat.of((NutsSession)session).setNtf(this.isNtf());
                if (value instanceof NutsString) {
                    NutsTextBuilder builder = ((NutsString)value).builder();
                    Object[] r = builder.lines().toArray(Object[]::new);
                    ee.setValue((Object)r);
                } else {
                    ee.setValue(value);
                }
                return ee;
            }
            case PLAIN: {
                NutsFormatPlain ee = new NutsFormatPlain(session).setCompact(this.isCompact()).setNtf(this.isNtf());
                ee.setValue(value);
                return ee;
            }
        }
        throw new NutsUnsupportedEnumException(this.getSession(), (Enum)this.getSession().getOutputFormat());
    }

    @Override
    public NutsString format() {
        return this.getBase().format();
    }

    @Override
    public void print() {
        this.getBase().print();
    }

    @Override
    public void println() {
        this.getBase().println();
    }

    @Override
    public void print(NutsPrintStream out) {
        this.getBase().print(out);
    }

    @Override
    public void print(Writer out) {
        this.getBase().print(out);
    }

    @Override
    public void print(Path out) {
        this.getBase().print(out);
    }

    @Override
    public void print(File out) {
        this.getBase().print(out);
    }

    @Override
    public void print(NutsSessionTerminal terminal) {
        this.getBase().print(terminal);
    }

    @Override
    public void println(Writer w) {
        this.getBase().println(w);
    }

    @Override
    public void println(NutsPrintStream out) {
        this.getBase().println(out);
    }

    @Override
    public void println(Path path) {
        this.getBase().println(path);
    }

    @Override
    public void println(NutsSessionTerminal terminal) {
        this.getBase().println(terminal);
    }

    @Override
    public void println(File file) {
        this.getBase().println(file);
    }

    public boolean configureFirst(NutsCommandLine commandLine) {
        return this.getBase().configureFirst(commandLine);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

