/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Path;
import net.thevpc.nuts.NutsFormat;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsMemoryPrintStream;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase0;

public abstract class DefaultFormatBase<T extends NutsFormat>
extends DefaultFormatBase0<T>
implements NutsFormat {
    public DefaultFormatBase(NutsWorkspace ws, String name) {
        super(ws, name);
    }

    public DefaultFormatBase(NutsSession session, String name) {
        super(session, name);
    }

    @Override
    public NutsPrintStream getValidPrintStream(NutsPrintStream out) {
        this.checkSession();
        if (out == null) {
            out = this.getSession().getTerminal().getOut();
        }
        return out;
    }

    @Override
    public NutsPrintStream getValidPrintStream() {
        return this.getValidPrintStream(null);
    }

    public NutsString format() {
        this.checkSession();
        NutsMemoryPrintStream out = NutsMemoryPrintStream.of((NutsSession)this.getSession());
        this.print((NutsPrintStream)out);
        return this.isNtf() ? NutsTexts.of((NutsSession)this.getSession()).parse(out.toString()) : NutsTexts.of((NutsSession)this.getSession()).ofPlain(out.toString());
    }

    public void print() {
        this.checkSession();
        this.print(this.getSession().getTerminal());
    }

    public void println() {
        this.checkSession();
        this.println(this.getSession().getTerminal());
    }

    public abstract void print(NutsPrintStream var1);

    public void print(Writer out) {
        this.checkSession();
        if (out == null) {
            NutsPrintStream pout = this.getValidPrintStream();
            this.print(pout);
            pout.flush();
        } else {
            NutsPrintStream pout = NutsPrintStream.of((Writer)out, (NutsSession)this.getSession());
            this.print(pout);
            pout.flush();
        }
    }

    public void print(OutputStream out) {
        this.checkSession();
        NutsPrintStream p = out == null ? this.getValidPrintStream() : NutsPrintStream.of((OutputStream)out, (NutsSession)this.getSession());
        this.print(p);
        p.flush();
    }

    public void print(Path path) {
        this.checkSession();
        this.print(NutsPath.of((Path)path, (NutsSession)this.getSession()));
    }

    public void print(NutsPath path) {
        this.checkSession();
        path.mkParentDirs();
        try (Writer w = path.getWriter();){
            this.print(w);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.getSession(), (Throwable)ex);
        }
    }

    public void print(File file) {
        this.print(NutsPath.of((File)file, (NutsSession)this.getSession()));
    }

    public void print(NutsSessionTerminal terminal) {
        this.checkSession();
        this.print(terminal == null ? this.getSession().getTerminal().out() : terminal.out());
    }

    public void println(Writer w) {
        this.checkSession();
        if (w == null) {
            NutsPrintStream pout = this.getValidPrintStream();
            this.println(pout);
            pout.flush();
        } else {
            NutsPrintStream pout = NutsPrintStream.of((Writer)w, (NutsSession)this.getSession());
            this.println(pout);
            pout.flush();
        }
    }

    public void println(NutsPrintStream out) {
        this.checkSession();
        NutsPrintStream p = this.getValidPrintStream(out);
        this.print(out);
        p.println();
        p.flush();
    }

    public void println(OutputStream out) {
        this.checkSession();
        if (out == null) {
            NutsPrintStream pout = this.getValidPrintStream();
            this.println(pout);
            pout.flush();
        } else {
            NutsPrintStream pout = NutsPrintStream.of((OutputStream)out, (NutsSession)this.getSession());
            this.println(pout);
            pout.flush();
        }
    }

    public void println(Path path) {
        this.checkSession();
        this.println(NutsPath.of((Path)path, (NutsSession)this.getSession()));
    }

    public void println(NutsPath out) {
        this.checkSession();
        out.mkParentDirs();
        try (Writer w = out.getWriter();){
            this.println(w);
        }
        catch (IOException ex) {
            throw new NutsIOException(this.getSession(), (Throwable)ex);
        }
    }

    public void println(NutsSessionTerminal terminal) {
        this.checkSession();
        this.println(terminal == null ? this.getSession().getTerminal().out() : terminal.out());
    }

    public void println(File file) {
        this.println(file.toPath());
    }

    public String toString() {
        return this.format().toString();
    }
}

