/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsConfirmationMode;
import net.thevpc.nuts.NutsEnum;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsHomeLocation;
import net.thevpc.nuts.NutsLogConfig;
import net.thevpc.nuts.NutsOpenMode;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsStoreLocationStrategy;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspaceOptions;
import net.thevpc.nuts.NutsWorkspaceOptionsFormat;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.spi.NutsBootVersion;

public class CoreNutsWorkspaceOptionsFormat
implements NutsWorkspaceOptionsFormat {
    private static final long serialVersionUID = 1L;
    private final NutsSession session;
    private final NutsWorkspaceOptions options;
    private boolean exportedOptions;
    private boolean runtimeOptions;
    private boolean createOptions;
    private boolean shortOptions;
    private boolean singleArgOptions;
    private boolean omitDefaults;

    public CoreNutsWorkspaceOptionsFormat(NutsSession session, NutsWorkspaceOptions options) {
        this.options = options;
        this.session = session;
    }

    public boolean isInit() {
        return this.createOptions;
    }

    public NutsWorkspaceOptionsFormat setInit(boolean e) {
        this.createOptions = true;
        return this;
    }

    public boolean isRuntime() {
        return this.runtimeOptions;
    }

    public NutsWorkspaceOptionsFormat setRuntime(boolean e) {
        this.runtimeOptions = true;
        return this;
    }

    public boolean isExported() {
        return this.exportedOptions;
    }

    public NutsWorkspaceOptionsFormat setExported(boolean e) {
        this.exportedOptions = true;
        return this;
    }

    public NutsCommandLine getBootCommandLine() {
        String apiVersion = this.options.getApiVersion();
        NutsVersion apiVersionObj = NutsBlankable.isBlank((String)apiVersion) ? null : NutsVersion.of((String)apiVersion, (NutsSession)this.session);
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.exportedOptions || this.isImplicitAll()) {
            NutsLogConfig logConfig;
            this.fillOption("--java", "-j", this.options.getJavaCommand(), arguments, false);
            this.fillOption("--java-options", "-O", this.options.getJavaOptions(), arguments, false);
            String wsString = this.options.getWorkspace();
            if (NutsBlankable.isBlank((String)wsString)) {
                wsString = "";
            } else if (wsString.contains("/") || wsString.contains("\\")) {
                wsString = CoreIOUtils.getAbsolutePath(wsString);
            }
            this.fillOption("--workspace", "-w", wsString, arguments, false);
            this.fillOption("--user", "-u", this.options.getUserName(), arguments, false);
            this.fillOption("--password", "-p", this.options.getCredentials(), arguments, false);
            this.fillOption("--boot-version", "-V", this.options.getApiVersion(), arguments, false);
            this.fillOption("--boot-runtime", null, this.options.getRuntimeId(), arguments, false);
            if (!this.omitDefaults || this.options.getTerminalMode() != null) {
                this.fillOption("--color", "-c", (Enum)this.options.getTerminalMode(), NutsTerminalMode.class, arguments, true);
            }
            if ((logConfig = this.options.getLogConfig()) != null) {
                if (logConfig.getLogTermLevel() != null && logConfig.getLogTermLevel() == logConfig.getLogFileLevel()) {
                    this.fillOption("--log-" + logConfig.getLogFileLevel().toString().toLowerCase(), null, true, false, arguments, false);
                } else {
                    if (logConfig.getLogTermLevel() != null) {
                        this.fillOption("--log-term-" + logConfig.getLogTermLevel().toString().toLowerCase(), null, true, false, arguments, false);
                    }
                    if (logConfig.getLogFileLevel() != null) {
                        this.fillOption("--log-file-" + logConfig.getLogFileLevel().toString().toLowerCase(), null, true, false, arguments, false);
                    }
                }
                if (logConfig.getLogFileCount() > 0) {
                    this.fillOption("--log-file-count", null, String.valueOf(logConfig.getLogFileCount()), arguments, false);
                }
                this.fillOption("--log-file-size", null, logConfig.getLogFileSize(), arguments, false);
                this.fillOption("--log-file-base", null, logConfig.getLogFileBase(), arguments, false);
                this.fillOption("--log-file-name", null, logConfig.getLogFileName(), arguments, false);
            }
            this.fillOption("--exclude-extension", "-X", this.options.getExcludedExtensions(), ";", arguments, false);
            if (apiVersionObj == null || apiVersionObj.compareTo("0.8.1") >= 0) {
                this.fillOption("--repositories", "-r", this.options.getRepositories(), ";", arguments, false);
            } else {
                this.fillOption("--repository", "-r", this.options.getRepositories(), ";", arguments, false);
            }
            this.fillOption("--global", "-g", this.options.isGlobal(), false, arguments, false);
            this.fillOption("--gui", null, this.options.isGui(), false, arguments, false);
            this.fillOption("--read-only", "-R", this.options.isReadOnly(), false, arguments, false);
            this.fillOption("--trace", "-t", this.options.isTrace(), true, arguments, false);
            this.fillOption("--progress", "-P", this.options.getProgressOptions(), arguments, true);
            this.fillOption("--solver", null, this.options.getDependencySolver(), arguments, false);
            if (apiVersionObj == null || apiVersionObj.compareTo("0.8.3") >= 0) {
                this.fillOption("--debug", null, this.options.getDebug(), arguments, true);
            } else {
                this.fillOption("--debug", null, this.options.getDebug() != null, false, arguments, true);
            }
            this.fillOption("--skip-companions", "-k", this.options.isSkipCompanions(), false, arguments, false);
            this.fillOption("--skip-welcome", "-K", this.options.isSkipWelcome(), false, arguments, false);
            this.fillOption("--out-line-prefix", null, this.options.getOutLinePrefix(), arguments, false);
            this.fillOption("--skip-boot", "-Q", this.options.isSkipBoot(), false, arguments, false);
            this.fillOption("--cached", null, this.options.isCached(), true, arguments, false);
            this.fillOption("--indexed", null, this.options.isIndexed(), true, arguments, false);
            this.fillOption("--transitive", null, this.options.isTransitive(), true, arguments, false);
            if (apiVersionObj == null || apiVersionObj.compareTo("0.8.1") >= 0) {
                this.fillOption("--bot", "-B", this.options.isBot(), false, arguments, false);
            }
            if (this.options.getFetchStrategy() != null && this.options.getFetchStrategy() != NutsFetchStrategy.ONLINE) {
                this.fillOption("--fetch", "-f", (Enum)this.options.getFetchStrategy(), NutsFetchStrategy.class, arguments, false);
            }
            this.fillOption((Enum)this.options.getConfirm(), arguments, false);
            this.fillOption((Enum)this.options.getOutputFormat(), arguments, false);
            String[] stringArray = this.options.getOutputFormatOptions();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                this.fillOption("--output-format-option", "-T", string, arguments, false);
            }
            if (apiVersionObj == null || apiVersionObj.compareTo("0.8.0") >= 0) {
                this.fillOption("--expire", "-N", this.options.getExpireTime() == null ? null : this.options.getExpireTime().toString(), arguments, false);
                if (this.options.getOutLinePrefix() != null && Objects.equals(this.options.getOutLinePrefix(), this.options.getErrLinePrefix()) && this.options.getOutLinePrefix().length() > 0) {
                    this.fillOption("--line-prefix", null, this.options.getOutLinePrefix(), arguments, false);
                } else {
                    if (this.options.getOutLinePrefix() != null && this.options.getOutLinePrefix().length() > 0) {
                        this.fillOption("--out-line-prefix", null, this.options.getOutLinePrefix(), arguments, false);
                    }
                    if (this.options.getErrLinePrefix() != null && this.options.getErrLinePrefix().length() > 0) {
                        this.fillOption("--err-line-prefix", null, this.options.getErrLinePrefix(), arguments, false);
                    }
                }
            }
            if (apiVersionObj == null || apiVersionObj.compareTo("0.8.1") >= 0) {
                this.fillOption("--theme", null, this.options.getTheme(), arguments, false);
            }
            if (apiVersionObj == null || apiVersionObj.compareTo("0.8.1") >= 0) {
                this.fillOption("--locale", "-L", this.options.getLocale(), arguments, false);
            }
        }
        if (this.createOptions || this.isImplicitAll()) {
            this.fillOption("--name", null, NutsUtilStrings.trim((String)this.options.getName()), arguments, false);
            this.fillOption("--archetype", "-A", this.options.getArchetype(), arguments, false);
            this.fillOption("--store-layout", null, (Enum)this.options.getStoreLocationLayout(), NutsOsFamily.class, arguments, false);
            this.fillOption("--store-strategy", null, (Enum)this.options.getStoreLocationStrategy(), NutsStoreLocationStrategy.class, arguments, false);
            this.fillOption("--repo-store-strategy", null, (Enum)this.options.getRepositoryStoreLocationStrategy(), NutsStoreLocationStrategy.class, arguments, false);
            Map storeLocations = this.options.getStoreLocations();
            for (NutsStoreLocation location : NutsStoreLocation.values()) {
                String string = (String)storeLocations.get(location);
                if (NutsBlankable.isBlank((String)string)) continue;
                this.fillOption("--" + location.id() + "-location", null, string, arguments, false);
            }
            Map homeLocations = this.options.getHomeLocations();
            if (homeLocations != null) {
                for (NutsStoreLocation nutsStoreLocation : NutsStoreLocation.values()) {
                    String s = (String)homeLocations.get(NutsHomeLocation.of(null, (NutsStoreLocation)nutsStoreLocation));
                    if (NutsBlankable.isBlank((String)s)) continue;
                    this.fillOption("--system-" + nutsStoreLocation.id() + "-home", null, s, arguments, false);
                }
                for (NutsStoreLocation nutsStoreLocation : NutsOsFamily.values()) {
                    for (NutsStoreLocation location : NutsStoreLocation.values()) {
                        String s = (String)homeLocations.get(NutsHomeLocation.of((NutsOsFamily)nutsStoreLocation, (NutsStoreLocation)location));
                        if (NutsBlankable.isBlank((String)s)) continue;
                        this.fillOption("--" + nutsStoreLocation.id() + "-" + location.id() + "-home", null, s, arguments, false);
                    }
                }
            }
            if ((apiVersionObj == null || apiVersionObj.compareTo("0.8.0") >= 0) && this.options.getSwitchWorkspace() != null) {
                this.fillOption("--switch", null, this.options.getSwitchWorkspace(), false, arguments, false);
            }
        }
        if (this.runtimeOptions || this.isImplicitAll()) {
            this.fillOption("--help", "-h", this.options.isCommandHelp(), false, arguments, false);
            this.fillOption("--version", "-v", this.options.isCommandVersion(), false, arguments, false);
            if (!this.omitDefaults || this.options.getOpenMode() != null && this.options.getOpenMode() != NutsOpenMode.OPEN_OR_CREATE) {
                this.fillOption((Enum)this.options.getOpenMode(), arguments, false);
            }
            this.fillOption((Enum)this.options.getExecutionType(), arguments, false);
            this.fillOption(this.options.getRunAs(), arguments);
            this.fillOption("--reset", "-Z", this.options.isReset(), false, arguments, false);
            this.fillOption("--recover", "-z", this.options.isRecover(), false, arguments, false);
            this.fillOption("--dry", "-D", this.options.isDry(), false, arguments, false);
            if (!this.omitDefaults || this.options.getExecutorOptions().length > 0) {
                arguments.add(this.selectOptionName("--exec", "-e"));
            }
            arguments.addAll(Arrays.asList(this.options.getExecutorOptions()));
            arguments.addAll(Arrays.asList(this.options.getApplicationArguments()));
        }
        if ((apiVersionObj == null || apiVersionObj.compareTo("0.8.1") >= 0) && this.options.getCustomOptions() != null) {
            arguments.addAll(Arrays.asList(this.options.getCustomOptions()));
        }
        return NutsCommandLine.of(arguments, (NutsSession)this.session);
    }

    public NutsWorkspaceOptionsFormat setCompact(boolean compact) {
        if (compact) {
            this.shortOptions = true;
            this.singleArgOptions = true;
            this.omitDefaults = true;
        } else {
            this.shortOptions = false;
            this.singleArgOptions = false;
            this.omitDefaults = false;
        }
        return this;
    }

    private boolean isImplicitAll() {
        return !this.exportedOptions && !this.runtimeOptions && !this.createOptions;
    }

    private void fillOption(String longName, String shortName, String[] values, String sep, List<String> arguments, boolean forceSingle) {
        if (values != null && values.length > 0) {
            this.fillOption0(this.selectOptionName(longName, shortName), String.join((CharSequence)sep, values), arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, boolean value, boolean defaultValue, List<String> arguments, boolean forceSingle) {
        if (defaultValue) {
            if (!value) {
                if (this.shortOptions && shortName != null) {
                    arguments.add("-!" + shortName.substring(1));
                } else {
                    arguments.add("--!" + longName.substring(2));
                }
            }
        } else if (value) {
            arguments.add(this.selectOptionName(longName, shortName));
        }
    }

    private void fillOption(String longName, String shortName, char[] value, List<String> arguments, boolean forceSingle) {
        if (value != null && new String(value).isEmpty()) {
            this.fillOption0(this.selectOptionName(longName, shortName), new String(value), arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, String value, List<String> arguments, boolean forceSingle) {
        if (!NutsBlankable.isBlank((String)value)) {
            this.fillOption0(this.selectOptionName(longName, shortName), value, arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, int value, List<String> arguments, boolean forceSingle) {
        if (value > 0) {
            this.fillOption0(this.selectOptionName(longName, shortName), String.valueOf(value), arguments, forceSingle);
        }
    }

    private void fillOption(String longName, String shortName, Enum value, Class enumType, List<String> arguments, boolean forceSingle) {
        if (this.tryFillOptionShort(value, arguments, forceSingle)) {
            return;
        }
        if (value != null) {
            if (this.shortOptions) {
                if (value instanceof NutsOsFamily) {
                    switch ((NutsOsFamily)value) {
                        case LINUX: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("linux", "l"), arguments, forceSingle);
                            return;
                        }
                        case WINDOWS: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("windows", "w"), arguments, forceSingle);
                            return;
                        }
                        case MACOS: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("macos", "m"), arguments, forceSingle);
                            return;
                        }
                        case UNIX: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("unix", "u"), arguments, forceSingle);
                            return;
                        }
                        case UNKNOWN: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("unknown", "x"), arguments, forceSingle);
                            return;
                        }
                    }
                } else if (value instanceof NutsStoreLocationStrategy) {
                    switch ((NutsStoreLocationStrategy)value) {
                        case EXPLODED: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("exploded", "e"), arguments, forceSingle);
                            return;
                        }
                        case STANDALONE: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("standalone", "s"), arguments, forceSingle);
                            return;
                        }
                    }
                } else if (value instanceof NutsTerminalMode) {
                    switch ((NutsTerminalMode)value) {
                        case FILTERED: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("no", "n"), arguments, forceSingle);
                            return;
                        }
                        case INHERITED: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("inherited", "h"), arguments, forceSingle);
                            return;
                        }
                        case FORMATTED: {
                            this.fillOption0(this.selectOptionName(longName, shortName), this.selectOptionVal("yes", "y"), arguments, forceSingle);
                            return;
                        }
                    }
                }
            }
            this.fillOption0(this.selectOptionName(longName, shortName), value.toString().toLowerCase(), arguments, forceSingle);
        } else if (enumType.equals(NutsTerminalMode.class)) {
            this.fillOption0(this.selectOptionName(longName, shortName), this.shortOptions ? "s" : "system", arguments, forceSingle);
        }
    }

    private boolean fillOption(NutsRunAs value, List<String> arguments) {
        String apiVersion = this.options.getApiVersion();
        switch (value.getMode()) {
            case CURRENT_USER: {
                if (!NutsBlankable.isBlank((String)apiVersion) && NutsBootVersion.parse((String)apiVersion).compareTo(NutsBootVersion.parse((String)"0.8.1")) < 0) {
                    arguments.add("--user-cmd");
                } else if (!this.omitDefaults) {
                    arguments.add("--current-user");
                }
                return true;
            }
            case ROOT: {
                if (!NutsBlankable.isBlank((String)apiVersion) && NutsBootVersion.parse((String)apiVersion).compareTo(NutsBootVersion.parse((String)"0.8.1")) < 0) {
                    arguments.add("--root-cmd");
                } else {
                    arguments.add("--as-root");
                }
                return true;
            }
            case SUDO: {
                if (NutsBlankable.isBlank((String)apiVersion) || NutsBootVersion.parse((String)apiVersion).compareTo(NutsBootVersion.parse((String)"0.8.1")) >= 0) {
                    arguments.add("--sudo");
                }
                return true;
            }
            case USER: {
                if (NutsBlankable.isBlank((String)apiVersion) || NutsBootVersion.parse((String)apiVersion).compareTo(NutsBootVersion.parse((String)"0.8.1")) >= 0) {
                    arguments.add("--run-as=" + value.getUser());
                }
                return true;
            }
        }
        throw new NutsUnsupportedEnumException(this.session, (Enum)value.getMode());
    }

    private boolean tryFillOptionShort(Enum value, List<String> arguments, boolean forceSingle) {
        String apiVersion = this.options.getApiVersion();
        if (value != null && this.shortOptions) {
            if (value instanceof NutsOpenMode) {
                switch ((NutsOpenMode)value) {
                    case OPEN_OR_ERROR: {
                        this.fillOption0(this.selectOptionName("--open-mode", "-o"), this.selectOptionVal("open-or-error", "r"), arguments, forceSingle);
                        return true;
                    }
                    case CREATE_OR_ERROR: {
                        this.fillOption0(this.selectOptionName("--open-mode", "-o"), this.selectOptionVal("create-or-error", "w"), arguments, forceSingle);
                        return true;
                    }
                    case OPEN_OR_CREATE: {
                        if (!this.omitDefaults) {
                            this.fillOption0(this.selectOptionName("--open-mode", "-o"), this.selectOptionVal("open-or-create", "rw"), arguments, forceSingle);
                        }
                        return true;
                    }
                    case OPEN_OR_NULL: {
                        this.fillOption0(this.selectOptionName("--open-mode", "-o"), this.selectOptionVal("open-or-null", "on"), arguments, forceSingle);
                        return true;
                    }
                }
            }
            if (value instanceof NutsExecutionType) {
                switch ((NutsExecutionType)value) {
                    case SYSTEM: {
                        if (!NutsBlankable.isBlank((String)apiVersion) && NutsBootVersion.parse((String)apiVersion).compareTo(NutsBootVersion.parse((String)"0.8.1")) < 0) {
                            arguments.add("--user-cmd");
                        } else {
                            arguments.add("--system");
                        }
                        return true;
                    }
                    case EMBEDDED: {
                        arguments.add(this.selectOptionName("--embedded", "-b"));
                        return true;
                    }
                    case SPAWN: {
                        if (!this.omitDefaults) {
                            arguments.add(this.selectOptionName("--spawn", "-x"));
                        }
                        return true;
                    }
                    case OPEN: {
                        arguments.add(this.selectOptionName("--open-file", "--open-file"));
                        return true;
                    }
                }
            }
            if (value instanceof NutsConfirmationMode) {
                switch ((NutsConfirmationMode)value) {
                    case YES: {
                        arguments.add(this.selectOptionName("--yes", "-y"));
                        return true;
                    }
                    case NO: {
                        arguments.add(this.selectOptionName("-no", "-n"));
                        return true;
                    }
                    case ASK: {
                        if (this.omitDefaults) break;
                        arguments.add("--ask");
                        return true;
                    }
                    case ERROR: {
                        arguments.add("--error");
                        return true;
                    }
                }
            }
            if (value instanceof NutsTerminalMode) {
                switch ((NutsTerminalMode)value) {
                    case FILTERED: {
                        arguments.add(this.selectOptionName("--!color", "-!c"));
                        return true;
                    }
                    case FORMATTED: {
                        arguments.add(this.selectOptionName("--color", "-c"));
                        return true;
                    }
                    case INHERITED: {
                        arguments.add(this.selectOptionName("--color=inherited", "-c=h"));
                        return true;
                    }
                    case ANSI: {
                        arguments.add(this.selectOptionName("--color=ansi", "-c=a"));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void fillOption(Enum value, List<String> arguments, boolean forceSingle) {
        if (value != null) {
            if (this.tryFillOptionShort(value, arguments, forceSingle)) {
                return;
            }
            if (value instanceof NutsEnum) {
                arguments.add("--" + ((NutsEnum)value).id());
            } else {
                arguments.add("--" + value.toString().toLowerCase().replace('_', '-'));
            }
        }
    }

    private String selectOptionVal(String longName, String shortName) {
        if (this.shortOptions) {
            return shortName;
        }
        return longName;
    }

    private String selectOptionName(String longName, String shortName) {
        if (this.shortOptions && shortName != null) {
            return shortName;
        }
        return longName;
    }

    private void fillOption0(String name, String value, List<String> arguments, boolean forceSingle) {
        if (this.singleArgOptions || forceSingle) {
            arguments.add(name + "=" + value);
        } else {
            arguments.add(name);
            arguments.add(value);
        }
    }

    public int hashCode() {
        return Objects.hash(this.exportedOptions, this.runtimeOptions, this.createOptions, this.shortOptions, this.singleArgOptions, this.omitDefaults, this.options);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreNutsWorkspaceOptionsFormat that = (CoreNutsWorkspaceOptionsFormat)o;
        return this.exportedOptions == that.exportedOptions && this.runtimeOptions == that.runtimeOptions && this.createOptions == that.createOptions && this.shortOptions == that.shortOptions && this.singleArgOptions == that.singleArgOptions && this.omitDefaults == that.omitDefaults && Objects.equals(this.options, that.options);
    }

    public String toString() {
        return this.getBootCommandLine().toString();
    }
}

