/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.runtime.standalone.workspace.config.NutsWorkspaceConfigBoot;

public class NutsExtensionListHelper {
    private List<NutsWorkspaceConfigBoot.ExtensionConfig> initial = new ArrayList<NutsWorkspaceConfigBoot.ExtensionConfig>();
    private List<NutsWorkspaceConfigBoot.ExtensionConfig> list = new ArrayList<NutsWorkspaceConfigBoot.ExtensionConfig>();
    private NutsId apiId;

    public NutsExtensionListHelper(NutsId apiId, List<NutsWorkspaceConfigBoot.ExtensionConfig> old) {
        this.apiId = apiId;
        if (old != null) {
            for (NutsWorkspaceConfigBoot.ExtensionConfig a : old) {
                if (a == null) continue;
                this.list.add(a);
            }
        }
    }

    public NutsExtensionListHelper save() {
        this.initial = new ArrayList<NutsWorkspaceConfigBoot.ExtensionConfig>(this.list);
        this.compress();
        return this;
    }

    public boolean hasChanged() {
        return !this.initial.equals(this.list);
    }

    public NutsExtensionListHelper copy() {
        return new NutsExtensionListHelper(this.apiId, this.list);
    }

    public NutsExtensionListHelper compress() {
        LinkedHashMap<String, NutsWorkspaceConfigBoot.ExtensionConfig> m = new LinkedHashMap<String, NutsWorkspaceConfigBoot.ExtensionConfig>();
        for (NutsWorkspaceConfigBoot.ExtensionConfig id : this.list) {
            m.put(id.getId().getShortName(), new NutsWorkspaceConfigBoot.ExtensionConfig(id.getId().getLongId(), id.getDependencies(), id.isEnabled()));
        }
        this.list.clear();
        this.list.addAll(m.values());
        return this;
    }

    public boolean add(NutsId id, NutsDependency[] dependencies) {
        String dependenciesString = Arrays.stream(dependencies).map(Object::toString).collect(Collectors.joining(";"));
        for (int i = 0; i < this.list.size(); ++i) {
            NutsWorkspaceConfigBoot.ExtensionConfig z;
            NutsWorkspaceConfigBoot.ExtensionConfig o;
            NutsWorkspaceConfigBoot.ExtensionConfig a = this.list.get(i);
            if (!a.getId().getShortName().equals(id.getShortName()) || Objects.equals((Object)(o = this.list.get(i)), (Object)(z = new NutsWorkspaceConfigBoot.ExtensionConfig(id, dependenciesString, true)))) continue;
            this.list.set(i, z);
            return true;
        }
        NutsWorkspaceConfigBoot.ExtensionConfig z = new NutsWorkspaceConfigBoot.ExtensionConfig(id, dependenciesString, true);
        this.list.add(z);
        return true;
    }

    public boolean remove(NutsId id) {
        for (int i = 0; i < this.list.size(); ++i) {
            NutsWorkspaceConfigBoot.ExtensionConfig a = this.list.get(i);
            if (!a.getId().getShortName().equals(id.getShortName())) continue;
            this.list.remove(i);
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.list);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsExtensionListHelper other = (NutsExtensionListHelper)obj;
        return Objects.equals(this.list, other.list);
    }

    public List<NutsId> getIds() {
        ArrayList<NutsId> ids = new ArrayList<NutsId>();
        for (NutsWorkspaceConfigBoot.ExtensionConfig i : this.list) {
            ids.add(i.getId());
        }
        return ids;
    }

    public List<NutsWorkspaceConfigBoot.ExtensionConfig> getConfs() {
        ArrayList<NutsWorkspaceConfigBoot.ExtensionConfig> copy = new ArrayList<NutsWorkspaceConfigBoot.ExtensionConfig>();
        for (NutsWorkspaceConfigBoot.ExtensionConfig i : this.list) {
            copy.add(new NutsWorkspaceConfigBoot.ExtensionConfig(i.getId(), i.getDependencies(), i.isEnabled()));
        }
        return copy;
    }
}

