/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.extension;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsServiceLoader;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspaceExtensionManager;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNutsWorkspaceExtensionModel;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsComponent;

public class DefaultNutsWorkspaceExtensionManager
implements NutsWorkspaceExtensionManager {
    private DefaultNutsWorkspaceExtensionModel model;
    private NutsSession session;

    public DefaultNutsWorkspaceExtensionManager(DefaultNutsWorkspaceExtensionModel model) {
        this.model = model;
    }

    public DefaultNutsWorkspaceExtensionModel getModel() {
        return this.model;
    }

    public Set<NutsId> getCompanionIds() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.getSession());
        NutsIdParser parser = NutsIdParser.of((NutsSession)this.getSession());
        return Collections.unmodifiableSet(new HashSet<NutsId>(Arrays.asList(parser.parse("net.thevpc.nuts.toolbox:nsh"))));
    }

    public boolean installWorkspaceExtensionComponent(Class extensionPointType, Object extensionImpl) {
        this.checkSession();
        return this.model.installWorkspaceExtensionComponent(extensionPointType, extensionImpl, this.session);
    }

    public Set<Class> discoverTypes(NutsId id, ClassLoader classLoader) {
        this.checkSession();
        return this.model.discoverTypes(id, classLoader, this.session);
    }

    public <T extends NutsComponent, B> NutsServiceLoader<T> createServiceLoader(Class<T> serviceType, Class<B> criteriaType) {
        this.checkSession();
        return this.model.createServiceLoader(serviceType, criteriaType, this.session);
    }

    public <T extends NutsComponent, B> NutsServiceLoader<T> createServiceLoader(Class<T> serviceType, Class<B> criteriaType, ClassLoader classLoader) {
        this.checkSession();
        return this.model.createServiceLoader(serviceType, criteriaType, classLoader, this.session);
    }

    public <T extends NutsComponent, V> T createSupported(Class<T> serviceType, boolean required, V criteriaType) {
        this.checkSession();
        return this.model.createSupported(serviceType, criteriaType, required, this.session);
    }

    public <T extends NutsComponent, V> List<T> createAllSupported(Class<T> serviceType, V criteriaType) {
        this.checkSession();
        return this.model.createAllSupported(serviceType, criteriaType, this.session);
    }

    public <T> List<T> createAll(Class<T> serviceType) {
        this.checkSession();
        return this.model.createAll(serviceType, this.session);
    }

    public Set<Class> getExtensionTypes(Class extensionPoint) {
        this.checkSession();
        return this.model.getExtensionTypes(extensionPoint, this.session);
    }

    public List<Object> getExtensionObjects(Class extensionPoint) {
        this.checkSession();
        return this.model.getExtensionObjects(extensionPoint, this.session);
    }

    public boolean isRegisteredType(Class extensionPointType, String name) {
        this.checkSession();
        return this.model.isRegisteredType(extensionPointType, name, this.session);
    }

    public boolean isRegisteredInstance(Class extensionPointType, Object extensionImpl) {
        this.checkSession();
        return this.model.isRegisteredInstance(extensionPointType, extensionImpl, this.session);
    }

    public boolean registerInstance(Class extensionPointType, Object extensionImpl) {
        this.checkSession();
        return this.model.registerInstance(extensionPointType, extensionImpl, this.session);
    }

    public boolean registerType(Class extensionPointType, Class extensionType, NutsId source) {
        this.checkSession();
        return this.model.registerType(extensionPointType, extensionType, source, this.session);
    }

    public boolean isRegisteredType(Class extensionPointType, Class extensionType) {
        this.checkSession();
        return this.model.isRegisteredType(extensionPointType, extensionType, this.session);
    }

    public boolean isLoadedExtensions(NutsId id) {
        this.checkSession();
        return this.model.isLoadedExtensions(id, this.session);
    }

    public List<NutsId> getLoadedExtensions() {
        this.checkSession();
        return this.model.getLoadedExtensions(this.session);
    }

    public NutsWorkspaceExtensionManager loadExtension(NutsId extension) {
        this.checkSession();
        this.model.loadExtension(extension, this.session);
        return this;
    }

    public NutsWorkspaceExtensionManager unloadExtension(NutsId extension) {
        this.checkSession();
        this.model.unloadExtension(extension, this.session);
        return this;
    }

    public List<NutsId> getConfigExtensions() {
        this.checkSession();
        return this.model.getConfigExtensions(this.session);
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsWorkspaceExtensionManager setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.model.getWorkspace(), session);
        return this;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.model.getWorkspace(), this.session);
    }
}

