/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import net.thevpc.nuts.NutsServiceLoader;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.spi.NutsComponent;
import net.thevpc.nuts.spi.NutsDefaultSupportLevelContext;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsServiceLoader<T extends NutsComponent, B>
implements NutsServiceLoader<T> {
    private final ClassLoader classLoader;
    private final Class<T> serviceType;
    private final Class<B> criteriaType;
    private final ServiceLoader<T> loader;
    private final NutsSession session;

    public DefaultNutsServiceLoader(NutsSession session, Class<T> serviceType, Class<B> criteriaType, ClassLoader classLoader) {
        this.session = session;
        this.classLoader = classLoader;
        this.serviceType = serviceType;
        this.criteriaType = criteriaType;
        this.loader = ServiceLoader.load(serviceType, classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader);
    }

    public List<T> loadAll(Object criteria) {
        ArrayList<NutsComponent> all = new ArrayList<NutsComponent>();
        NutsDefaultSupportLevelContext c = new NutsDefaultSupportLevelContext(this.session, criteria);
        for (NutsComponent t : this.loader) {
            int p = t.getSupportLevel((NutsSupportLevelContext)c);
            if (p <= -1) continue;
            all.add(t);
        }
        return all;
    }

    public T loadBest(Object criteria) {
        NutsComponent best = null;
        int bestVal = -1;
        NutsDefaultSupportLevelContext c = new NutsDefaultSupportLevelContext(this.session, criteria);
        for (NutsComponent t : this.loader) {
            int p = t.getSupportLevel((NutsSupportLevelContext)c);
            if (p <= -1 || best != null && bestVal >= p) continue;
            best = t;
            bestVal = p;
        }
        return (T)best;
    }
}

