/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.executor.system.ProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.io.util.IProcessExecHelper;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsExecutorComponent;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class ProcessExecutorComponent
implements NutsExecutorComponent {
    public static NutsId ID;
    NutsSession ws;

    public NutsId getId() {
        return ID;
    }

    public int getSupportLevel(NutsSupportLevelContext nutsDefinition) {
        this.ws = nutsDefinition.getSession();
        if (ID == null) {
            ID = NutsId.of((String)"net.thevpc.nuts.exec:exec-native", (NutsSession)this.ws);
        }
        return 10;
    }

    public void exec(NutsExecutionContext executionContext) {
        this.execHelper(executionContext).exec();
    }

    public void dryExec(NutsExecutionContext executionContext) throws NutsExecutionException {
        this.execHelper(executionContext).dryExec();
    }

    public IProcessExecHelper execHelper(NutsExecutionContext executionContext) {
        NutsDefinition nutMainFile = executionContext.getDefinition();
        NutsPath storeFolder = nutMainFile.getInstallInformation().getInstallFolder();
        String[] execArgs = executionContext.getExecutorArguments();
        String[] appArgs = executionContext.getArguments();
        ArrayList<String> app = new ArrayList<String>(Arrays.asList(appArgs));
        if (app.isEmpty()) {
            if (storeFolder == null) {
                app.add("${nuts.file}");
            } else {
                app.add("${nuts.store}/run");
            }
        }
        HashMap<String, String> osEnv = new HashMap<String, String>();
        String bootArgumentsString = executionContext.getSession().boot().getBootOptions().formatter().setExported(true).setCompact(true).getBootCommandLine().toString();
        osEnv.put("nuts_boot_args", bootArgumentsString);
        String dir = null;
        boolean showCommand = executionContext.getSession().boot().getBootCustomBoolArgument(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), new String[]{"---show-command"});
        for (int i = 0; i < execArgs.length; ++i) {
            String arg = execArgs[i];
            if (arg.equals("--show-command") || arg.equals("-show-command")) {
                showCommand = true;
                continue;
            }
            if (arg.equals("--dir") || arg.equals("-dir")) {
                dir = execArgs[++i];
                continue;
            }
            if (!arg.startsWith("--dir=") && !arg.startsWith("-dir=")) continue;
            dir = execArgs[i].substring(arg.indexOf(61) + 1);
        }
        String directory = NutsBlankable.isBlank(dir) ? null : NutsPath.of(dir, (NutsSession)executionContext.getSession()).toAbsolute().toString();
        return ProcessExecHelper.ofDefinition(nutMainFile, app.toArray(new String[0]), osEnv, directory, executionContext.getExecutorProperties(), showCommand, true, executionContext.getSleepMillis(), false, false, null, null, executionContext.getRunAs(), executionContext.getSession(), executionContext.getExecSession());
    }
}

