/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.system;

import java.io.OutputStream;
import java.util.logging.Level;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.io.util.NonBlockingInputStream;
import net.thevpc.nuts.runtime.standalone.io.util.StopMonitor;

public class PipeRunnable
implements Runnable,
StopMonitor {
    private final NonBlockingInputStream in;
    private final OutputStream out;
    private final Object lock = new Object();
    private long pipedBytesCount = 0L;
    private boolean requestStop = false;
    private boolean stopped = false;
    private final NutsSession session;
    private final String cmd;
    private final String desc;
    private final String name;
    private final boolean renameThread;
    private byte[] bytesBuffer = new byte[10240];

    public PipeRunnable(String name, String cmd, String desc, NonBlockingInputStream in, OutputStream out, boolean renameThread, NutsSession session) {
        this.name = name;
        this.renameThread = renameThread;
        this.in = in;
        this.out = out;
        this.session = session;
        this.cmd = cmd;
        this.desc = desc;
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getDesc() {
        return this.desc;
    }

    @Override
    public boolean shouldStop() {
        return this.requestStop;
    }

    public void requestStop() {
        this.requestStop = true;
    }

    public boolean incrementalCopy() {
        if (this.in.hasMoreBytes()) {
            try {
                int count = this.in.readNonBlocking(this.bytesBuffer, 500L);
                if (count > 0) {
                    this.pipedBytesCount += (long)count;
                    this.out.write(this.bytesBuffer, 0, count);
                    this.out.flush();
                    return true;
                }
            }
            catch (Exception ex) {
                NutsLoggerOp.of(PipeRunnable.class, (NutsSession)this.session).error((Throwable)ex).level(Level.FINEST).verb(NutsLogVerb.WARNING).log(NutsMessage.jstyle((String)"pipe-thread exits with error: {0}", (Object[])new Object[]{ex}));
                this.markAsEffectivelyStopped();
            }
        } else {
            this.markAsEffectivelyStopped();
        }
        return false;
    }

    private void markAsEffectivelyStopped() {
        if (!this.stopped) {
            this.stopped = true;
        }
    }

    public boolean runOnce() {
        if (!this.incrementalCopy()) {
            if (this.isStopped()) {
                return false;
            }
            if (this.shouldStop()) {
                this.markAsEffectivelyStopped();
                return false;
            }
        }
        return true;
    }

    @Override
    public void run() {
        String oldThreadName = null;
        Thread currentThread = null;
        if (this.renameThread) {
            currentThread = Thread.currentThread();
            oldThreadName = currentThread.getName();
            currentThread.setName(this.name);
        }
        try {
            while (this.runOnce()) {
            }
        }
        finally {
            this.markAsEffectivelyStopped();
            if (this.renameThread && currentThread != null) {
                currentThread.setName(oldThreadName);
            }
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public NonBlockingInputStream getIn() {
        return this.in;
    }

    public OutputStream getOut() {
        return this.out;
    }
}

