/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.system;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.executor.system.PipeRunnable;
import net.thevpc.nuts.runtime.standalone.io.util.NonBlockingInputStream;

public class NutsSysExecUtils {
    public static Path sysWhich(String commandName) {
        Path[] p = NutsSysExecUtils.sysWhichAll(commandName);
        if (p.length > 0) {
            return p[0];
        }
        return null;
    }

    public static Path[] sysWhichAll(String commandName) {
        if (commandName == null || commandName.isEmpty()) {
            return new Path[0];
        }
        ArrayList<Path> all = new ArrayList<Path>();
        String p = System.getenv("PATH");
        if (p != null) {
            for (String s : p.split(File.pathSeparator)) {
                try {
                    Path c;
                    if (s.trim().isEmpty() || !Files.isRegularFile(c = Paths.get(s, commandName), new LinkOption[0]) || !Files.isExecutable(c)) continue;
                    all.add(c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return all.toArray(new Path[0]);
    }

    public static PipeRunnable pipe(String name, String cmd, String desc, NonBlockingInputStream in, OutputStream out, NutsSession session) {
        return new PipeRunnable(name, cmd, desc, in, out, true, session);
    }
}

