/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.java;

import java.io.File;
import java.nio.file.Path;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefaultContent;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsExecutionContext;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsTmp;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNutsDefinition;
import net.thevpc.nuts.runtime.standalone.executor.java.JavaExecutorComponent;
import net.thevpc.nuts.runtime.standalone.util.collections.CoreArrayUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsExecutorComponent;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class JavaSourceExecutorComponent
implements NutsExecutorComponent {
    public static NutsId ID;
    NutsSession ws;

    public NutsId getId() {
        return ID;
    }

    public void exec(NutsExecutionContext executionContext) {
        NutsDefinition nutMainFile = executionContext.getDefinition();
        Path javaFile = nutMainFile.getFile();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        NutsSession session = executionContext.getSession();
        Path folder = NutsTmp.of((NutsSession)session).createTempFolder("jj").toFile();
        int res = compiler.run(null, null, null, "-d", folder.toString(), javaFile.toString());
        if (res != 0) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"compilation failed", (Object[])new Object[0]), res);
        }
        JavaExecutorComponent cc = new JavaExecutorComponent();
        NutsDefinition d = executionContext.getDefinition();
        d = new DefaultNutsDefinition(d, session);
        ((DefaultNutsDefinition)d).setContent((NutsContent)new NutsDefaultContent(NutsPath.of((Path)folder, (NutsSession)session), false, true));
        String fileName = javaFile.getFileName().toString();
        NutsExecutionContext executionContext2 = NutsWorkspaceExt.of(executionContext.getSession()).createExecutionContext().setAll(executionContext).setDefinition(d).setExecutorArguments(CoreArrayUtils.concatArrays(executionContext.getExecutorArguments(), {"--main-class", new File(fileName.substring(fileName.length() - ".java".length())).getName(), "--class-path", folder.toString()})).setFailFast(true).setTemporary(true).build();
        cc.exec(executionContext2);
    }

    public void dryExec(NutsExecutionContext executionContext) throws NutsExecutionException {
        NutsDefinition nutMainFile = executionContext.getDefinition();
        Path javaFile = nutMainFile.getFile();
        String folder = "__temp_folder";
        NutsPrintStream out = executionContext.getSession().out();
        out.println((NutsString)NutsTexts.of((NutsSession)executionContext.getSession()).ofStyled("compile", NutsTextStyle.primary4()));
        out.printf("%s%n", new Object[]{NutsCommandLine.of((String[])new String[]{"embedded-javac", "-d", "<temp-folder>", javaFile.toString()}, (NutsSession)executionContext.getSession())});
        JavaExecutorComponent cc = new JavaExecutorComponent();
        NutsDefinition d = executionContext.getDefinition();
        d = new DefaultNutsDefinition(d, executionContext.getSession());
        ((DefaultNutsDefinition)d).setContent((NutsContent)new NutsDefaultContent(NutsPath.of((String)folder, (NutsSession)executionContext.getSession()), false, true));
        String fileName = javaFile.getFileName().toString();
        NutsExecutionContext executionContext2 = NutsWorkspaceExt.of(executionContext.getSession()).createExecutionContext().setAll(executionContext).setDefinition(d).setExecutorArguments(CoreArrayUtils.concatArrays(executionContext.getExecutorArguments(), {"--main-class", new File(fileName.substring(fileName.length() - ".java".length())).getName(), "--class-path", folder.toString()})).setFailFast(true).setTemporary(true).build();
        cc.dryExec(executionContext2);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        NutsDefinition def;
        this.ws = context.getSession();
        if (ID == null) {
            ID = NutsId.of((String)"net.thevpc.nuts.exec:exec-java-src", (NutsSession)this.ws);
        }
        if ((def = (NutsDefinition)context.getConstraints(NutsDefinition.class)) != null && "java".equals(def.getDescriptor().getPackaging())) {
            return 11;
        }
        return -1;
    }
}

