/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.java;

import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsClassLoaderNode;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsExecutionEntries;
import net.thevpc.nuts.NutsExecutionEntry;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSearchCommand;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsValidationException;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.dependency.util.NutsClassLoaderUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreNumberUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.util.NutsJavaSdkUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;

public final class JavaExecutorOptions {
    private String javaVersion = null;
    private String javaCommand = null;
    private String mainClass = null;
    private String dir = null;
    private boolean javaw = false;
    private boolean mainClassApp = false;
    private boolean excludeBase = false;
    private boolean showCommand;
    private boolean jar = false;
    private String[] execArgs;
    private List<String> jvmArgs = new ArrayList<String>();
    private List<String> app;
    private NutsSession session;
    private List<NutsClassLoaderNode> classPath = new ArrayList<NutsClassLoaderNode>();

    public JavaExecutorOptions(NutsDefinition def, boolean tempId, String[] args, String[] executorOptions, String dir, NutsSession session) {
        this.session = session;
        this.showCommand = this.getSession().boot().getBootCustomBoolArgument(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), new String[]{"---show-command"});
        NutsId id = def.getId();
        NutsDescriptor descriptor = null;
        if (tempId) {
            descriptor = def.getDescriptor();
            id = descriptor.getId();
        } else {
            descriptor = NutsWorkspaceUtils.of(this.getSession()).getEffectiveDescriptor(def);
            if (!CoreNutsUtils.isEffectiveId(id)) {
                id = descriptor.getId();
            }
        }
        Path path = def.getFile();
        this.app = new ArrayList<String>(Arrays.asList(args));
        this.dir = dir;
        this.execArgs = executorOptions;
        NutsCommandLine cmdLine = NutsCommandLine.of((String[])this.getExecArgs(), (NutsSession)session).setExpandSimpleOptions(false);
        ArrayList<NutsClassLoaderNode> currentCP = new ArrayList<NutsClassLoaderNode>();
        block48: while (cmdLine.hasNext()) {
            NutsArgument a = cmdLine.peek();
            switch (a.getKey().getString()) {
                case "--java-version": 
                case "-java-version": {
                    this.javaVersion = cmdLine.nextString(new String[0]).getValue().getString();
                    continue block48;
                }
                case "--java-home": 
                case "-java-home": {
                    this.javaCommand = cmdLine.nextString(new String[0]).getValue().getString();
                    continue block48;
                }
                case "--class-path": 
                case "-class-path": 
                case "--classpath": 
                case "-classpath": 
                case "--cp": 
                case "-cp": {
                    NutsDependency[] r = cmdLine.nextString(new String[0]).getValue().getString();
                    this.addCp(currentCP, (String)r);
                    continue block48;
                }
                case "--nuts-path": 
                case "-nuts-path": 
                case "--nutspath": 
                case "-nutspath": 
                case "--np": 
                case "-np": {
                    this.addNp(currentCP, cmdLine.nextString(new String[0]).getValue().getString());
                    continue block48;
                }
                case "--main-class": 
                case "-main-class": 
                case "--class": 
                case "-class": {
                    this.mainClass = cmdLine.nextString(new String[0]).getValue().getString();
                    continue block48;
                }
                case "--dir": 
                case "-dir": {
                    this.dir = cmdLine.nextString(new String[0]).getValue().getString();
                    continue block48;
                }
                case "--win": 
                case "--javaw": {
                    this.javaw = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                    continue block48;
                }
                case "--jar": 
                case "-jar": {
                    this.jar = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                    continue block48;
                }
                case "--show-command": 
                case "-show-command": {
                    this.showCommand = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                    continue block48;
                }
                case "--exclude-base": 
                case "-exclude-base": {
                    this.excludeBase = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                    continue block48;
                }
            }
            this.getJvmArgs().add(cmdLine.next().getString());
        }
        this.javaCommand = this.getJavaCommand() == null ? (this.javaw ? (!NutsBlankable.isBlank((String)this.getJavaVersion()) ? "${javaw#" + this.getJavaVersion() + "}" : "${javaw}") : (!NutsBlankable.isBlank((String)this.getJavaVersion()) ? "${java#" + this.getJavaVersion() + "}" : "${java}")) : NutsJavaSdkUtils.of(session).resolveJavaCommandByHome(this.getJavaCommand(), session);
        ArrayList nutsDefinitions = new ArrayList();
        NutsSearchCommand se = session.search().setSession(session);
        if (tempId) {
            for (NutsDependency dependency : descriptor.getDependencies()) {
                se.addId(dependency.toId());
            }
        } else {
            se.addId(id);
        }
        if (se.getIds().length > 0) {
            nutsDefinitions.addAll(se.setSession(se.getSession().copy().setTransitive(Boolean.valueOf(true))).setDistinct(true).setContent(true).setDependencies(true).setLatest(true).setOptional(Boolean.valueOf(false)).addScope(NutsDependencyScopePattern.RUN).setDependencyFilter(NutsDependencyFilters.of((NutsSession)session).byRunnable()).getResultDefinitions().toList());
        }
        if (this.jar) {
            if (this.mainClass != null && session.isPlainOut()) {
                session.getTerminal().err().printf("ignored main-class=%s. running jar!%n", new Object[]{this.getMainClass()});
            }
            if (!currentCP.isEmpty() && session.isPlainOut()) {
                session.getTerminal().err().printf("ignored class-path=%s. running jar!%n", new Object[]{currentCP.stream().map(x -> x.getURL().toString()).collect(Collectors.joining(","))});
            }
            if (this.excludeBase) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"cannot exclude base with jar modifier", (Object[])new Object[0]));
            }
        } else {
            List<String> possibleClasses;
            String r;
            NutsExecutionEntry[] classes;
            if (this.mainClass == null) {
                if (path != null && (classes = NutsExecutionEntries.of((NutsSession)session).parse(path)).length > 0) {
                    this.mainClass = String.join((CharSequence)":", Arrays.stream(classes).map(NutsExecutionEntry::getName).collect(Collectors.toList()));
                }
            } else if (!this.mainClass.contains(".") && (r = this.resolveMainClass(this.mainClass, possibleClasses = Arrays.stream(classes = NutsExecutionEntries.of((NutsSession)session).parse(path)).map(NutsExecutionEntry::getName).collect(Collectors.toList()))) != null) {
                this.mainClass = r;
            }
            if (this.mainClass == null) {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing Main Class for %s", (Object[])new Object[]{id}));
            }
            boolean baseDetected = false;
            for (NutsDefinition nutsDefinition : nutsDefinitions) {
                if (nutsDefinition.getFile() == null) continue;
                if (id.getLongName().equals(nutsDefinition.getId().getLongName())) {
                    baseDetected = true;
                    if (this.isExcludeBase()) continue;
                    currentCP.add(NutsClassLoaderUtils.definitionToClassLoaderNode(nutsDefinition, session));
                    continue;
                }
                currentCP.add(NutsClassLoaderUtils.definitionToClassLoaderNode(nutsDefinition, session));
            }
            if (!this.isExcludeBase() && !baseDetected) {
                if (path == null) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing path for %s", (Object[])new Object[]{id}));
                }
                currentCP.add(0, NutsClassLoaderUtils.definitionToClassLoaderNode(def, session));
            }
            this.classPath.addAll(currentCP);
            if (this.mainClass.contains(":")) {
                possibleClasses = StringTokenizerUtils.split(this.getMainClass(), ":");
                switch (possibleClasses.size()) {
                    case 0: {
                        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing Main-Class in Manifest for %s", (Object[])new Object[]{id}));
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        if (!session.isPlainOut() || session.isBot()) {
                            throw new NutsExecutionException(session, NutsMessage.cstyle((String)("multiple runnable classes detected : %s" + possibleClasses), (Object[])new Object[0]), 102);
                        }
                        NutsTexts text = NutsTexts.of((NutsSession)session);
                        NutsTextBuilder msgString = text.builder();
                        msgString.append((Object)"multiple runnable classes detected  - actually ").append((NutsText)text.ofStyled("" + possibleClasses.size(), NutsTextStyle.primary5())).append((Object)" . Select one :\n");
                        int x2 = (int)Math.log(possibleClasses.size()) + 2;
                        for (int i = 0; i < possibleClasses.size(); ++i) {
                            StringBuilder clsIndex = new StringBuilder();
                            clsIndex.append(i + 1);
                            while (clsIndex.length() < x2) {
                                clsIndex.append(' ');
                            }
                            msgString.append((Object)clsIndex.toString(), NutsTextStyle.primary4());
                            msgString.append(possibleClasses.get(i), NutsTextStyle.primary4());
                            msgString.append((Object)"\n");
                        }
                        msgString.append((Object)"enter class ").append((Object)"#", NutsTextStyle.primary5()).append((Object)" or ").append((Object)"name", NutsTextStyle.primary5()).append((Object)" to run it. type ").append((Object)"cancel!", NutsTextStyle.error()).append((Object)" to cancel : ");
                        this.mainClass = (String)session.getTerminal().ask().resetLine().setSession(session).forString(msgString.toString(), new Object[0]).setValidator((value, question) -> {
                            Integer anyInt = CoreNumberUtils.convertToInteger(value, null);
                            if (anyInt != null) {
                                int i = anyInt;
                                if (i >= 1 && i <= possibleClasses.size()) {
                                    return (String)possibleClasses.get(i - 1);
                                }
                            } else {
                                for (String possibleClass : possibleClasses) {
                                    if (!possibleClass.equals(value)) continue;
                                    return possibleClass;
                                }
                            }
                            throw new NutsValidationException(session);
                        }).getValue();
                        break;
                    }
                }
            }
        }
    }

    private String resolveMainClass(String name, List<String> possibleClasses) {
        if (name != null) {
            Integer v = CoreNumberUtils.convertToInteger(name, null);
            if (v != null) {
                int i;
                if (v >= 1 && v <= possibleClasses.size()) {
                    return possibleClasses.get(v - 1);
                }
                if (v < 0 && (i = possibleClasses.size() + v) >= 0 && i < possibleClasses.size()) {
                    return possibleClasses.get(i);
                }
            } else {
                int x;
                if (possibleClasses.contains(name)) {
                    return name;
                }
                ArrayList<String> extraPossibilities = new ArrayList<String>();
                for (String possibleClass : possibleClasses) {
                    x = possibleClass.lastIndexOf(46);
                    if (x <= 0 || !possibleClass.substring(x + 1).equals(name)) continue;
                    extraPossibilities.add(possibleClass);
                }
                if (extraPossibilities.size() == 1) {
                    return (String)extraPossibilities.get(0);
                }
                if (extraPossibilities.size() > 1) {
                    throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"ambiguous main-class %s matches all of %s", (Object[])new Object[]{name, ((Object)extraPossibilities).toString()}));
                }
                for (String possibleClass : possibleClasses) {
                    x = possibleClass.lastIndexOf(46);
                    if (x <= 0 || !possibleClass.substring(x + 1).equalsIgnoreCase(name)) continue;
                    extraPossibilities.add(possibleClass);
                }
                if (extraPossibilities.size() == 1) {
                    return (String)extraPossibilities.get(0);
                }
                if (extraPossibilities.size() > 1) {
                    throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"ambiguous main-class %s matches all of from %s", (Object[])new Object[]{name, ((Object)extraPossibilities).toString()}));
                }
            }
        }
        return null;
    }

    private void addCp(List<NutsClassLoaderNode> classPath, String value) {
        if (value == null) {
            value = "";
        }
        boolean files = value.matches("([^:]+\\.jar[:;]?.*)");
        boolean nutsIds = value.matches("(.*[:#?].*)");
        if (nutsIds && !files) {
            this.addNp(classPath, value);
        } else {
            for (String n : StringTokenizerUtils.split(value, ":")) {
                if (NutsBlankable.isBlank((String)n)) continue;
                URL url = NutsPath.of((String)n, (NutsSession)this.session).toURL();
                classPath.add(new NutsClassLoaderNode("", url, true, true, new NutsClassLoaderNode[0]));
            }
        }
    }

    private void addNp(List<NutsClassLoaderNode> classPath, String value) {
        NutsSession searchSession = this.session;
        NutsSearchCommand ns = this.session.search().setLatest(true).setSession(searchSession);
        for (String n : StringTokenizerUtils.split(value, ";, ")) {
            if (NutsBlankable.isBlank((String)n)) continue;
            ns.addId(n);
        }
        for (NutsId nutsId : ns.getResultIds()) {
            NutsDefinition f = (NutsDefinition)this.session.search().addId(nutsId).setSession(searchSession).setLatest(true).getResultDefinitions().required();
            classPath.add(NutsClassLoaderUtils.definitionToClassLoaderNode(f, this.session));
        }
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJavaCommand() {
        return this.javaCommand;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getDir() {
        return this.dir;
    }

    public boolean isMainClassApp() {
        return this.mainClassApp;
    }

    public boolean isExcludeBase() {
        return this.excludeBase;
    }

    public boolean isShowCommand() {
        return this.showCommand;
    }

    public boolean isJar() {
        return this.jar;
    }

    public String[] getExecArgs() {
        return this.execArgs;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public NutsWorkspace getWorkspace() {
        return this.getSession().getWorkspace();
    }

    public List<String> getApp() {
        return this.app;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public void fillStrings(NutsClassLoaderNode n, List<String> list) {
        URL f = n.getURL();
        list.add(NutsPath.of((URL)f, (NutsSession)this.getSession()).toFile().toString());
        for (NutsClassLoaderNode d : n.getDependencies()) {
            this.fillStrings(d, list);
        }
    }

    public List<String> getClassPathStrings() {
        ArrayList<String> li = new ArrayList<String>();
        for (NutsClassLoaderNode n : this.getClassPath()) {
            this.fillStrings(n, li);
        }
        return li;
    }

    public void fillNidStrings(NutsClassLoaderNode n, List<String> list) {
        if (n.getId() == null || n.getId().isEmpty()) {
            URL f = n.getURL();
            list.add(NutsPath.of((URL)f, (NutsSession)this.getSession()).toFile().toString());
        } else {
            list.add(n.getId());
        }
        for (NutsClassLoaderNode d : n.getDependencies()) {
            this.fillStrings(d, list);
        }
    }

    public List<String> getClassPathNidStrings() {
        ArrayList<String> li = new ArrayList<String>();
        for (NutsClassLoaderNode n : this.getClassPath()) {
            this.fillNidStrings(n, li);
        }
        return li;
    }

    public List<NutsClassLoaderNode> getClassPath() {
        return this.classPath;
    }
}

