/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.embedded;

import net.thevpc.nuts.NutsScheduler;
import net.thevpc.nuts.NutsSession;

public abstract class ClassloaderAwareRunnable
implements Runnable {
    protected Object result;
    protected ClassLoader initialClassLoader;
    protected ClassLoader classLoader;
    protected Throwable error;
    protected NutsSession session;

    public ClassloaderAwareRunnable(NutsSession session, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.session = session;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public abstract Object runWithContext() throws Throwable;

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    @Override
    public void run() {
        this.initialClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            try {
                this.result = this.runWithContext();
            }
            catch (Throwable th) {
                this.error = th;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.initialClassLoader);
        }
    }

    public Object getResult() {
        return this.result;
    }

    public void runAndWaitFor() throws Throwable {
        try {
            NutsScheduler.of((NutsSession)this.getSession()).executorService().submit(this).get();
        }
        catch (InterruptedException ex) {
            this.setError(ex);
        }
        if (this.getError() != null) {
            throw this.getError();
        }
    }
}

