/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.mapper;

import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementBuilder;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementFactoryContext;
import net.thevpc.nuts.NutsElementMapper;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsObjectElementBuilder;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsElementEntry;

public class NutsElementMapperNutsElementBuilder
implements NutsElementMapper<NutsElementBuilder> {
    public Object destruct(NutsElementBuilder src, Type typeOfSrc, NutsElementFactoryContext context) {
        switch (src.type()) {
            case ARRAY: {
                return src.build().asArray().children().stream().map(x -> context.destruct(x, null)).collect(Collectors.toList());
            }
            case OBJECT: {
                HashSet<Object> visited = new HashSet<Object>();
                boolean map = true;
                ArrayList<AbstractMap.SimpleEntry<Object, Object>> all = new ArrayList<AbstractMap.SimpleEntry<Object, Object>>();
                for (NutsElementEntry nutsElementEntry : src.build().asObject().children()) {
                    Object object = context.destruct((Object)nutsElementEntry.getKey(), null);
                    Object v = context.destruct((Object)nutsElementEntry.getValue(), null);
                    if (map && visited.contains(object)) {
                        map = false;
                    } else {
                        visited.add(object);
                    }
                    all.add(new AbstractMap.SimpleEntry<Object, Object>(object, v));
                }
                if (map) {
                    LinkedHashMap m = new LinkedHashMap();
                    for (Map.Entry entry : all) {
                        m.put(entry.getKey(), entry.getValue());
                    }
                    return m;
                }
                return all;
            }
        }
        return context.objectToElement((Object)src, NutsPrimitiveElement.class);
    }

    public NutsElement createElement(NutsElementBuilder src, Type typeOfSrc, NutsElementFactoryContext context) {
        if (src.type().isPrimitive()) {
            return src.build();
        }
        switch (src.type()) {
            case ARRAY: {
                NutsArrayElement arr = src.build().asArray();
                ArrayList<NutsElement> children = new ArrayList<NutsElement>(arr.size());
                boolean someChange = false;
                for (NutsElement c : arr) {
                    NutsElement v2 = context.objectToElement((Object)c, null);
                    if (!someChange) {
                        someChange = v2 != c;
                    }
                    children.add(v2);
                }
                if (someChange) {
                    return context.elem().ofArray().addAll(children.toArray(new NutsElement[0])).build();
                }
                return src.build();
            }
            case OBJECT: {
                NutsObjectElement obj = src.build().asObject();
                ArrayList<NutsElementEntry> children = new ArrayList<NutsElementEntry>(obj.size());
                boolean someChange = false;
                for (NutsElementEntry e : obj) {
                    NutsElement k2 = context.objectToElement((Object)e.getKey(), null);
                    boolean someChange0 = k2 != e.getKey();
                    NutsElement v2 = context.objectToElement((Object)e.getValue(), null);
                    if (!someChange0) {
                        boolean bl = someChange0 = v2 != e.getValue();
                    }
                    if (someChange0) {
                        if (!someChange) {
                            someChange = true;
                        }
                        children.add(new DefaultNutsElementEntry(k2, v2));
                        continue;
                    }
                    children.add(e);
                }
                if (someChange) {
                    NutsObjectElementBuilder obj2 = context.elem().ofObject();
                    obj2.addAll(children.toArray(new NutsElementEntry[0]));
                    return obj2.build();
                }
                return src.build();
            }
            case CUSTOM: {
                Object v1 = src.build().asCustom().getValue();
                if (context.getIndestructibleObjects() != null && context.getIndestructibleObjects().test(v1.getClass())) {
                    return src.build();
                }
                return context.objectToElement(v1, null);
            }
        }
        return src.build();
    }

    public NutsElementBuilder createObject(NutsElement src, Type typeOfResult, NutsElementFactoryContext context) {
        if (src.type().isPrimitive()) {
            return src.asSafeObject().builder();
        }
        switch (src.type()) {
            case ARRAY: {
                NutsArrayElement arr = src.asArray();
                ArrayList<NutsElement> children = new ArrayList<NutsElement>(arr.size());
                boolean someChange = false;
                for (NutsElement c : arr) {
                    NutsElement v2 = context.objectToElement((Object)c, null);
                    if (!someChange) {
                        someChange = v2 != c;
                    }
                    children.add(v2);
                }
                if (someChange) {
                    return context.elem().ofArray().addAll(children.toArray(new NutsElement[0]));
                }
                return src.asArray().builder();
            }
            case OBJECT: {
                NutsObjectElement obj = src.asObject();
                ArrayList<NutsElementEntry> children = new ArrayList<NutsElementEntry>(obj.size());
                boolean someChange = false;
                for (NutsElementEntry e : obj) {
                    NutsElement k2 = context.objectToElement((Object)e.getKey(), null);
                    boolean someChange0 = k2 != e.getKey();
                    NutsElement v2 = context.objectToElement((Object)e.getValue(), null);
                    if (!someChange0) {
                        boolean bl = someChange0 = v2 != e.getValue();
                    }
                    if (someChange0) {
                        if (!someChange) {
                            someChange = true;
                        }
                        children.add(new DefaultNutsElementEntry(k2, v2));
                        continue;
                    }
                    children.add(e);
                }
                if (someChange) {
                    NutsObjectElementBuilder obj2 = context.elem().ofObject();
                    obj2.addAll(children.toArray(new NutsElementEntry[0]));
                    return obj2;
                }
                return src.asSafeObject().builder();
            }
            case CUSTOM: {
                throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.plain((String)"unsupported"));
            }
        }
        throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.plain((String)"unsupported"));
    }
}

