/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementFactoryContext;
import net.thevpc.nuts.NutsElementMapper;
import net.thevpc.nuts.NutsElementType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsElementFactoryService;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsObjectElement;

public class NutsElementMapperMap
implements NutsElementMapper<Map> {
    private final DefaultNutsElementFactoryService defaultNutsElementFactoryService;

    public NutsElementMapperMap(DefaultNutsElementFactoryService defaultNutsElementFactoryService) {
        this.defaultNutsElementFactoryService = defaultNutsElementFactoryService;
    }

    public Object destruct(Map src, Type typeOfSrc, NutsElementFactoryContext context) {
        Map je = src;
        LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
        if (je != null) {
            Iterator iterator = je.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry e0;
                Map.Entry e = e0 = iterator.next();
                Object k = context.destruct(e.getKey(), null);
                Object v = context.destruct(e.getValue(), null);
                m.put(k, v);
            }
        }
        return m;
    }

    public NutsElement createElement(Map o, Type typeOfSrc, NutsElementFactoryContext context) {
        Map je = o;
        LinkedHashMap<NutsElement, NutsElement> m = new LinkedHashMap<NutsElement, NutsElement>();
        if (je != null) {
            Iterator iterator = je.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry e0;
                Map.Entry e = e0 = iterator.next();
                NutsElement k = context.objectToElement(e.getKey(), null);
                NutsElement v = context.objectToElement(e.getValue(), null);
                m.put(k, v);
            }
        }
        return new DefaultNutsObjectElement(m, context.getSession());
    }

    public Map fillObject(NutsElement o, Map all, Type elemType1, Type elemType2, Type to, NutsElementFactoryContext context) {
        if (o.type() == NutsElementType.OBJECT) {
            for (NutsElementEntry kv : o.asObject().children()) {
                NutsElement k = kv.getKey();
                NutsElement v = kv.getValue();
                all.put(context.elementToObject(k, elemType1), context.elementToObject(v, elemType2));
            }
        } else if (o.type() == NutsElementType.ARRAY) {
            for (NutsElement ee : o.asArray().children()) {
                NutsObjectElement kv = ee.asObject();
                NutsElement k = kv.get((NutsElement)context.elem().ofString("key"));
                NutsElement v = kv.get((NutsElement)context.elem().ofString("value"));
                all.put(context.elementToObject(k, elemType1), context.elementToObject(v, elemType2));
            }
        } else {
            throw new NutsUnsupportedEnumException(context.getSession(), (Enum)o.type());
        }
        return all;
    }

    public Map createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
        Class cls = Map.class;
        Type elemType1 = null;
        Type elemType2 = null;
        if (to instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)to;
            Type rawType = pt.getRawType();
            if (rawType instanceof Class) {
                cls = (Class)rawType;
            }
            elemType1 = pt.getActualTypeArguments()[0];
            elemType2 = pt.getActualTypeArguments()[1];
        }
        if (cls == null) {
            throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.plain((String)"class is null"));
        }
        switch (cls.getName()) {
            case "java.util.Map": 
            case "java.util.LinkedHashMap": {
                return this.fillObject(o, new LinkedHashMap(o.asObject().size()), elemType1, elemType2, to, context);
            }
            case "java.util.HashMap": {
                return this.fillObject(o, new HashMap(o.asObject().size()), elemType1, elemType2, to, context);
            }
            case "java.util.SortedMap": 
            case "java.util.NavigableMap": {
                return this.fillObject(o, new TreeMap(), elemType1, elemType2, to, context);
            }
        }
        return this.fillObject(o, (Map)this.defaultNutsElementFactoryService.getTypesRepository().getType(to).newInstance(), elemType1, elemType2, to, context);
    }
}

