/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementFactoryContext;
import net.thevpc.nuts.NutsElementMapper;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsArrayElement;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsElementFactoryService;
import net.thevpc.nuts.runtime.standalone.util.reflect.ReflectType;
import net.thevpc.nuts.runtime.standalone.util.reflect.ReflectUtils;

public class NutsElementMapperCollection
implements NutsElementMapper {
    private final DefaultNutsElementFactoryService defaultNutsElementFactoryService;

    public NutsElementMapperCollection(DefaultNutsElementFactoryService defaultNutsElementFactoryService) {
        this.defaultNutsElementFactoryService = defaultNutsElementFactoryService;
    }

    public Object destruct(Object src, Type typeOfSrc, NutsElementFactoryContext context) {
        Collection coll = (Collection)src;
        return coll.stream().map(x -> context.destruct(x, null)).collect(Collectors.toList());
    }

    public NutsElement createElement(Object o, Type typeOfSrc, NutsElementFactoryContext context) {
        Collection coll = (Collection)o;
        List<NutsElement> collect = coll.stream().map(x -> context.objectToElement(x, null)).collect(Collectors.toList());
        return new DefaultNutsArrayElement(collect, context.getSession());
    }

    public Collection fillObject(NutsElement o, Collection coll, Type elemType, Type to, NutsElementFactoryContext context) {
        for (NutsElement nutsElement : o.asArray().children()) {
            coll.add(context.elementToObject(nutsElement, elemType));
        }
        return coll;
    }

    public Collection createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
        Class cls = ReflectUtils.getRawClass(to);
        Object elemType = Object.class;
        if (to instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)to;
            elemType = pt.getActualTypeArguments()[0];
        }
        switch (cls.getName()) {
            case "java.util.Collection": 
            case "java.util.List": 
            case "java.util.ArrayList": {
                return this.fillObject(o, new ArrayList(o.asArray().size()), (Type)elemType, to, context);
            }
            case "java.util.Set": 
            case "java.util.LinkedHashset": {
                return this.fillObject(o, new LinkedHashSet(), (Type)elemType, to, context);
            }
            case "java.util.Hashset": {
                return this.fillObject(o, new HashSet(), (Type)elemType, to, context);
            }
            case "java.util.SortedSet": 
            case "java.util.NavigableSet": 
            case "java.util.TreeSet": {
                return this.fillObject(o, new TreeSet(), (Type)elemType, to, context);
            }
            case "java.util.Queue": {
                return this.fillObject(o, new LinkedList(), (Type)elemType, to, context);
            }
            case "java.util.BlockingQueue": {
                return this.fillObject(o, new LinkedBlockingQueue(), (Type)elemType, to, context);
            }
            case "java.util.TransferQueue": {
                return this.fillObject(o, new LinkedTransferQueue(), (Type)elemType, to, context);
            }
            case "java.util.Deque": {
                return this.fillObject(o, new ArrayList(), (Type)elemType, to, context);
            }
        }
        ReflectType m = this.defaultNutsElementFactoryService.getTypesRepository().getType(to);
        return this.fillObject(o, (Collection)m.newInstance(), (Type)elemType, to, context);
    }
}

