/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsElementType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.elem.AbstractNutsElement;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;

class DefaultNutsPrimitiveElement
extends AbstractNutsElement
implements NutsPrimitiveElement {
    public static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSSX"};
    private final Object value;

    DefaultNutsPrimitiveElement(NutsElementType type, Object value, NutsSession session) {
        super(type, session);
        this.value = value;
    }

    public static Instant parseInstant(String s, NutsSession session) {
        try {
            return DateTimeFormatter.ISO_INSTANT.parse((CharSequence)s, Instant::from);
        }
        catch (Exception exception) {
            for (String f : DATE_FORMATS) {
                try {
                    return new SimpleDateFormat(f).parse(s).toInstant();
                }
                catch (Exception exception2) {
                }
            }
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid date %s", (Object[])new Object[]{s}));
        }
    }

    private static Number convertByInstance(Number from, Object ... to) {
        for (Object t : to) {
            if (t == null) continue;
            return DefaultNutsPrimitiveElement.convert(from, to.getClass());
        }
        return from;
    }

    private static Number convert(Number from, Class to) {
        if (to.isInstance(from)) {
            return from;
        }
        switch (to.toString()) {
            case "byte": 
            case "java.lang.Byte": {
                return from.byteValue();
            }
            case "short": 
            case "java.lang.Short": {
                return from.shortValue();
            }
            case "int": 
            case "java.lang.Integer": {
                return from.intValue();
            }
            case "long": 
            case "java.lang.Long": {
                return from.longValue();
            }
            case "float": 
            case "java.lang.Float": {
                return Float.valueOf(from.floatValue());
            }
            case "double": 
            case "java.lang.Double": {
                return from.doubleValue();
            }
            case "java.math.BigInteger": {
                return new BigInteger(from.toString());
            }
            case "java.math.BigDecimal": {
                return new BigDecimal(from.toString());
            }
        }
        Constructor c = null;
        try {
            c = to.getConstructor(Number.class);
            if (c != null) {
                return (Number)c.newInstance(from);
            }
            c = to.getConstructor(String.class);
            if (c != null) {
                return (Number)c.newInstance(from.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return from;
    }

    public Object getValue() {
        return this.value;
    }

    public Instant getInstant() {
        return this.getInstant(Instant.MIN, Instant.MIN);
    }

    public Instant getInstant(Instant emptyValue, Instant errorValue) {
        if (this.value == null) {
            return emptyValue;
        }
        if (this.value instanceof Boolean) {
            return errorValue;
        }
        if (this.value instanceof Number) {
            return Instant.ofEpochMilli(((Number)this.value).longValue());
        }
        if (this.value instanceof Date) {
            return ((Date)this.value).toInstant();
        }
        if (this.value instanceof Instant) {
            return (Instant)this.value;
        }
        String s = String.valueOf(this.value);
        if (s.trim().isEmpty()) {
            return emptyValue;
        }
        try {
            return DateTimeFormatter.ISO_INSTANT.parse((CharSequence)s, Instant::from);
        }
        catch (Exception exception) {
            for (String f : DATE_FORMATS) {
                try {
                    return new SimpleDateFormat(f).parse(s).toInstant();
                }
                catch (Exception exception2) {
                }
            }
            if (this.isLong()) {
                try {
                    return Instant.ofEpochMilli(this.getLong());
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            return errorValue;
        }
    }

    public Instant getInstant(Instant emptyOrErrorValue) {
        return this.getInstant(emptyOrErrorValue, emptyOrErrorValue);
    }

    public Number getNumber() {
        return this.getNumber(0, 0);
    }

    public Number getNumber(Number emptyOrErrorValue) {
        return this.getNumber(emptyOrErrorValue, emptyOrErrorValue);
    }

    public Number getNumber(Number emptyValue, Number errorValue) {
        if (this.value == null) {
            return emptyValue;
        }
        if (this.value instanceof Boolean) {
            return DefaultNutsPrimitiveElement.convertByInstance((Boolean)this.value != false ? 1 : 0, emptyValue, errorValue);
        }
        if (this.value instanceof Number) {
            return (Number)this.value;
        }
        if (this.value instanceof Date) {
            return ((Date)this.value).getTime();
        }
        if (this.value instanceof Instant) {
            return ((Instant)this.value).toEpochMilli();
        }
        String s = String.valueOf(this.value);
        if (s.indexOf(46) >= 0 || s.toLowerCase().indexOf(101) >= 0) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return new BigDecimal(s);
                }
                catch (NumberFormatException numberFormatException2) {
                }
            }
        } else {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Long.parseLong(s);
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        return new BigInteger(s);
                    }
                    catch (NumberFormatException numberFormatException4) {
                        // empty catch block
                    }
                }
            }
        }
        return errorValue;
    }

    public boolean getBoolean() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue() != 0.0;
        }
        return NutsUtilStrings.parseBoolean((String)String.valueOf(this.value), (Boolean)false, (Boolean)false);
    }

    public Boolean getBoolean(Boolean emptyValue, Boolean errorValue) {
        if (this.value == null) {
            return emptyValue;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue() != 0.0;
        }
        return NutsUtilStrings.parseBoolean((String)String.valueOf(this.value), (Boolean)emptyValue, (Boolean)errorValue);
    }

    public Boolean getBoolean(Boolean emptyValue) {
        return this.getBoolean(emptyValue, emptyValue);
    }

    public double getDouble() {
        return this.getDouble(0.0, 0.0);
    }

    public Double getDouble(Double emptyValue, Double errorValue) {
        if (this.value == null) {
            return 0.0;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? 1.0 : 0.0;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        String s = String.valueOf(this.value);
        if (NutsBlankable.isBlank((String)s)) {
            return emptyValue;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException ex) {
            return errorValue;
        }
    }

    public float getFloat() {
        return this.getFloat(Float.valueOf(0.0f), Float.valueOf(0.0f)).floatValue();
    }

    public int getInt() {
        return this.getInt(0, 0);
    }

    public Integer getInt(Integer emptyOrErrorValue) {
        return this.getInt(emptyOrErrorValue, emptyOrErrorValue);
    }

    public Long getLong(Long emptyOrErrorValue) {
        return this.getLong(emptyOrErrorValue, emptyOrErrorValue);
    }

    public Short getShort(Short emptyOrErrorValue) {
        return this.getShort(emptyOrErrorValue, emptyOrErrorValue);
    }

    public Byte getByte(Byte emptyOrErrorValue) {
        return this.getByte(emptyOrErrorValue, emptyOrErrorValue);
    }

    public Float getFloat(Float emptyOrErrorValue) {
        return this.getFloat(emptyOrErrorValue, emptyOrErrorValue);
    }

    public Double getDouble(Double emptyOrErrorValue) {
        return this.getDouble(emptyOrErrorValue, emptyOrErrorValue);
    }

    public Integer getInt(Integer emptyValue, Integer errorValue) {
        Long r = this.getLong(emptyValue == null ? null : Long.valueOf(emptyValue.longValue()), errorValue == null ? null : Long.valueOf(errorValue.longValue()));
        if (r == null) {
            return null;
        }
        int x = r.intValue();
        if ((long)x == r) {
            return x;
        }
        return errorValue;
    }

    public Float getFloat(Float emptyValue, Float errorValue) {
        Double r = this.getDouble(emptyValue == null ? null : Double.valueOf(emptyValue.doubleValue()), errorValue == null ? null : Double.valueOf(errorValue.doubleValue()));
        if (r == null) {
            return null;
        }
        float x = r.floatValue();
        if ((double)x == r) {
            return Float.valueOf(x);
        }
        return errorValue;
    }

    public Long getLong(Long emptyValue, Long errorValue) {
        if (this.isBlank()) {
            return emptyValue;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        if (this.value instanceof CharSequence) {
            String s = this.value.toString();
            if (s.indexOf(46) >= 0) {
                try {
                    double a = Double.parseDouble(s);
                    if (a == (double)((long)a)) {
                        return (long)a;
                    }
                    return errorValue;
                }
                catch (NumberFormatException ex) {
                    return errorValue;
                }
            }
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException ex) {
                return errorValue;
            }
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? 1L : 0L;
        }
        return errorValue;
    }

    public byte getByte() {
        return this.getByte((byte)0, (byte)0);
    }

    public short getShort() {
        return this.getShort((short)0, (short)0);
    }

    public long getLong() {
        if (this.value == null) {
            return 0L;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? 1L : 0L;
        }
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        if (this.value instanceof Date) {
            return (int)((Date)this.value).getTime();
        }
        String s = String.valueOf(this.value);
        if (s.indexOf(46) >= 0) {
            try {
                return (long)Double.parseDouble(s);
            }
            catch (NumberFormatException ex) {
                return 0L;
            }
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException ex2) {
                return 0L;
            }
        }
    }

    public String getString() {
        return this.value == null ? null : this.value.toString();
    }

    public String getString(String defaultValue) {
        return this.value == null ? defaultValue : this.value.toString();
    }

    public boolean isBoolean() {
        return !this.isBlank() && this.getBoolean(null, null) != null;
    }

    public Byte getByte(Byte emptyValue, Byte errorValue) {
        Long r = this.getLong(emptyValue == null ? null : Long.valueOf(emptyValue.longValue()), errorValue == null ? null : Long.valueOf(errorValue.longValue()));
        if (r == null) {
            return null;
        }
        byte x = r.byteValue();
        if ((long)x == r) {
            return x;
        }
        return errorValue;
    }

    public Short getShort(Short emptyValue, Short errorValue) {
        Long r = this.getLong(emptyValue == null ? null : Long.valueOf(emptyValue.longValue()), errorValue == null ? null : Long.valueOf(errorValue.longValue()));
        if (r == null) {
            return null;
        }
        short x = r.shortValue();
        if ((long)x == r) {
            return x;
        }
        return errorValue;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean isByte() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Number) {
            switch (this.value.getClass().getName()) {
                case "java.lang.Byte": {
                    return true;
                }
            }
        } else if (this.value instanceof String) {
            try {
                Byte.parseByte(this.value.toString());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isInt() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Number) {
            switch (this.value.getClass().getName()) {
                case "java.lang.Byte": 
                case "java.lang.Short": 
                case "java.lang.Integer": {
                    return true;
                }
            }
        } else if (this.value instanceof String) {
            try {
                Integer.parseInt(this.value.toString());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isLong() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Number) {
            switch (this.value.getClass().getName()) {
                case "java.lang.Byte": 
                case "java.lang.Short": 
                case "java.lang.Integer": 
                case "java.lang.Long": {
                    return true;
                }
            }
        } else if (this.value instanceof String) {
            try {
                Long.parseLong(this.value.toString());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isShort() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Number) {
            switch (this.value.getClass().getName()) {
                case "java.lang.Byte": 
                case "java.lang.Short": {
                    return true;
                }
            }
        } else if (this.value instanceof String) {
            try {
                Short.parseShort(this.value.toString());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isFloat() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Number) {
            switch (this.value.getClass().getName()) {
                case "java.lang.Byte": 
                case "java.lang.Short": 
                case "java.lang.Integer": 
                case "java.lang.Long": 
                case "java.lang.Float": {
                    return true;
                }
            }
        } else if (this.value instanceof String) {
            try {
                Float.parseFloat(this.value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isDouble() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Number) {
            switch (this.value.getClass().getName()) {
                case "java.lang.Byte": 
                case "java.lang.Short": 
                case "java.lang.Integer": 
                case "java.lang.Long": 
                case "java.lang.Float": 
                case "java.lang.Double": {
                    return true;
                }
            }
        } else if (this.value instanceof String) {
            try {
                Double.parseDouble(this.value.toString());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isInstant() {
        if (this.value == null) {
            return false;
        }
        if (this.value instanceof Date || this.value instanceof Instant) {
            return true;
        }
        String s = String.valueOf(this.value);
        try {
            DateTimeFormatter.ISO_INSTANT.parse((CharSequence)s, Instant::from);
            return true;
        }
        catch (Exception exception) {
            for (String f : DATE_FORMATS) {
                try {
                    new SimpleDateFormat(f).parse(s).toInstant();
                    return true;
                }
                catch (Exception exception2) {
                }
            }
            return false;
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNutsPrimitiveElement other = (DefaultNutsPrimitiveElement)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        switch (this.type()) {
            case NULL: {
                return "null";
            }
            case STRING: {
                return CoreStringUtils.dblQuote(this.getString());
            }
            case BOOLEAN: {
                return String.valueOf(this.getBoolean());
            }
            case INTEGER: 
            case FLOAT: {
                return String.valueOf(this.getNumber());
            }
            case INSTANT: {
                return CoreStringUtils.dblQuote(this.getInstant().toString());
            }
        }
        return this.getString();
    }

    public boolean isEmpty() {
        switch (this.type()) {
            case NULL: {
                return true;
            }
            case STRING: {
                return this.toString().isEmpty();
            }
        }
        return false;
    }

    public boolean isBlank() {
        return NutsBlankable.isBlank((Object)this.value);
    }
}

