/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementType;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsObjectElementBuilder;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsElementEntry;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsObjectElement;

public class DefaultNutsObjectElementBuilder
implements NutsObjectElementBuilder {
    private final Map<NutsElement, NutsElement> values = new LinkedHashMap<NutsElement, NutsElement>();
    private transient NutsSession session;

    public DefaultNutsObjectElementBuilder(NutsSession session) {
        if (session == null) {
            throw new NullPointerException();
        }
        this.session = session;
    }

    public Collection<NutsElementEntry> children() {
        return this.values.entrySet().stream().map(x -> new DefaultNutsElementEntry((NutsElement)x.getKey(), (NutsElement)x.getValue())).collect(Collectors.toList());
    }

    public NutsElement get(NutsElement s) {
        return this.values.get(s);
    }

    public NutsElement get(String s) {
        return this.values.get(this._elements().ofBoolean(s));
    }

    public int size() {
        return this.values.size();
    }

    public NutsObjectElementBuilder set(String name, NutsElement value) {
        this.values.put((NutsElement)this._elements().ofString(name), this.denull(value));
        return this;
    }

    public NutsObjectElementBuilder set(String name, boolean value) {
        return this.set((NutsElement)this._elements().ofString(name), (NutsElement)this._elements().ofBoolean(value));
    }

    public NutsObjectElementBuilder set(String name, int value) {
        return this.set((NutsElement)this._elements().ofString(name), (NutsElement)this._elements().ofInt(Integer.valueOf(value)));
    }

    public NutsObjectElementBuilder set(String name, double value) {
        return this.set((NutsElement)this._elements().ofString(name), (NutsElement)this._elements().ofDouble(Double.valueOf(value)));
    }

    public NutsObjectElementBuilder set(String name, String value) {
        return this.set((NutsElement)this._elements().ofString(name), (NutsElement)this._elements().ofString(value));
    }

    public NutsObjectElementBuilder remove(String name) {
        NutsPrimitiveElement v = name == null ? this._elements().ofNull() : this._elements().ofString(name);
        this.values.remove(v);
        return this;
    }

    public NutsObjectElementBuilder add(NutsElement name, NutsElement value) {
        this.values.put(name, this.denull(value));
        return this;
    }

    public NutsObjectElementBuilder set(NutsElement name, NutsElement value) {
        this.values.put(name, this.denull(value));
        return this;
    }

    public NutsObjectElementBuilder addAll(Map<NutsElement, NutsElement> other) {
        if (other != null) {
            for (Map.Entry<NutsElement, NutsElement> e : other.entrySet()) {
                this.add(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public NutsObjectElementBuilder set(NutsElement name, boolean value) {
        return this.set(name, (NutsElement)this._elements().ofBoolean(value));
    }

    public NutsObjectElementBuilder set(NutsElement name, int value) {
        return this.set(name, (NutsElement)this._elements().ofInt(Integer.valueOf(value)));
    }

    public NutsObjectElementBuilder set(NutsElement name, double value) {
        return this.set(name, (NutsElement)this._elements().ofDouble(Double.valueOf(value)));
    }

    public NutsObjectElementBuilder set(NutsElement name, String value) {
        return this.set(name, (NutsElement)this._elements().ofString(value));
    }

    public NutsObjectElementBuilder remove(NutsElement name) {
        this.values.remove(name);
        return this;
    }

    public NutsObjectElementBuilder clear() {
        this.values.clear();
        return this;
    }

    public NutsObjectElementBuilder set(NutsObjectElement other) {
        this.clear();
        this.add(other);
        return this;
    }

    public NutsObjectElementBuilder set(NutsObjectElementBuilder other) {
        this.clear();
        this.add(other);
        return this;
    }

    public NutsObjectElementBuilder add(NutsObjectElement other) {
        if (other != null) {
            for (NutsElementEntry child : other.children()) {
                this.add(child.getKey(), child.getValue());
            }
        }
        return this;
    }

    public NutsObjectElementBuilder add(NutsObjectElementBuilder other) {
        if (other != null) {
            for (NutsElementEntry child : other.children()) {
                this.add(child.getKey(), child.getValue());
            }
        }
        return this;
    }

    public NutsObjectElementBuilder add(NutsElementEntry entry) {
        if (entry != null) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public NutsObjectElementBuilder addAll(NutsElementEntry ... entries) {
        if (entries != null) {
            for (NutsElementEntry entry : entries) {
                this.add(entry);
            }
        }
        return this;
    }

    public NutsObjectElementBuilder addAll(NutsObjectElement other) {
        if (other != null) {
            for (NutsElementEntry entry : other) {
                this.add(entry);
            }
        }
        return this;
    }

    public NutsObjectElementBuilder addAll(NutsObjectElementBuilder other) {
        if (other != null) {
            for (NutsElementEntry entry : other.build()) {
                this.add(entry);
            }
        }
        return this;
    }

    public NutsObjectElement build() {
        return new DefaultNutsObjectElement(this.values, this.session);
    }

    public String toString() {
        return "{" + this.children().stream().map(x -> x.getKey() + ":" + x.getValue().toString()).collect(Collectors.joining(", ")) + "}";
    }

    private NutsElement denull(NutsElement e) {
        if (e == null) {
            return this._elements().ofNull();
        }
        return e;
    }

    private NutsElements _elements() {
        return NutsElements.of((NutsSession)this.session).setSession(this.session);
    }

    public NutsElementType type() {
        return NutsElementType.OBJECT;
    }
}

