/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem;

import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsObjectElementBuilder;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.elem.AbstractNutsObjectElement;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsElementEntry;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsElements;

public class DefaultNutsObjectElement
extends AbstractNutsObjectElement {
    private Map<NutsElement, NutsElement> values = new LinkedHashMap<NutsElement, NutsElement>();

    public DefaultNutsObjectElement(Map<NutsElement, NutsElement> values, NutsSession session) {
        super(session);
        if (values != null) {
            for (Map.Entry<NutsElement, NutsElement> e : values.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                this.values.put(e.getKey(), e.getValue());
            }
        }
    }

    public Iterator<NutsElementEntry> iterator() {
        return this.children().iterator();
    }

    public NutsElement get(String s) {
        DefaultNutsElements element = (DefaultNutsElements)NutsElements.of((NutsSession)this.session);
        return this.values.get(element.ofString(s));
    }

    public NutsElement get(NutsElement s) {
        return this.values.get(s);
    }

    public NutsElement getSafe(String key) {
        NutsElement a = this.get(key);
        return a == null ? NutsElements.of((NutsSession)this.session).ofNull() : a;
    }

    public Integer getSafeInt(String key) {
        return this.getSafe(key).asSafeInt(null);
    }

    public Integer getSafeInt(String key, int def) {
        return this.getSafe(key).asSafeInt(Integer.valueOf(def));
    }

    public String getSafeString(String key) {
        return this.getSafe(key).asString();
    }

    public String getSafeString(String key, String def) {
        String s = this.getSafe(key).asString();
        return s == null ? def : s;
    }

    public NutsElement getSafe(NutsElement key) {
        NutsElement a = this.get(key);
        return a == null ? NutsElements.of((NutsSession)this.session).ofNull() : a;
    }

    public NutsArrayElement getSafeArray(String key) {
        return this.getSafe(key).asSafeArray(false);
    }

    public NutsArrayElement getSafeArray(NutsElement key) {
        return this.getSafe(key).asSafeArray(false);
    }

    public NutsObjectElement getSafeObject(String key) {
        return this.getSafe(key).asSafeObject(false);
    }

    public NutsObjectElement getSafeObject(NutsElement key) {
        return this.getSafe(key).asSafeObject(false);
    }

    public NutsArrayElement getArray(String key) {
        return this.get(key).asArray();
    }

    public NutsArrayElement getArray(NutsElement key) {
        return this.get(key).asArray();
    }

    public NutsObjectElement getObject(String key) {
        NutsElement b = this.get(key);
        return b == null ? null : b.asObject();
    }

    public NutsObjectElement getObject(NutsElement key) {
        return this.get(key).asObject();
    }

    public String getString(String key) {
        NutsElement a = this.get(key);
        return a == null ? null : a.asPrimitive().getString();
    }

    public String getString(NutsElement key) {
        NutsElement a = this.get(key);
        return a == null ? null : a.asPrimitive().getString();
    }

    public boolean getBoolean(String key) {
        NutsElement b = this.get(key);
        return b != null && b.asPrimitive().getBoolean();
    }

    public boolean getBoolean(NutsElement key) {
        NutsElement b = this.get(key);
        return b != null && b.asPrimitive().getBoolean();
    }

    public Number getNumber(String key) {
        NutsElement b = this.get(key);
        return b == null ? (Number)null : (Number)b.asPrimitive().getNumber();
    }

    public Number getNumber(NutsElement key) {
        NutsElement b = this.get(key);
        return b == null ? (Number)null : (Number)b.asPrimitive().getNumber();
    }

    public byte getByte(String key) {
        NutsElement b = this.get(key);
        return b == null ? (byte)0 : b.asPrimitive().getByte();
    }

    public byte getByte(NutsElement key) {
        NutsElement b = this.get(key);
        return b == null ? (byte)0 : b.asPrimitive().getByte();
    }

    public int getInt(String key) {
        NutsElement b = this.get(key);
        return b == null ? 0 : b.asPrimitive().getInt();
    }

    public int getInt(NutsElement key) {
        NutsElement b = this.get(key);
        return b == null ? 0 : b.asPrimitive().getInt();
    }

    public long getLong(String key) {
        NutsElement b = this.get(key);
        return b == null ? 0L : b.asPrimitive().getLong();
    }

    public long getLong(NutsElement key) {
        NutsElement b = this.get(key);
        return b == null ? 0L : b.asPrimitive().getLong();
    }

    public short getShort(String key) {
        NutsElement b = this.get(key);
        return b == null ? (short)0 : b.asPrimitive().getShort();
    }

    public short getShort(NutsElement key) {
        NutsElement b = this.get(key);
        return b == null ? (short)0 : b.asPrimitive().getShort();
    }

    public Instant getInstant(String key) {
        NutsElement b = this.get(key);
        return b == null ? null : b.asPrimitive().getInstant();
    }

    public Instant getInstant(NutsElement key) {
        NutsElement b = this.get(key);
        return b == null ? null : b.asPrimitive().getInstant();
    }

    public float getFloat(String key) {
        NutsElement b = this.get(key);
        return b == null ? 0.0f : b.asPrimitive().getFloat();
    }

    public float getFloat(NutsElement key) {
        NutsElement b = this.get(key);
        return b == null ? 0.0f : b.asPrimitive().getFloat();
    }

    public double getDouble(String key) {
        NutsElement b = this.get(key);
        return b == null ? 0.0 : b.asPrimitive().getDouble();
    }

    public double getDouble(NutsElement key) {
        NutsElement b = this.get(key);
        return b.asPrimitive().getDouble();
    }

    public Collection<NutsElementEntry> children() {
        return this.values.entrySet().stream().map(x -> new DefaultNutsElementEntry((NutsElement)x.getKey(), (NutsElement)x.getValue())).collect(Collectors.toList());
    }

    public Stream<NutsElementEntry> stream() {
        return this.values.entrySet().stream().map(x -> new DefaultNutsElementEntry((NutsElement)x.getKey(), (NutsElement)x.getValue()));
    }

    public int size() {
        return this.values.size();
    }

    public NutsObjectElementBuilder builder() {
        return NutsElements.of((NutsSession)this.session).ofObject().set((NutsObjectElement)this);
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + Objects.hashCode(this.values);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNutsObjectElement other = (DefaultNutsObjectElement)obj;
        return Objects.equals(this.values, other.values);
    }

    public String toString() {
        return "{" + this.children().stream().map(x -> x.getKey() + ":" + x.getValue().toString()).collect(Collectors.joining(", ")) + "}";
    }

    public boolean isBlank() {
        return this.values.isEmpty();
    }
}

