/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.function.Predicate;
import net.thevpc.nuts.NutsArrayElementBuilder;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsCustomElement;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementMapper;
import net.thevpc.nuts.NutsElementPath;
import net.thevpc.nuts.NutsElementType;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsFormattable;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsInputStreamMonitor;
import net.thevpc.nuts.NutsIterableFormat;
import net.thevpc.nuts.NutsMemoryPrintStream;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectElementBuilder;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsProgressFactory;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsArrayElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsCustomElement;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsElementEntry;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsElementFactoryContext;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsElementFactoryService;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsObjectElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsPrimitiveElement;
import net.thevpc.nuts.runtime.standalone.elem.NutsElementFactoryService;
import net.thevpc.nuts.runtime.standalone.elem.NutsElementPathFilter;
import net.thevpc.nuts.runtime.standalone.elem.NutsElementStreamFormat;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.format.NutsFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.format.json.DefaultSearchFormatJson;
import net.thevpc.nuts.runtime.standalone.format.plain.DefaultSearchFormatPlain;
import net.thevpc.nuts.runtime.standalone.format.props.DefaultSearchFormatProps;
import net.thevpc.nuts.runtime.standalone.format.table.DefaultSearchFormatTable;
import net.thevpc.nuts.runtime.standalone.format.tree.DefaultSearchFormatTree;
import net.thevpc.nuts.runtime.standalone.format.xml.DefaultSearchFormatXml;
import net.thevpc.nuts.runtime.standalone.text.DefaultNutsTextManagerModel;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceExt;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsElements
extends DefaultFormatBase<NutsElements>
implements NutsElements {
    private static Predicate<Class> DEFAULT_INDESTRUCTIBLE_FORMAT = new Predicate<Class>(){

        @Override
        public boolean test(Class x) {
            switch (x.getName()) {
                case "boolean": 
                case "byte": 
                case "short": 
                case "int": 
                case "long": 
                case "float": 
                case "double": 
                case "java.lang.String": 
                case "java.lang.StringBuilder": 
                case "java.lang.Boolean": 
                case "java.lang.Byte": 
                case "java.lang.Short": 
                case "java.lang.Integer": 
                case "java.lang.Long": 
                case "java.lang.Float": 
                case "java.lang.Double": 
                case "java.math.BigDecimal": 
                case "java.math.BigInteger": 
                case "java.util.Date": 
                case "java.sql.Time": {
                    return true;
                }
            }
            if (Temporal.class.isAssignableFrom(x)) {
                return true;
            }
            if (Date.class.isAssignableFrom(x)) {
                return true;
            }
            return NutsString.class.isAssignableFrom(x) || NutsElement.class.isAssignableFrom(x) || NutsFormattable.class.isAssignableFrom(x) || NutsMessage.class.isAssignableFrom(x);
        }
    };
    private final DefaultNutsTextManagerModel model;
    private Object value;
    private NutsContentType contentType = NutsContentType.JSON;
    private boolean compact;
    private boolean logProgress;
    private boolean traceProgress;
    private NutsProgressFactory progressFactory;
    private Predicate<Class> indestructibleObjects;

    public DefaultNutsElements(NutsSession session) {
        super(session, "element-format");
        this.model = NutsWorkspaceExt.of((NutsSession)session).getModel().textModel;
    }

    public boolean isLogProgress() {
        return this.logProgress;
    }

    public NutsElements setLogProgress(boolean logProgress) {
        this.logProgress = logProgress;
        return this;
    }

    public boolean isTraceProgress() {
        return this.traceProgress;
    }

    public NutsElements setTraceProgress(boolean traceProgress) {
        this.traceProgress = traceProgress;
        return this;
    }

    public NutsContentType getContentType() {
        return this.contentType;
    }

    public NutsElements setContentType(NutsContentType contentType) {
        this.contentType = contentType == null ? NutsContentType.JSON : contentType;
        return this;
    }

    public NutsElements json() {
        return this.setContentType(NutsContentType.JSON);
    }

    public Object getValue() {
        return this.value;
    }

    public NutsElements setValue(Object value) {
        this.value = value;
        return this;
    }

    public NutsElementPath compilePath(String pathExpression) {
        this.checkSession();
        return NutsElementPathFilter.compile(pathExpression, this.getSession());
    }

    public boolean isCompact() {
        return this.compact;
    }

    public NutsElements setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    public <T> T parse(URL url, Class<T> clazz) {
        this.checkSession();
        return this.parse(NutsPath.of((URL)url, (NutsSession)this.getSession()), clazz);
    }

    private InputStream prepareInputStream(InputStream is, Object origin) {
        if (this.isLogProgress() || this.isTraceProgress()) {
            return NutsInputStreamMonitor.of((NutsSession)this.getSession()).setSource(is).setOrigin(origin).setLogProgress(this.isLogProgress()).setTraceProgress(this.isTraceProgress()).setProgressFactory(this.getProgressFactory()).create();
        }
        return is;
    }

    private InputStream prepareInputStream(NutsPath path) {
        if (this.isLogProgress()) {
            return NutsInputStreamMonitor.of((NutsSession)this.getSession()).setSource(path).setOrigin((Object)path).setLogProgress(this.isLogProgress()).setTraceProgress(this.isTraceProgress()).setProgressFactory(this.getProgressFactory()).create();
        }
        return path.getInputStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T parse(NutsPath path, Class<T> clazz) {
        this.checkSession();
        switch (this.contentType) {
            case JSON: 
            case YAML: 
            case XML: 
            case TSON: {
                try {
                    try (InputStream is = this.prepareInputStream(path);){
                        T t = this.parse(new InputStreamReader(is), clazz);
                        return t;
                    }
                    catch (NutsException ex) {
                        throw ex;
                    }
                    catch (UncheckedIOException ex) {
                        throw new NutsIOException(this.getSession(), (Throwable)ex);
                    }
                    catch (RuntimeException ex) {
                        throw new NutsParseException(this.getSession(), NutsMessage.cstyle((String)"unable to parse path %s", (Object[])new Object[]{path}), (Throwable)ex);
                    }
                }
                catch (IOException ex) {
                    throw new NutsParseException(this.getSession(), NutsMessage.cstyle((String)"unable to parse path %s", (Object[])new Object[]{path}), (Throwable)ex);
                }
            }
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid content type %s. Only structured content types are allowed.", (Object[])new Object[]{this.contentType}));
    }

    public <T> T parse(InputStream inputStream, Class<T> clazz) {
        this.checkSession();
        switch (this.contentType) {
            case JSON: 
            case YAML: 
            case XML: 
            case TSON: {
                return this.parse(new InputStreamReader(this.prepareInputStream(inputStream, null)), clazz);
            }
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid content type %s. Only structured content types are allowed.", (Object[])new Object[]{this.contentType}));
    }

    public <T> T parse(String string, Class<T> clazz) {
        this.checkSession();
        switch (this.contentType) {
            case JSON: 
            case YAML: 
            case XML: 
            case TSON: {
                return this.parse(new StringReader(string), clazz);
            }
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid content type %s. Only structured content types are allowed.", (Object[])new Object[]{this.contentType}));
    }

    public <T> T parse(byte[] bytes, Class<T> clazz) {
        this.checkSession();
        switch (this.contentType) {
            case JSON: 
            case YAML: 
            case XML: 
            case TSON: {
                return this.parse(new InputStreamReader(this.prepareInputStream(new ByteArrayInputStream(bytes), null)), clazz);
            }
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid content type %s. Only structured content types are allowed.", (Object[])new Object[]{this.contentType}));
    }

    public <T> T parse(Reader reader, Class<T> clazz) {
        return (T)this.elementToObject(this.resolveStructuredFormat().parseElement(reader, this.createFactoryContext()), clazz);
    }

    public <T> T parse(Path file, Class<T> clazz) {
        this.checkSession();
        return this.parse(NutsPath.of((Path)file, (NutsSession)this.getSession()), clazz);
    }

    public <T> T parse(File file, Class<T> clazz) {
        this.checkSession();
        return this.parse(NutsPath.of((File)file, (NutsSession)this.getSession()), clazz);
    }

    public NutsElement parse(URL url) {
        return this.parse(url, NutsElement.class);
    }

    public NutsElement parse(InputStream inputStream) {
        return this.parse(inputStream, NutsElement.class);
    }

    public NutsElement parse(String string) {
        if (string == null || string.isEmpty()) {
            return this.ofNull();
        }
        return this.parse(string, NutsElement.class);
    }

    public NutsElement parse(byte[] bytes) {
        return this.parse(bytes, NutsElement.class);
    }

    public NutsElement parse(Reader reader) {
        return this.parse(reader, NutsElement.class);
    }

    public NutsElement parse(Path file) {
        return this.parse(file, NutsElement.class);
    }

    public NutsElement parse(File file) {
        return this.parse(file, NutsElement.class);
    }

    public NutsElement parse(NutsPath file) {
        return this.parse(file, NutsElement.class);
    }

    public <T> T convert(Object any, Class<T> to) {
        if (to == null || to.isInstance(any)) {
            return (T)any;
        }
        NutsElement e = this.toElement(any);
        return (T)this.elementToObject(e, to);
    }

    public Object destruct(Object any) {
        return this.createFactoryContext().destruct(any, null);
    }

    public NutsElement toElement(Object o) {
        return this.createFactoryContext().objectToElement(o, null);
    }

    public <T> T fromElement(NutsElement o, Class<T> to) {
        return this.convert(o, to);
    }

    public NutsElementEntry ofEntry(NutsElement key, NutsElement value) {
        return new DefaultNutsElementEntry((NutsElement)(key == null ? this.ofNull() : key), (NutsElement)(value == null ? this.ofNull() : value));
    }

    public NutsObjectElementBuilder ofObject() {
        return new DefaultNutsObjectElementBuilder(this.getSession());
    }

    public NutsArrayElementBuilder ofArray() {
        return new DefaultNutsArrayElementBuilder(this.getSession());
    }

    public NutsPrimitiveElement ofBoolean(String value) {
        return this.ofBoolean(NutsUtilStrings.parseBoolean((String)value, (Boolean)false, (Boolean)false));
    }

    public NutsPrimitiveElement ofBoolean(boolean value) {
        this.checkSession();
        if (value) {
            return new DefaultNutsPrimitiveElement(NutsElementType.BOOLEAN, true, this.getSession());
        }
        return new DefaultNutsPrimitiveElement(NutsElementType.BOOLEAN, false, this.getSession());
    }

    public NutsPrimitiveElement ofString(String str) {
        this.checkSession();
        return str == null ? this.ofNull() : new DefaultNutsPrimitiveElement(NutsElementType.STRING, str, this.getSession());
    }

    public NutsCustomElement ofCustom(Object object) {
        this.checkSession();
        if (object == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"custom element cannot be null", (Object[])new Object[0]));
        }
        return new DefaultNutsCustomElement(object, this.getSession());
    }

    public NutsPrimitiveElement ofTrue() {
        return this.ofBoolean(true);
    }

    public NutsPrimitiveElement ofFalse() {
        return this.ofBoolean(false);
    }

    public NutsPrimitiveElement ofInstant(Instant instant) {
        this.checkSession();
        return instant == null ? this.ofNull() : new DefaultNutsPrimitiveElement(NutsElementType.INSTANT, instant, this.getSession());
    }

    public NutsPrimitiveElement ofFloat(Float value) {
        this.checkSession();
        return value == null ? this.ofNull() : new DefaultNutsPrimitiveElement(NutsElementType.FLOAT, value, this.getSession());
    }

    public NutsPrimitiveElement ofInt(Integer value) {
        this.checkSession();
        return value == null ? this.ofNull() : new DefaultNutsPrimitiveElement(NutsElementType.INTEGER, value, this.getSession());
    }

    public NutsPrimitiveElement ofLong(Long value) {
        this.checkSession();
        return value == null ? this.ofNull() : new DefaultNutsPrimitiveElement(NutsElementType.LONG, value, this.getSession());
    }

    public NutsPrimitiveElement ofNull() {
        this.checkSession();
        return new DefaultNutsPrimitiveElement(NutsElementType.NULL, null, this.getSession());
    }

    public NutsPrimitiveElement ofNumber(String value) {
        this.checkSession();
        if (value == null) {
            return this.ofNull();
        }
        if (value.indexOf(46) >= 0) {
            try {
                return this.ofNumber(Double.parseDouble(value));
            }
            catch (Exception exception) {
                try {
                    return this.ofNumber(new BigDecimal(value));
                }
                catch (Exception exception2) {
                }
            }
        } else {
            try {
                return this.ofNumber(Integer.parseInt(value));
            }
            catch (Exception exception) {
                try {
                    return this.ofNumber(Long.parseLong(value));
                }
                catch (Exception exception3) {
                    try {
                        return this.ofNumber(new BigInteger(value));
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
            }
        }
        throw new NutsParseException(this.getSession(), NutsMessage.cstyle((String)"unable to parse number %s", (Object[])new Object[]{value}));
    }

    public NutsPrimitiveElement ofInstant(Date value) {
        this.checkSession();
        if (value == null) {
            return this.ofNull();
        }
        return new DefaultNutsPrimitiveElement(NutsElementType.INSTANT, value.toInstant(), this.getSession());
    }

    public NutsPrimitiveElement ofInstant(String value) {
        this.checkSession();
        if (value == null) {
            return this.ofNull();
        }
        return new DefaultNutsPrimitiveElement(NutsElementType.INSTANT, DefaultNutsPrimitiveElement.parseInstant(value, this.getSession()), this.getSession());
    }

    public NutsPrimitiveElement ofByte(Byte value) {
        this.checkSession();
        return value == null ? this.ofNull() : new DefaultNutsPrimitiveElement(NutsElementType.BYTE, value, this.getSession());
    }

    public NutsPrimitiveElement ofDouble(Double value) {
        this.checkSession();
        return value == null ? this.ofNull() : new DefaultNutsPrimitiveElement(NutsElementType.DOUBLE, value, this.getSession());
    }

    public NutsPrimitiveElement ofFloat(Short value) {
        this.checkSession();
        return value == null ? this.ofNull() : new DefaultNutsPrimitiveElement(NutsElementType.SHORT, value, this.getSession());
    }

    public NutsPrimitiveElement ofNumber(Number value) {
        this.checkSession();
        if (value == null) {
            return this.ofNull();
        }
        switch (value.getClass().getName()) {
            case "java.lang.Byte": {
                return new DefaultNutsPrimitiveElement(NutsElementType.BYTE, value, this.getSession());
            }
            case "java.lang.Short": {
                return new DefaultNutsPrimitiveElement(NutsElementType.SHORT, value, this.getSession());
            }
            case "java.lang.Integer": {
                return new DefaultNutsPrimitiveElement(NutsElementType.INTEGER, value, this.getSession());
            }
            case "java.lang.Long": {
                return new DefaultNutsPrimitiveElement(NutsElementType.LONG, value, this.getSession());
            }
            case "java.math.BigInteger": {
                return new DefaultNutsPrimitiveElement(NutsElementType.BIG_INTEGER, value, this.getSession());
            }
            case "java.lang.float": {
                return new DefaultNutsPrimitiveElement(NutsElementType.FLOAT, value, this.getSession());
            }
            case "java.lang.Double": {
                return new DefaultNutsPrimitiveElement(NutsElementType.DOUBLE, value, this.getSession());
            }
            case "java.math.BigDecimal": {
                return new DefaultNutsPrimitiveElement(NutsElementType.BIG_DECIMAL, value, this.getSession());
            }
        }
        return new DefaultNutsPrimitiveElement(NutsElementType.FLOAT, value, this.getSession());
    }

    public Predicate<Class> getIndestructibleObjects() {
        return this.indestructibleObjects;
    }

    public NutsElements setIndestructibleFormat() {
        return this.setIndestructibleObjects(DEFAULT_INDESTRUCTIBLE_FORMAT);
    }

    public NutsElements setIndestructibleObjects(Predicate<Class> destructTypeFilter) {
        this.indestructibleObjects = destructTypeFilter;
        return this;
    }

    public NutsIterableFormat iter(NutsPrintStream writer) {
        switch (this.getContentType()) {
            case JSON: {
                return new DefaultSearchFormatJson(this.getSession(), writer, new NutsFetchDisplayOptions(this.getSession()));
            }
            case XML: {
                return new DefaultSearchFormatXml(this.getSession(), writer, new NutsFetchDisplayOptions(this.getSession()));
            }
            case PLAIN: {
                return new DefaultSearchFormatPlain(this.getSession(), writer, new NutsFetchDisplayOptions(this.getSession()));
            }
            case TABLE: {
                return new DefaultSearchFormatTable(this.getSession(), writer, new NutsFetchDisplayOptions(this.getSession()));
            }
            case TREE: {
                return new DefaultSearchFormatTree(this.getSession(), writer, new NutsFetchDisplayOptions(this.getSession()));
            }
            case PROPS: {
                return new DefaultSearchFormatProps(this.getSession(), writer, new NutsFetchDisplayOptions(this.getSession()));
            }
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)("unsupported iterator for " + this.getContentType()), (Object[])new Object[0]));
    }

    public <T> NutsElements setMapper(Class<T> type, NutsElementMapper<T> mapper) {
        this.checkSession();
        ((DefaultNutsElementFactoryService)this.getElementFactoryService()).setMapper(type, mapper);
        return this;
    }

    private NutsElementStreamFormat resolveStructuredFormat() {
        this.checkSession();
        switch (this.contentType) {
            case JSON: {
                return this.model.getJsonMan(this.getSession());
            }
            case YAML: {
                return this.model.getYamlMan(this.getSession());
            }
            case XML: {
                return this.model.getXmlMan(this.getSession());
            }
            case TSON: {
                throw new NutsUnsupportedEnumException(this.getSession(), (Enum)this.contentType);
            }
        }
        throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"invalid content type %s. Only structured content types are allowed.", (Object[])new Object[]{this.contentType}));
    }

    private DefaultNutsElementFactoryContext createFactoryContext() {
        DefaultNutsElementFactoryContext c = new DefaultNutsElementFactoryContext(this);
        switch (this.getContentType()) {
            case JSON: 
            case YAML: 
            case XML: 
            case TSON: {
                c.setNtf(false);
            }
        }
        return c;
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        return false;
    }

    private void print(NutsPrintStream out, NutsElementStreamFormat format) {
        this.checkSession();
        NutsElement elem = this.toElement(this.value);
        if (out.isNtf()) {
            NutsMemoryPrintStream bos = NutsMemoryPrintStream.of((NutsSession)this.getSession());
            format.printElement(elem, (NutsPrintStream)bos, this.compact, this.createFactoryContext());
            out.print((NutsString)NutsTexts.of((NutsSession)this.getSession()).ofCode(this.getContentType().id(), bos.toString()));
        } else {
            format.printElement(elem, out, this.compact, this.createFactoryContext());
        }
        out.flush();
    }

    @Override
    public void print(NutsPrintStream out) {
        this.print(out, this.resolveStructuredFormat());
    }

    public Object elementToObject(NutsElement o, Type type) {
        return this.createFactoryContext().elementToObject(o, type);
    }

    public NutsElementFactoryService getElementFactoryService() {
        return this.model.getElementFactoryService(this.getSession());
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }

    public NutsProgressFactory getProgressFactory() {
        return this.progressFactory;
    }

    public NutsElements setProgressFactory(NutsProgressFactory progressFactory) {
        this.progressFactory = progressFactory;
        return this;
    }
}

