/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsArrayElementBuilder;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorProperty;
import net.thevpc.nuts.NutsDescriptorPropertyBuilder;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementEntry;
import net.thevpc.nuts.NutsElementFactoryContext;
import net.thevpc.nuts.NutsElementMapper;
import net.thevpc.nuts.NutsElementType;
import net.thevpc.nuts.NutsEnum;
import net.thevpc.nuts.NutsEnvCondition;
import net.thevpc.nuts.NutsEnvConditionBuilder;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdLocation;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsObjectElementBuilder;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPlatformLocation;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsArrayElement;
import net.thevpc.nuts.runtime.standalone.elem.NutsElementFactoryService;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperArray;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperBoolean;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperChar;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperCollection;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperCommandLine;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperEnum;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperFile;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperFloatArray;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperInstant;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperIterator;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperMap;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperMapEntry;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNamedElement;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNull;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNumber;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsArrayElement;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsArtifactCall;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsDefinition;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsDependency;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsDescriptor;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsDescriptorProperty;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsDescriptorPropertyBuilder;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsElement;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsEnum;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsEnvCondition;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsEnvConditionBuilder;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsFilter;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsId;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsIdLocation;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsObjectElement;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsPath;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsPlatformLocation;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsPrimitiveElement;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsRepositoryLocation;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsString;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsText;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperNutsVersion;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperObjReflect;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperObjectArray;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperPath;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperPrimitiveBooleanArray;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperPrimitiveByteArray;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperPrimitiveCharArray;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperPrimitiveDoubleArray;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperPrimitiveIntArray;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperPrimitiveLongArray;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperPrimitiveShortArray;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperString;
import net.thevpc.nuts.runtime.standalone.elem.mapper.NutsElementMapperUtilDate;
import net.thevpc.nuts.runtime.standalone.format.xml.NutsElementFactoryXmlDocument;
import net.thevpc.nuts.runtime.standalone.format.xml.NutsElementFactoryXmlElement;
import net.thevpc.nuts.runtime.standalone.util.collections.ClassMap;
import net.thevpc.nuts.runtime.standalone.util.reflect.ReflectRepository;
import net.thevpc.nuts.runtime.standalone.util.reflect.ReflectUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsRepositoryLocation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultNutsElementFactoryService
implements NutsElementFactoryService {
    private static final NutsElementMapper F_NULL = new NutsElementMapperNull();
    private static final NutsElementMapper F_NUTS_ARR = new NutsElementMapperArray();
    private static final NutsElementMapper F_STRINGS = new NutsElementMapperString();
    private static final NutsElementMapper F_CHAR = new NutsElementMapperChar();
    private static final NutsElementMapper F_NUMBERS = new NutsElementMapperNumber();
    private static final NutsElementMapper F_BOOLEANS = new NutsElementMapperBoolean();
    private static final NutsElementMapper F_ENUMS = new NutsElementMapperEnum();
    private static final NutsElementMapper F_INSTANT = new NutsElementMapperInstant();
    private static final NutsElementMapper F_DATE = new NutsElementMapperUtilDate();
    private static final NutsElementMapper F_PATH = new NutsElementMapperPath();
    private static final NutsElementMapper F_FILE = new NutsElementMapperFile();
    private static final NutsElementMapper F_ITERATOR = new NutsElementMapperIterator();
    private static final NutsElementMapper F_NAMED_ELEM = new NutsElementMapperNamedElement();
    private static final NutsElementMapper F_MAPENTRY = new NutsElementMapperMapEntry();
    private static final NutsElementMapper F_XML_ELEMENT = new NutsElementFactoryXmlElement();
    private static final NutsElementMapper F_XML_DOCUMENT = new NutsElementFactoryXmlDocument();
    private static final NutsElementMapper F_NUTS_DEF = new NutsElementMapperNutsDefinition();
    private static final NutsElementMapper F_NUTS_ID = new NutsElementMapperNutsId();
    private static final NutsElementMapper F_NUTS_VERSION = new NutsElementMapperNutsVersion();
    private static final NutsElementMapper F_NUTS_DESCRIPTOR = new NutsElementMapperNutsDescriptor();
    private static final NutsElementMapper F_NUTS_ENV_CONDITION = new NutsElementMapperNutsEnvCondition();
    private static final NutsElementMapper F_NUTS_ENV_CONDITION_BUILDER = new NutsElementMapperNutsEnvConditionBuilder();
    private static final NutsElementMapper F_NUTS_DEPENDENCY = new NutsElementMapperNutsDependency();
    private static final NutsElementMapper F_NUTS_SDK_LOCATION = new NutsElementMapperNutsPlatformLocation();
    private static final NutsElementMapper F_NUTS_ID_LOCATION = new NutsElementMapperNutsIdLocation();
    private static final NutsElementMapper F_ARTIFACT_CALL = new NutsElementMapperNutsArtifactCall();
    private static final NutsElementMapper F_DESCRIPTOR_PROPERTY = new NutsElementMapperNutsDescriptorProperty();
    private static final NutsElementMapper F_DESCRIPTOR_PROPERTY_BUILDER = new NutsElementMapperNutsDescriptorPropertyBuilder();
    private static final NutsElementMapper F_NUTS_ENUM = new NutsElementMapperNutsEnum();
    private static final NutsElementMapper F_NUTS_REPO_LOCATION = new NutsElementMapperNutsRepositoryLocation();
    private final ClassMap<NutsElementMapper> defaultMappers = new ClassMap<NutsElementMapper>(null, NutsElementMapper.class);
    private final Map<Class, NutsElementMapper> coreMappers = new HashMap<Class, NutsElementMapper>();
    private final ClassMap<NutsElementMapper> customMappers = new ClassMap<NutsElementMapper>(null, NutsElementMapper.class);
    private ReflectRepository typesRepository;
    private final NutsWorkspace ws;
    private final NutsSession session;
    private final NutsElementMapper F_OBJ = new NutsElementMapperObjReflect(this);
    private final NutsElementMapper F_COLLECTION = new NutsElementMapperCollection(this);
    private final NutsElementMapper F_MAP = new NutsElementMapperMap(this);

    public DefaultNutsElementFactoryService(NutsWorkspace ws, NutsSession session) {
        this.typesRepository = NutsWorkspaceUtils.of(session).getReflectRepository();
        this.addDefaultMapper(Boolean.class, F_BOOLEANS);
        this.addDefaultMapper(Boolean.TYPE, F_BOOLEANS);
        this.addDefaultMapper(Byte.TYPE, F_NUMBERS);
        this.addDefaultMapper(Short.TYPE, F_NUMBERS);
        this.addDefaultMapper(Integer.TYPE, F_NUMBERS);
        this.addDefaultMapper(Long.TYPE, F_NUMBERS);
        this.addDefaultMapper(Float.TYPE, F_NUMBERS);
        this.addDefaultMapper(Double.TYPE, F_NUMBERS);
        this.addDefaultMapper(Number.class, F_NUMBERS);
        this.addDefaultMapper(Character.TYPE, F_CHAR);
        this.addDefaultMapper(Character.class, F_CHAR);
        this.addDefaultMapper(Object.class, this.F_OBJ);
        this.addDefaultMapper(String.class, F_STRINGS);
        this.addDefaultMapper(StringBuilder.class, F_STRINGS);
        this.addDefaultMapper(StringBuffer.class, F_STRINGS);
        this.addDefaultMapper(Path.class, F_PATH);
        this.addDefaultMapper(File.class, F_FILE);
        this.addDefaultMapper(Date.class, F_DATE);
        this.addDefaultMapper(Instant.class, F_INSTANT);
        this.addDefaultMapper(Enum.class, F_ENUMS);
        this.addDefaultMapper(Collection.class, this.F_COLLECTION);
        this.addDefaultMapper(Iterator.class, F_ITERATOR);
        this.addDefaultMapper(Map.class, this.F_MAP);
        this.addDefaultMapper(Map.Entry.class, F_MAPENTRY);
        this.addDefaultMapper(Element.class, F_XML_ELEMENT);
        this.addDefaultMapper(Document.class, F_XML_DOCUMENT);
        this.addDefaultMapper(boolean[].class, new NutsElementMapperPrimitiveBooleanArray());
        this.addDefaultMapper(byte[].class, new NutsElementMapperPrimitiveByteArray());
        this.addDefaultMapper(short[].class, new NutsElementMapperPrimitiveShortArray());
        this.addDefaultMapper(char[].class, new NutsElementMapperPrimitiveCharArray());
        this.addDefaultMapper(int[].class, new NutsElementMapperPrimitiveIntArray());
        this.addDefaultMapper(long[].class, new NutsElementMapperPrimitiveLongArray());
        this.addDefaultMapper(float[].class, new NutsElementMapperFloatArray());
        this.addDefaultMapper(double[].class, new NutsElementMapperPrimitiveDoubleArray());
        this.addDefaultMapper(Object[].class, new NutsElementMapperObjectArray());
        this.addDefaultMapper(NutsPrimitiveElement.class, new NutsElementMapperNutsPrimitiveElement());
        this.addDefaultMapper(NutsArrayElement.class, new NutsElementMapperNutsArrayElement());
        this.addDefaultMapper(NutsObjectElement.class, new NutsElementMapperNutsObjectElement());
        this.addDefaultMapper(NutsArrayElementBuilder.class, new NutsElementMapperNutsElementBuilder());
        this.addDefaultMapper(NutsObjectElementBuilder.class, new NutsElementMapperNutsElementBuilder());
        this.addDefaultMapper(NutsElement.class, new NutsElementMapperNutsElement());
        this.addDefaultMapper(NutsElementEntry.class, F_NAMED_ELEM);
        this.addDefaultMapper(NutsCommandLine.class, new NutsElementMapperCommandLine());
        this.addDefaultMapper(NutsString.class, new NutsElementMapperNutsString());
        this.addDefaultMapper(NutsText.class, new NutsElementMapperNutsText());
        this.addDefaultMapper(NutsPath.class, new NutsElementMapperNutsPath());
        this.addDefaultMapper(NutsFilter.class, new NutsElementMapperNutsFilter());
        this.setCoreMapper(NutsDefinition.class, F_NUTS_DEF);
        this.setCoreMapper(NutsId.class, F_NUTS_ID);
        this.setCoreMapper(NutsVersion.class, F_NUTS_VERSION);
        this.setCoreMapper(NutsDescriptor.class, F_NUTS_DESCRIPTOR);
        this.setCoreMapper(NutsDependency.class, F_NUTS_DEPENDENCY);
        this.setCoreMapper(NutsIdLocation.class, F_NUTS_ID_LOCATION);
        this.setCoreMapper(NutsArtifactCall.class, F_ARTIFACT_CALL);
        this.setCoreMapper(NutsPlatformLocation.class, F_NUTS_SDK_LOCATION);
        this.setCoreMapper(NutsEnvCondition.class, F_NUTS_ENV_CONDITION);
        this.setCoreMapper(NutsEnvConditionBuilder.class, F_NUTS_ENV_CONDITION_BUILDER);
        this.setCoreMapper(NutsDescriptorProperty.class, F_DESCRIPTOR_PROPERTY);
        this.setCoreMapper(NutsDescriptorPropertyBuilder.class, F_DESCRIPTOR_PROPERTY_BUILDER);
        this.setCoreMapper(NutsEnum.class, F_NUTS_ENUM);
        this.setCoreMapper(NutsRepositoryLocation.class, F_NUTS_REPO_LOCATION);
        this.ws = ws;
        this.session = session;
    }

    public final void addDefaultMapper(Class cls, NutsElementMapper instance) {
        this.defaultMappers.put(cls, instance);
    }

    public final void setCoreMapper(Class cls, NutsElementMapper instance) {
        this.coreMappers.put(cls, instance);
        this.customMappers.put(cls, instance);
    }

    public final void setMapper(Class cls, NutsElementMapper instance) {
        if (instance == null) {
            NutsElementMapper cc = this.coreMappers.get(cls);
            if (cc != null) {
                this.customMappers.put(cls, cc);
            } else {
                this.customMappers.remove(cls);
            }
        } else {
            this.customMappers.put(cls, instance);
        }
    }

    public NutsElementMapper getMapper(Type type, boolean defaultOnly) {
        NutsElementMapper f;
        if (type == null) {
            return F_NULL;
        }
        Class cls = ReflectUtils.getRawClass(type);
        if (NutsSession.class.isAssignableFrom(cls)) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"%s is not serializable", (Object[])new Object[]{type}));
        }
        if (cls.isArray()) {
            NutsElementMapper f2 = this.defaultMappers.getExact(cls);
            if (f2 != null) {
                return f2;
            }
            return F_NUTS_ARR;
        }
        if (!defaultOnly && (f = this.customMappers.get(cls)) != null) {
            return f;
        }
        NutsElementMapper r = this.defaultMappers.get(cls);
        if (r != null) {
            return r;
        }
        throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"unable to find serialization factory for %s", (Object[])new Object[]{type}));
    }

    protected Object createObject(NutsElement o, Type to, NutsElementFactoryContext context, boolean defaultOnly) {
        if (o == null || o.type() == NutsElementType.NULL) {
            return F_NULL.createObject(o, (Type)((Object)to), context);
        }
        if (to == null) {
            switch (o.type()) {
                case OBJECT: {
                    to = Map.class;
                    break;
                }
                case ARRAY: {
                    to = List.class;
                    break;
                }
                case STRING: {
                    to = String.class;
                    break;
                }
                case INTEGER: {
                    to = Integer.class;
                    break;
                }
                case FLOAT: {
                    to = Float.class;
                    break;
                }
                case DOUBLE: {
                    to = Double.class;
                    break;
                }
                case BOOLEAN: {
                    to = Boolean.class;
                    break;
                }
                case INSTANT: {
                    to = Instant.class;
                    break;
                }
                case BIG_DECIMAL: {
                    to = BigDecimal.class;
                    break;
                }
                case BIG_INTEGER: {
                    to = BigInteger.class;
                    break;
                }
                case LONG: {
                    to = Long.class;
                    break;
                }
                case BYTE: {
                    to = Byte.class;
                    break;
                }
                case SHORT: {
                    to = Short.class;
                    break;
                }
                case NULL: {
                    return null;
                }
                default: {
                    throw new NutsUnsupportedEnumException(context.getSession(), (Enum)o.type());
                }
            }
        }
        NutsElementMapper f = this.getMapper((Type)((Object)to), defaultOnly);
        return f.createObject(o, to, context);
    }

    @Override
    public Object createObject(NutsElement o, Type to, NutsElementFactoryContext context) {
        return this.createObject(o, to, context, false);
    }

    @Override
    public Object defaultCreateObject(NutsElement o, Type to, NutsElementFactoryContext context) {
        return this.createObject(o, to, context, true);
    }

    protected Object destruct(Object o, Type expectedType, NutsElementFactoryContext context, boolean defaultOnly) {
        if (o == null) {
            return null;
        }
        if (expectedType == null) {
            expectedType = o.getClass();
        }
        if (context.getIndestructibleObjects() != null && context.getIndestructibleObjects().test(o.getClass())) {
            return o;
        }
        return this.getMapper(expectedType, defaultOnly).destruct(o, expectedType, context);
    }

    @Override
    public Object destruct(Object o, Type expectedType, NutsElementFactoryContext context) {
        return this.destruct(o, expectedType, context, false);
    }

    @Override
    public Object defaultDestruct(Object o, Type expectedType, NutsElementFactoryContext context) {
        return this.destruct(o, expectedType, context, true);
    }

    protected NutsElement createElement(Object o, Type expectedType, NutsElementFactoryContext context, boolean defaultOnly) {
        if (o == null) {
            return context.elem().ofNull();
        }
        if (expectedType == null) {
            expectedType = o.getClass();
        }
        if (context.getIndestructibleObjects() != null && context.getIndestructibleObjects().test(o.getClass())) {
            return context.elem().ofCustom(o);
        }
        return this.getMapper(expectedType, defaultOnly).createElement(o, expectedType, context);
    }

    @Override
    public NutsElement createElement(Object o, Type expectedType, NutsElementFactoryContext context) {
        return this.createElement(o, expectedType, context, false);
    }

    @Override
    public NutsElement defaultCreateElement(Object o, Type expectedType, NutsElementFactoryContext context) {
        return this.createElement(o, expectedType, context, true);
    }

    public ReflectRepository getTypesRepository() {
        return this.typesRepository;
    }

    public static List<Object> _destructArray1(Object array, NutsElementFactoryContext context) {
        if (array.getClass().getComponentType().isPrimitive()) {
            ArrayList<Object> preloaded = new ArrayList<Object>();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                preloaded.add(context.destruct(Array.get(array, i), null));
            }
            return preloaded;
        }
        return Arrays.stream((Object[])array).map(x -> context.destruct(x, null)).collect(Collectors.toList());
    }

    public static NutsArrayElement _createArray1(Object array, NutsElementFactoryContext context) {
        if (array.getClass().getComponentType().isPrimitive()) {
            ArrayList<NutsElement> preloaded = new ArrayList<NutsElement>();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                preloaded.add(context.objectToElement(Array.get(array, i), null));
            }
            return new DefaultNutsArrayElement(preloaded, context.getSession());
        }
        return new DefaultNutsArrayElement(Arrays.stream((Object[])array).map(x -> context.objectToElement(x, null)).collect(Collectors.toList()), context.getSession());
    }
}

