/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementFactoryContext;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNutsElements;

public class DefaultNutsElementFactoryContext
implements NutsElementFactoryContext {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Set<RefItem> visited = new LinkedHashSet<RefItem>();
    private final DefaultNutsElements base;
    private boolean ntf;

    public DefaultNutsElementFactoryContext(DefaultNutsElements base) {
        this.base = base;
        this.ntf = base.isNtf();
    }

    public NutsSession getSession() {
        return this.base.getSession();
    }

    public Predicate<Class> getIndestructibleObjects() {
        return this.base.getIndestructibleObjects();
    }

    public NutsWorkspace getWorkspace() {
        return this.base.getWorkspace();
    }

    public NutsElements elem() {
        return this.base;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    private String stacktrace() {
        StringBuilder sb = new StringBuilder();
        boolean nl = false;
        for (RefItem refItem : this.visited) {
            if (nl) {
                sb.append("\n");
            } else {
                nl = true;
            }
            sb.append(refItem.step).append(": ").append(refItem.o.getClass().getName());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NutsElement defaultObjectToElement(Object o, Type expectedType) {
        if (o != null) {
            RefItem ro = new RefItem(o, "defaultObjectToElement");
            if (this.visited.contains(ro)) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unable to serialize object of type %s because of cyclic references: %s", (Object[])new Object[]{o.getClass().getName(), this.stacktrace()}));
            }
            this.visited.add(ro);
            try {
                NutsElement nutsElement = this.base.getElementFactoryService().defaultCreateElement(o, expectedType, this);
                return nutsElement;
            }
            finally {
                this.visited.remove(ro);
            }
        }
        return this.base.getElementFactoryService().defaultCreateElement(o, expectedType, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object defaultDestruct(Object o, Type expectedType) {
        if (o != null) {
            RefItem ro = new RefItem(o, "defaultDestruct");
            if (this.visited.contains(ro)) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unable to destruct object of type %s because of cyclic references: %s", (Object[])new Object[]{o.getClass().getName(), this.stacktrace()}));
            }
            this.visited.add(ro);
            try {
                Object object = this.base.getElementFactoryService().defaultDestruct(o, expectedType, this);
                return object;
            }
            finally {
                this.visited.remove(ro);
            }
        }
        return this.base.getElementFactoryService().defaultDestruct(o, expectedType, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NutsElement objectToElement(Object o, Type expectedType) {
        if (o != null) {
            RefItem ro = new RefItem(o, "objectToElement");
            if (this.visited.contains(ro)) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unable to serialize object of type %s because of cyclic references: %s", (Object[])new Object[]{o.getClass().getName(), this.stacktrace()}));
            }
            this.visited.add(ro);
            try {
                NutsElement nutsElement = this.base.getElementFactoryService().createElement(o, expectedType, this);
                return nutsElement;
            }
            finally {
                this.visited.remove(ro);
            }
        }
        return this.base.getElementFactoryService().createElement(o, expectedType, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object destruct(Object o, Type expectedType) {
        if (o != null) {
            RefItem ro = new RefItem(o, "destruct");
            if (this.visited.contains(ro)) {
                throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"unable to destruct object of type %s because of cyclic references.", (Object[])new Object[]{o.getClass().getName()}));
            }
            this.visited.add(ro);
            try {
                Object object = this.base.getElementFactoryService().destruct(o, expectedType, this);
                return object;
            }
            finally {
                this.visited.remove(ro);
            }
        }
        return this.base.getElementFactoryService().destruct(o, expectedType, this);
    }

    public <T> T elementToObject(NutsElement o, Class<T> type) {
        return (T)this.elementToObject(o, (Type)type);
    }

    public Object elementToObject(NutsElement o, Type type) {
        return this.base.getElementFactoryService().createObject(o, type, this);
    }

    public <T> T defaultElementToObject(NutsElement o, Class<T> type) {
        return (T)this.defaultElementToObject(o, (Type)type);
    }

    public Object defaultElementToObject(NutsElement o, Type type) {
        return this.base.getElementFactoryService().defaultCreateObject(o, type, this);
    }

    public boolean isNtf() {
        return this.ntf;
    }

    public DefaultNutsElementFactoryContext setNtf(boolean ntf) {
        this.ntf = ntf;
        return this;
    }

    private static class RefItem {
        private final Object o;
        private final String step;

        public RefItem(Object o, String step) {
            this.o = o;
            this.step = step;
        }

        public int hashCode() {
            return System.identityHashCode(this.o) * 31 + this.step.hashCode();
        }

        public boolean equals(Object o1) {
            if (this == o1) {
                return true;
            }
            if (o1 == null || this.getClass() != o1.getClass()) {
                return false;
            }
            RefItem refItem = (RefItem)o1;
            return this.o == refItem.o && this.step.equals(refItem.step);
        }

        public String toString() {
            return this.step + "(" + this.o + ')';
        }
    }
}

