/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsArrayElementBuilder;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.elem.AbstractNutsArrayElement;

public class DefaultNutsArrayElement
extends AbstractNutsArrayElement {
    private final NutsElement[] values;

    public DefaultNutsArrayElement(Collection<NutsElement> values, NutsSession session) {
        super(session);
        this.values = values.toArray(new NutsElement[0]);
    }

    public DefaultNutsArrayElement(NutsElement[] values, NutsSession session) {
        super(session);
        this.values = Arrays.copyOf(values, values.length);
    }

    public Collection<NutsElement> children() {
        return Arrays.asList(this.values);
    }

    public int size() {
        return this.values.length;
    }

    public Stream<NutsElement> stream() {
        return Arrays.asList(this.values).stream();
    }

    public NutsElement get(int index) {
        return this.values[index];
    }

    public String getString(int index) {
        return this.get(index).asString();
    }

    public boolean getBoolean(int index) {
        return this.get(index).asBoolean();
    }

    public byte getByte(int index) {
        return this.get(index).asByte();
    }

    public short getShort(int index) {
        return this.get(index).asShort();
    }

    public int getInt(int index) {
        return this.get(index).asInt();
    }

    public long getLong(int index) {
        return this.get(index).asLong();
    }

    public float getFloat(int index) {
        return this.get(index).asFloat();
    }

    public double getDouble(int index) {
        return this.get(index).asDouble();
    }

    public Instant getInstant(int index) {
        return this.get(index).asInstant();
    }

    public NutsArrayElement getArray(int index) {
        return this.get(index).asArray();
    }

    public NutsObjectElement getObject(int index) {
        return this.get(index).asObject();
    }

    public NutsArrayElementBuilder builder() {
        return NutsElements.of((NutsSession)this.session).ofArray().set((NutsArrayElement)this);
    }

    public Iterator<NutsElement> iterator() {
        return Arrays.asList(this.values).iterator();
    }

    @Override
    public String toString() {
        return "[" + this.children().stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + Arrays.deepHashCode(this.values);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNutsArrayElement other = (DefaultNutsArrayElement)obj;
        return Arrays.deepEquals(this.values, other.values);
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public boolean isBlank() {
        return this.values.length == 0;
    }
}

