/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem;

import java.time.Instant;
import net.thevpc.nuts.NutsArrayElement;
import net.thevpc.nuts.NutsCustomElement;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElementType;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsObjectElement;
import net.thevpc.nuts.NutsPrimitiveElement;
import net.thevpc.nuts.NutsSession;

public abstract class AbstractNutsElement
implements NutsElement {
    protected transient NutsSession session;
    private NutsElementType type;

    public AbstractNutsElement(NutsElementType type, NutsSession session) {
        this.type = type;
        this.session = session;
    }

    public NutsElementType type() {
        return this.type;
    }

    public NutsPrimitiveElement asPrimitive() {
        if (this instanceof NutsPrimitiveElement) {
            return (NutsPrimitiveElement)this;
        }
        throw new IllegalStateException("unable to cast " + this.type().id() + " to primitive" + this);
    }

    public NutsObjectElement asObject() {
        if (this instanceof NutsObjectElement) {
            return (NutsObjectElement)this;
        }
        throw new IllegalStateException("unable to cast " + this.type().id() + " to object: " + this);
    }

    public NutsCustomElement asCustom() {
        if (this instanceof NutsCustomElement) {
            return (NutsCustomElement)this;
        }
        throw new IllegalStateException("unable to cast " + this.type().id() + " to custom: " + this);
    }

    public boolean isCustom() {
        return this instanceof NutsCustomElement;
    }

    public NutsObjectElement asSafeObject() {
        return this.asSafeObject(false);
    }

    public NutsArrayElement asSafeArray() {
        return this.asSafeArray(false);
    }

    public NutsArrayElement asArray() {
        if (this instanceof NutsArrayElement) {
            return (NutsArrayElement)this;
        }
        throw new IllegalStateException("unable to cast " + this.type().id() + " to array" + this);
    }

    public NutsObjectElement asSafeObject(boolean embed) {
        if (this instanceof NutsObjectElement) {
            return (NutsObjectElement)this;
        }
        if (embed && this.type() != NutsElementType.NULL) {
            return NutsElements.of((NutsSession)this.session).ofObject().set("value", (NutsElement)this).build();
        }
        return NutsElements.of((NutsSession)this.session).ofObject().build();
    }

    public NutsArrayElement asSafeArray(boolean embed) {
        if (this instanceof NutsArrayElement) {
            return (NutsArrayElement)this;
        }
        if (embed && this.type() != NutsElementType.NULL) {
            return NutsElements.of((NutsSession)this.session).ofArray().add((NutsElement)this).build();
        }
        return NutsElements.of((NutsSession)this.session).ofArray().build();
    }

    public boolean isPrimitive() {
        NutsElementType t = this.type();
        return t != NutsElementType.ARRAY && t != NutsElementType.OBJECT && t != NutsElementType.CUSTOM;
    }

    public boolean isNumber() {
        NutsElementType t = this.type();
        switch (t) {
            case BYTE: 
            case SHORT: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isNull() {
        NutsElementType t = this.type();
        return t == NutsElementType.NULL;
    }

    public boolean isString() {
        NutsElementType t = this.type();
        return t == NutsElementType.STRING;
    }

    public boolean isByte() {
        return this.type() == NutsElementType.BYTE;
    }

    public boolean isInt() {
        NutsElementType t = this.type();
        return t == NutsElementType.INTEGER;
    }

    public boolean isLong() {
        return this.type() == NutsElementType.LONG;
    }

    public boolean isShort() {
        return this.type() == NutsElementType.SHORT;
    }

    public boolean isFloat() {
        return this.type() == NutsElementType.FLOAT;
    }

    public boolean isDouble() {
        return this.type() == NutsElementType.DOUBLE;
    }

    public boolean isObject() {
        NutsElementType t = this.type();
        return t == NutsElementType.OBJECT;
    }

    public boolean isArray() {
        NutsElementType t = this.type();
        return t == NutsElementType.ARRAY;
    }

    public boolean isInstant() {
        return this.type() == NutsElementType.INSTANT;
    }

    public String asString() {
        return this.asPrimitive().getString();
    }

    public boolean asBoolean() {
        return this.asPrimitive().getBoolean();
    }

    public byte asByte() {
        return this.asPrimitive().getByte();
    }

    public double asDouble() {
        return this.asPrimitive().getDouble();
    }

    public float asFloat() {
        return this.asPrimitive().getFloat();
    }

    public Instant asInstant() {
        return this.asPrimitive().getInstant();
    }

    public Integer asSafeInt(Integer defaultValue) {
        if (this.isPrimitive()) {
            return this.asPrimitive().getInt(defaultValue);
        }
        return defaultValue;
    }

    public Instant asSafeInstant(Instant defaultValue) {
        if (this.isPrimitive()) {
            return this.asPrimitive().getInstant(defaultValue);
        }
        return defaultValue;
    }

    public Long asSafeLong(Long defaultValue) {
        if (this.isPrimitive()) {
            return this.asPrimitive().getLong(defaultValue);
        }
        return defaultValue;
    }

    public Short asSafeShort(Short defaultValue) {
        if (this.isPrimitive()) {
            return this.asPrimitive().getShort(defaultValue);
        }
        return defaultValue;
    }

    public Byte asSafeByte(Byte defaultValue) {
        if (this.isPrimitive()) {
            return this.asPrimitive().getByte(defaultValue);
        }
        return defaultValue;
    }

    public Double asSafeDouble(Double defaultValue) {
        if (this.isPrimitive()) {
            return this.asPrimitive().getDouble(defaultValue);
        }
        return defaultValue;
    }

    public Float asSafeFloat(Float defaultValue) {
        if (this.isPrimitive()) {
            return this.asPrimitive().getFloat(defaultValue);
        }
        return defaultValue;
    }

    public String asSafeString(String defaultValue) {
        if (this.isPrimitive()) {
            return this.asPrimitive().getString(defaultValue);
        }
        return defaultValue;
    }

    public int asInt() {
        return this.asPrimitive().getInt();
    }

    public long asLong() {
        return this.asPrimitive().getLong();
    }

    public short asShort() {
        return this.asPrimitive().getShort();
    }

    public NutsElement describe(NutsElements elems) {
        return this;
    }
}

