/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorProperty;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.NutsVersionParser;
import net.thevpc.nuts.runtime.standalone.id.util.NutsIdUtils;

public class NutsDescriptorUtils {
    public static Map<String, String> getPropertiesMap(NutsDescriptorProperty[] list, NutsSession session) {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (list != null) {
            for (NutsDescriptorProperty property : list) {
                if (property.getCondition() != null && !property.getCondition().isBlank()) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.plain((String)"unexpected properties with conditions. probably a bug"));
                }
                m.put(property.getName(), property.getValue());
            }
        }
        return m;
    }

    public static NutsDescriptor checkDescriptor(NutsDescriptor nutsDescriptor, NutsSession session) {
        NutsVersion version;
        NutsId id = nutsDescriptor.getId();
        String groupId = id == null ? null : id.getGroupId();
        String artifactId = id == null ? null : id.getArtifactId();
        NutsVersion nutsVersion = version = id == null ? null : id.getVersion();
        if (groupId == null || artifactId == null || NutsBlankable.isBlank((NutsBlankable)version)) {
            switch (session.getConfirm()) {
                case ASK: 
                case ERROR: {
                    if (groupId == null) {
                        groupId = (String)session.getTerminal().ask().forString(NutsMessage.cstyle((String)"group id", (Object[])new Object[0])).setDefaultValue((Object)groupId).setHintMessage(NutsBlankable.isBlank((String)groupId) ? null : NutsMessage.plain((String)groupId)).getValue();
                    }
                    if (artifactId == null) {
                        artifactId = (String)session.getTerminal().ask().forString(NutsMessage.cstyle((String)"artifact id", (Object[])new Object[0])).setDefaultValue((Object)artifactId).setHintMessage(NutsBlankable.isBlank((String)artifactId) ? null : NutsMessage.plain((String)artifactId)).getValue();
                    }
                    if (!NutsBlankable.isBlank((NutsBlankable)version)) break;
                    String ov = version == null ? null : version.getValue();
                    String v = (String)session.getTerminal().ask().forString(NutsMessage.cstyle((String)"version", (Object[])new Object[0])).setDefaultValue((Object)ov).setHintMessage(NutsBlankable.isBlank((String)ov) ? null : NutsMessage.plain((String)ov)).getValue();
                    version = NutsVersionParser.of((NutsSession)session).setAcceptBlank(true).setAcceptIntervals(true).setLenient(true).parse(v);
                    break;
                }
            }
        }
        if (groupId == null || artifactId == null || NutsBlankable.isBlank((NutsBlankable)version)) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"invalid descriptor id %s:%s#%s", (Object[])new Object[]{groupId, artifactId, version}));
        }
        return nutsDescriptor.builder().setId(NutsIdBuilder.of((NutsSession)session).setGroupId(groupId).setArtifactId(artifactId).setVersion(version).build()).build();
    }

    public static void checkValidEffectiveDescriptor(NutsDescriptor effectiveDescriptor, NutsSession session) {
        if (effectiveDescriptor == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to evaluate effective null descriptor", (Object[])new Object[0]));
        }
        try {
            for (NutsId nutsId : effectiveDescriptor.getParents()) {
                NutsIdUtils.checkValidEffectiveId(nutsId, session);
            }
            NutsIdUtils.checkValidEffectiveId(effectiveDescriptor.getId(), session);
            for (NutsId nutsId : effectiveDescriptor.getDependencies()) {
                NutsIdUtils.checkValidEffectiveId(nutsId.toId(), session);
            }
            for (NutsId nutsId : effectiveDescriptor.getStandardDependencies()) {
                if (nutsId == null) {
                    throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to evaluate effective null id", (Object[])new Object[0]));
                }
                if (!nutsId.toString().contains("${")) continue;
                NutsLoggerOp.of(NutsDescriptorUtils.class, (NutsSession)session).verb(NutsLogVerb.WARNING).level(Level.FINE).log(NutsMessage.jstyle((String)"{0} is using {1} which defines an unresolved variable. This is a potential bug.", (Object[])new Object[]{effectiveDescriptor.getId(), nutsId}));
            }
        }
        catch (Exception ex) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unable to evaluate effective descriptor for %s", (Object[])new Object[]{effectiveDescriptor.getId()}), (Throwable)ex);
        }
    }

    public static boolean isValidEffectiveDescriptor(NutsDescriptor effectiveDescriptor, NutsSession session) {
        try {
            NutsDescriptorUtils.checkValidEffectiveDescriptor(effectiveDescriptor, session);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

