/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.parser;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsDescriptorContentParserComponent;
import net.thevpc.nuts.spi.NutsDescriptorContentParserContext;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class ZipDescriptorContentParserComponent
implements NutsDescriptorContentParserComponent {
    public static final Set<String> POSSIBLE_PATHS = new LinkedHashSet<String>(Arrays.asList("nuts.json", "META-INF/nuts.json", "WEB-INF/nuts.json", "APP-INF/nuts.json"));
    public static final Set<String> POSSIBLE_EXT = new HashSet<String>(Arrays.asList("zip", "gzip", "gz", "war", "ear"));

    public int getSupportLevel(NutsSupportLevelContext criteria) {
        String e;
        NutsDescriptorContentParserContext constraints = (NutsDescriptorContentParserContext)criteria.getConstraints(NutsDescriptorContentParserContext.class);
        if (constraints != null && !POSSIBLE_EXT.contains(e = NutsUtilStrings.trim((String)constraints.getFileExtension()))) {
            return -1;
        }
        return -1;
    }

    public NutsDescriptor parse(NutsDescriptorContentParserContext parserContext) {
        String e = NutsUtilStrings.trim((String)parserContext.getFileExtension());
        if (!POSSIBLE_EXT.contains(e)) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            if (ZipUtils.extractFirstPath(parserContext.getFullStream(), POSSIBLE_PATHS, buffer, true)) {
                NutsSession session = parserContext.getSession();
                return NutsDescriptorParser.of((NutsSession)session).parse(buffer.toByteArray());
            }
        }
        catch (IOException ex) {
            throw new NutsIOException(parserContext.getSession(), (Throwable)ex);
        }
        return null;
    }
}

