/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.parser;

import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsLogVerb;
import net.thevpc.nuts.NutsLoggerOp;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsDescriptorContentParserContext;
import net.thevpc.nuts.runtime.standalone.descriptor.util.NutsDescriptorUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.spi.NutsDescriptorContentParserComponent;
import net.thevpc.nuts.spi.NutsDescriptorContentParserContext;

public class NutsDescriptorContentResolver {
    public static NutsDescriptor resolveNutsDescriptorFromFileContent(Path localPath, String[] parseOptions, NutsSession session) {
        if (parseOptions == null) {
            parseOptions = new String[]{};
        }
        if (localPath != null) {
            String fileExtension = CoreIOUtils.getFileExtension(localPath.getFileName().toString());
            DefaultNutsDescriptorContentParserContext ctx = new DefaultNutsDescriptorContentParserContext(session, localPath, fileExtension, null, parseOptions);
            List allParsers = session.extensions().setSession(session).createAllSupported(NutsDescriptorContentParserComponent.class, (Object)ctx);
            if (allParsers.size() > 0) {
                for (NutsDescriptorContentParserComponent parser : allParsers) {
                    NutsDescriptor desc = null;
                    try {
                        desc = parser.parse((NutsDescriptorContentParserContext)ctx);
                    }
                    catch (Exception e) {
                        NutsLoggerOp.of(CoreIOUtils.class, (NutsSession)session).level(Level.FINE).verb(NutsLogVerb.WARNING).error((Throwable)e).log(NutsMessage.cstyle((String)"error parsing %s with %s", (Object[])new Object[]{localPath, parser.getClass().getSimpleName() + ". Error ignored"}));
                    }
                    if (desc == null) continue;
                    if (!desc.isBlank()) {
                        return desc;
                    }
                    return NutsDescriptorUtils.checkDescriptor(desc, session);
                }
            }
        }
        return null;
    }
}

