/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorBuilder;
import net.thevpc.nuts.NutsDescriptorFlag;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsDescriptorStyle;
import net.thevpc.nuts.NutsExecutionEntries;
import net.thevpc.nuts.NutsExecutionEntry;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsRef;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsArtifactCall;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamVisitor;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenUtils;
import net.thevpc.nuts.runtime.standalone.security.util.CoreDigestHelper;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.spi.NutsDescriptorContentParserComponent;
import net.thevpc.nuts.spi.NutsDescriptorContentParserContext;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class JarDescriptorContentParserComponent
implements NutsDescriptorContentParserComponent {
    public static final Set<String> POSSIBLE_EXT = new HashSet<String>(Collections.singletonList("jar"));
    private NutsSession ws;

    public int getSupportLevel(NutsSupportLevelContext criteria) {
        this.ws = criteria.getSession();
        NutsDescriptorContentParserContext cons = (NutsDescriptorContentParserContext)criteria.getConstraints(NutsDescriptorContentParserContext.class);
        if (cons != null) {
            String e;
            switch (e = NutsUtilStrings.trim((String)cons.getFileExtension())) {
                case "jar": 
                case "war": 
                case "ear": {
                    return 20;
                }
                case "zip": {
                    return 15;
                }
            }
        }
        return -1;
    }

    public NutsDescriptor parse(NutsDescriptorContentParserContext parserContext) {
        if (!POSSIBLE_EXT.contains(parserContext.getFileExtension())) {
            return null;
        }
        NutsId JAVA = NutsId.of((String)"java", (NutsSession)this.ws);
        final NutsRef nutsjson = new NutsRef();
        final NutsRef metainf = new NutsRef();
        final NutsRef maven = new NutsRef();
        final NutsSession session = parserContext.getSession();
        try {
            ZipUtils.visitZipStream(parserContext.getFullStream(), new Predicate<String>(){

                @Override
                public boolean test(String path) {
                    if ("META-INF/MANIFEST.MF".equals(path)) {
                        return true;
                    }
                    if ("META-INF/nuts.json".equals(path)) {
                        return true;
                    }
                    return path.startsWith("META-INF/maven/") && path.endsWith("/pom.xml");
                }
            }, new InputStreamVisitor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean visit(String path, InputStream inputStream) throws IOException {
                    switch (path) {
                        case "META-INF/MANIFEST.MF": {
                            try {
                                metainf.set((Object)NutsDescriptorParser.of((NutsSession)session).setDescriptorStyle(NutsDescriptorStyle.MANIFEST).setLenient(true).parse(inputStream));
                                break;
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        case "META-INF/nuts.json": {
                            try {
                                nutsjson.set((Object)NutsDescriptorParser.of((NutsSession)session).setDescriptorStyle(NutsDescriptorStyle.NUTS).parse(inputStream));
                                break;
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        default: {
                            try {
                                maven.set((Object)MavenUtils.of(session).parsePomXmlAndResolveParents(inputStream, NutsFetchMode.REMOTE, path, null));
                                break;
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                    }
                    return !nutsjson.isSet() || !metainf.isSet() && !maven.isSet();
                }
            });
        }
        catch (IOException ex) {
            throw new NutsIOException(this.ws, (Throwable)ex);
        }
        if (nutsjson.isSet()) {
            return (NutsDescriptor)nutsjson.get();
        }
        String mainClassString = null;
        if (metainf.isSet()) {
            String[] args = ((NutsDescriptor)metainf.get()).getExecutor().getArguments();
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("--main-class=")) {
                    mainClassString = NutsUtilStrings.trimToNull((String)arg.substring("--main-class=".length()));
                    break;
                }
                if (!arg.equals("--main-class") || ++i >= args.length) continue;
                mainClassString = NutsUtilStrings.trimToNull((String)args[i]);
            }
        }
        NutsDescriptor baseNutsDescriptor = null;
        if (maven.isSet()) {
            baseNutsDescriptor = (NutsDescriptor)maven.get();
            if (!NutsBlankable.isBlank(mainClassString)) {
                return baseNutsDescriptor.builder().setExecutor((NutsArtifactCall)new DefaultNutsArtifactCall(JAVA, new String[]{"--main-class", mainClassString})).build();
            }
        } else if (metainf.isSet()) {
            baseNutsDescriptor = (NutsDescriptor)metainf.get();
        }
        if (baseNutsDescriptor == null) {
            CoreDigestHelper d = new CoreDigestHelper(session);
            d.append(parserContext.getFullStream());
            String artifactId = d.getDigest();
            baseNutsDescriptor = NutsDescriptorBuilder.of((NutsSession)session).setId(NutsIdBuilder.of((NutsSession)session).setGroupId("temp").setArtifactId(artifactId).setVersion("1.0").build()).addFlag((NutsDescriptorFlag)(mainClassString != null ? NutsDescriptorFlag.EXEC : null)).setPackaging("jar").build();
        }
        boolean alwaysSelectAllMainClasses = false;
        NutsCommandLine cmd = NutsCommandLine.of((String[])parserContext.getParseOptions(), (NutsSession)session);
        while (!cmd.isEmpty()) {
            NutsArgument a = cmd.nextBoolean(new String[]{"--all-mains"});
            if (a != null) {
                alwaysSelectAllMainClasses = a.getBooleanValue();
                continue;
            }
            cmd.skip();
        }
        if (NutsBlankable.isBlank(mainClassString) || alwaysSelectAllMainClasses) {
            NutsExecutionEntry[] classes = NutsExecutionEntries.of((NutsSession)session).parse(parserContext.getFullStream(), "java", parserContext.getFullStream().toString());
            if (classes.length == 0) {
                return baseNutsDescriptor;
            }
            return baseNutsDescriptor.builder().setExecutor((NutsArtifactCall)new DefaultNutsArtifactCall(JAVA, new String[]{"--main-class=" + String.join((CharSequence)":", Arrays.stream(classes).map(x -> x.getName()).collect(Collectors.toList()))}, null)).addFlag(NutsDescriptorFlag.EXEC).build();
        }
        return baseNutsDescriptor;
    }
}

