/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyParser;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorBuilder;
import net.thevpc.nuts.NutsDescriptorFlag;
import net.thevpc.nuts.NutsDescriptorParser;
import net.thevpc.nuts.NutsDescriptorProperty;
import net.thevpc.nuts.NutsDescriptorStyle;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsFetchMode;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdParser;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsParseException;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedEnumException;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsArtifactCall;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsDescriptorPropertyBuilder;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenUtils;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NutsWorkspaceUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsDescriptorParser
implements NutsDescriptorParser {
    private final NutsWorkspace ws;
    private NutsSession session;
    private boolean lenient = true;
    private NutsDescriptorStyle descriptorStyle;
    private String format;

    public DefaultNutsDescriptorParser(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
    }

    public NutsDescriptor parse(URL url) {
        this.checkSession();
        return this.parse(NutsPath.of((URL)url, (NutsSession)this.getSession()));
    }

    public NutsDescriptor parse(byte[] bytes) {
        return this.parse(new ByteArrayInputStream(bytes), true);
    }

    public NutsDescriptor parse(Path path) {
        this.checkSession();
        return this.parse(NutsPath.of((Path)path, (NutsSession)this.getSession()));
    }

    public NutsDescriptor parse(File file) {
        this.checkSession();
        return this.parse(file.toPath());
    }

    public NutsDescriptor parse(InputStream stream) {
        this.checkSession();
        return this.parse(stream, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NutsDescriptor parse(NutsPath path) {
        this.checkSession();
        boolean startParsing = false;
        try {
            try (InputStream is = path.getInputStream();){
                startParsing = true;
                NutsDescriptor nutsDescriptor = this.parse(is, true);
                return nutsDescriptor;
            }
            catch (NutsException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new NutsParseException(this.getSession(), NutsMessage.cstyle((String)"unable to parse url %s", (Object[])new Object[]{path}), (Throwable)ex);
            }
        }
        catch (IOException ex) {
            if (!startParsing) {
                throw new NutsNotFoundException(this.getSession(), null, NutsMessage.cstyle((String)"at file %s", (Object[])new Object[]{path}), null);
            }
            throw new NutsParseException(this.getSession(), NutsMessage.cstyle((String)"unable to parse url %s", (Object[])new Object[]{path}), (Throwable)ex);
        }
    }

    public NutsDescriptor parse(String str) {
        this.checkSession();
        if (NutsBlankable.isBlank((String)str)) {
            return null;
        }
        return this.parse(new ByteArrayInputStream(str.getBytes()), true);
    }

    public NutsDescriptorStyle getDescriptorStyle() {
        return this.descriptorStyle;
    }

    public DefaultNutsDescriptorParser setDescriptorStyle(NutsDescriptorStyle descriptorStyle) {
        this.descriptorStyle = descriptorStyle;
        return this;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public NutsDescriptorParser setLenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public NutsSession getSession() {
        return this.session;
    }

    public NutsDescriptorParser setSession(NutsSession session) {
        this.session = NutsWorkspaceUtils.bindSession(this.ws, session);
        return this;
    }

    private void checkSession() {
        NutsWorkspaceUtils.checkSession(this.getWorkspace(), this.getSession());
    }

    private NutsDescriptor parse(InputStream in, boolean closeStream) {
        if (this.isLenient()) {
            try {
                return this.parseNonLenient(in, closeStream);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return this.parseNonLenient(in, closeStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NutsDescriptor parseNonLenient(InputStream in, boolean closeStream) {
        this.checkSession();
        NutsDescriptorStyle style = this.getDescriptorStyle();
        if (style == null) {
            style = NutsDescriptorStyle.NUTS;
        }
        switch (style) {
            case MAVEN: {
                try {
                    NutsDescriptor nutsDescriptor = MavenUtils.of(this.session).parsePomXml(in, NutsFetchMode.LOCAL, "descriptor", null);
                    return nutsDescriptor;
                }
                finally {
                    if (closeStream) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            throw new NutsIOException(this.getSession(), (Throwable)ex);
                        }
                    }
                }
            }
            case NUTS: {
                try {
                    InputStreamReader rr = new InputStreamReader(in);
                    NutsDescriptor ex = (NutsDescriptor)NutsElements.of((NutsSession)this.getSession()).setSession(this.session).json().parse((Reader)rr, NutsDescriptor.class);
                    return ex;
                }
                finally {
                    if (closeStream) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            throw new NutsIOException(this.getSession(), (Throwable)ex);
                        }
                    }
                }
            }
            case MANIFEST: {
                try {
                    Manifest manifest = new Manifest(in);
                    Attributes attrs = manifest.getMainAttributes();
                    String automaticModuleName = null;
                    String mainVersion = null;
                    String mainClass = null;
                    String implVendorId = null;
                    String implVendorTitle = null;
                    Set deps = new LinkedHashSet();
                    NutsId explicitId = null;
                    HashMap<String, String> all = new HashMap<String, String>();
                    for (Object o : attrs.keySet()) {
                        Attributes.Name attrName = (Attributes.Name)o;
                        if ("Main-Class".equals(attrName.toString())) {
                            mainClass = NutsUtilStrings.trimToNull((String)attrs.getValue(attrName));
                        }
                        if ("Automatic-Module-Name".equals(attrName.toString())) {
                            automaticModuleName = NutsUtilStrings.trimToNull((String)attrs.getValue(attrName));
                        }
                        if ("Implementation-Version".equals(attrName.toString())) {
                            mainVersion = NutsUtilStrings.trimToNull((String)attrs.getValue(attrName));
                        }
                        if ("Implementation-Vendor-Id".equals(attrName.toString())) {
                            implVendorId = NutsUtilStrings.trimToNull((String)attrs.getValue(attrName));
                        }
                        if ("Implementation-Vendor-Title".equals(attrName.toString())) {
                            implVendorTitle = NutsUtilStrings.trimToNull((String)attrs.getValue(attrName));
                        }
                        if ("Nuts-Id".equals(attrName.toString())) {
                            explicitId = NutsIdParser.of((NutsSession)this.getSession()).setLenient(true).parse(NutsUtilStrings.trimToNull((String)attrs.getValue(attrName)));
                        }
                        if ("Nuts-Dependencies".equals(attrName.toString())) {
                            String nutsDependencies = NutsUtilStrings.trimToNull((String)attrs.getValue(attrName));
                            deps = nutsDependencies == null ? Collections.emptySet() : (Set)Arrays.stream(nutsDependencies.split(";")).map(String::trim).filter(x -> x.length() > 0).map(arg_0 -> ((NutsDependencyParser)NutsDependencyParser.of((NutsSession)this.session).setLenient(true)).parse(arg_0)).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
                        }
                        all.put(attrName.toString(), NutsUtilStrings.trimToNull((String)attrs.getValue(attrName)));
                    }
                    if (explicitId == null) {
                        if (automaticModuleName == null && implVendorId == null) {
                            if (!NutsBlankable.isBlank(mainClass)) {
                                automaticModuleName = CorePlatformUtils.getPackageName(mainClass);
                            }
                        } else if (automaticModuleName == null && implVendorId != null) {
                            automaticModuleName = implVendorId;
                        }
                        if (automaticModuleName != null || mainVersion != null || !deps.isEmpty()) {
                            String groupId = automaticModuleName == null ? "" : CorePlatformUtils.getPackageName(automaticModuleName);
                            String artifactId = automaticModuleName == null ? "" : CorePlatformUtils.getSimpleClassName(automaticModuleName);
                            explicitId = NutsIdBuilder.of((NutsSession)this.session).setGroupId(groupId).setArtifactId(artifactId).setVersion(NutsBlankable.isBlank((String)mainVersion) ? "1.0" : mainVersion.trim()).build();
                        }
                    }
                    if (explicitId != null || !deps.isEmpty()) {
                        String[] stringArray;
                        String nutsName = NutsUtilStrings.trimToNull((String)((String)all.get("Nuts-Name")));
                        if (nutsName == null) {
                            nutsName = implVendorTitle;
                        }
                        NutsDescriptorBuilder nutsDescriptorBuilder = NutsDescriptorBuilder.of((NutsSession)this.getSession()).setId(explicitId).setName(nutsName).addFlag((NutsDescriptorFlag)(NutsBlankable.isBlank((String)mainClass) ? NutsDescriptorFlag.EXEC : null)).addFlags((NutsDescriptorFlag[])Arrays.stream(NutsUtilStrings.trim((String)((String)all.get("Nuts-Flags"))).split("; ,")).map(NutsDescriptorFlag::parseLenient).filter(Objects::nonNull).toArray(NutsDescriptorFlag[]::new)).setPackaging(CoreStringUtils.coalesce(NutsUtilStrings.trimToNull((String)((String)all.get("Nuts-Packaging"))), "jar")).setCategories(Arrays.stream(NutsUtilStrings.trim((String)((String)all.get("Nuts-Categories"))).split("; ,")).map(NutsUtilStrings::trimToNull).filter(Objects::nonNull).collect(Collectors.toList())).setIcons(Arrays.stream(NutsUtilStrings.trim((String)((String)all.get("Nuts-Icons"))).split("; ,")).map(NutsUtilStrings::trimToNull).filter(Objects::nonNull).collect(Collectors.toList())).setName(nutsName).setDescription(NutsUtilStrings.trimToNull((String)((String)all.get("Nuts-Description")))).setGenericName(NutsUtilStrings.trimToNull((String)((String)all.get("Nuts-Generic-Name")))).setProperties((NutsDescriptorProperty[])all.entrySet().stream().filter(x -> ((String)x.getKey()).startsWith("Nuts-Property-")).map(x -> new DefaultNutsDescriptorPropertyBuilder(this.getSession()).setName(((String)x.getKey()).substring("Nuts-Property-".length())).setValue((String)x.getValue()).build()).toArray(NutsDescriptorProperty[]::new));
                        NutsId nutsId = NutsId.of((String)"java", (NutsSession)this.getSession());
                        if (NutsBlankable.isBlank((String)mainClass)) {
                            stringArray = new String[]{};
                        } else {
                            String[] stringArray2 = new String[2];
                            stringArray2[0] = "--main-class=";
                            stringArray = stringArray2;
                            stringArray2[1] = mainClass;
                        }
                        NutsDescriptor nutsDescriptor = nutsDescriptorBuilder.setExecutor((NutsArtifactCall)new DefaultNutsArtifactCall(nutsId, stringArray)).setDependencies(deps.toArray(new NutsDependency[0])).build();
                        return nutsDescriptor;
                    }
                    try {
                        throw new NutsParseException(this.getSession(), NutsMessage.cstyle((String)"unable to parse Descriptor for Manifest from %s", (Object[])new Object[]{in}));
                    }
                    catch (IOException ex) {
                        throw new NutsIOException(this.getSession(), (Throwable)ex);
                    }
                }
                finally {
                    if (closeStream) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {
                            throw new NutsIOException(this.getSession(), (Throwable)ex);
                        }
                    }
                }
            }
        }
        throw new NutsUnsupportedEnumException(this.getSession(), (Enum)style);
    }

    public NutsWorkspace getWorkspace() {
        return this.ws;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

