/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.filter;

import java.util.Objects;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.AbstractDescriptorFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

public class NutsDescriptorFilterPlatform
extends AbstractDescriptorFilter {
    private final String platform;

    public NutsDescriptorFilterPlatform(NutsSession session, String packaging) {
        super(session, NutsFilterOp.CUSTOM);
        this.platform = packaging;
    }

    public String getPlatform() {
        return this.platform;
    }

    public boolean acceptDescriptor(NutsDescriptor descriptor, NutsSession session) {
        return CoreFilterUtils.matchesPlatform(this.platform, descriptor.getCondition().getPlatform(), session);
    }

    @Override
    public NutsDescriptorFilter simplify() {
        if (NutsBlankable.isBlank((String)this.platform)) {
            return null;
        }
        return this;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.platform);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDescriptorFilterPlatform other = (NutsDescriptorFilterPlatform)obj;
        return Objects.equals(this.platform, other.platform);
    }

    public String toString() {
        return "Platform{" + this.platform + '}';
    }
}

