/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.filter;

import java.util.Objects;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.AbstractDescriptorFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

public class NutsDescriptorFilterPackaging
extends AbstractDescriptorFilter {
    private final String packaging;

    public NutsDescriptorFilterPackaging(NutsSession session, String packaging) {
        super(session, NutsFilterOp.CUSTOM);
        this.packaging = packaging;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public boolean acceptDescriptor(NutsDescriptor descriptor, NutsSession session) {
        return CoreFilterUtils.matchesPackaging(this.packaging, descriptor, session);
    }

    @Override
    public NutsDescriptorFilter simplify() {
        if (NutsBlankable.isBlank((String)this.packaging)) {
            return null;
        }
        return this;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.packaging);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDescriptorFilterPackaging other = (NutsDescriptorFilterPackaging)obj;
        return Objects.equals(this.packaging, other.packaging);
    }

    public String toString() {
        return "Packaging{" + this.packaging + '}';
    }
}

