/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.filter;

import java.util.Objects;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.AbstractDescriptorFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

public class NutsDescriptorFilterOsDist
extends AbstractDescriptorFilter {
    private final String osDist;

    public NutsDescriptorFilterOsDist(NutsSession session, String osDist) {
        super(session, NutsFilterOp.CUSTOM);
        this.osDist = osDist;
    }

    public String getOsDist() {
        return this.osDist;
    }

    public boolean acceptDescriptor(NutsDescriptor descriptor, NutsSession session) {
        return CoreFilterUtils.matchesOsDist(this.osDist, descriptor.getCondition().getOsDist(), session);
    }

    @Override
    public NutsDescriptorFilter simplify() {
        if (NutsBlankable.isBlank((String)this.osDist)) {
            return null;
        }
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.osDist);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDescriptorFilterOsDist other = (NutsDescriptorFilterOsDist)obj;
        return Objects.equals(this.osDist, other.osDist);
    }

    public String toString() {
        return "Osdist{" + this.osDist + '}';
    }
}

