/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.filter;

import java.util.Objects;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.AbstractDescriptorFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

public class NutsDescriptorFilterOs
extends AbstractDescriptorFilter {
    private final String os;

    public NutsDescriptorFilterOs(NutsSession session, String os) {
        super(session, NutsFilterOp.CUSTOM);
        this.os = os;
    }

    public String getOs() {
        return this.os;
    }

    public boolean acceptDescriptor(NutsDescriptor descriptor, NutsSession session) {
        return CoreFilterUtils.matchesOs(this.os, descriptor.getCondition().getOs(), session);
    }

    @Override
    public NutsDescriptorFilter simplify() {
        if (NutsBlankable.isBlank((String)this.os)) {
            return null;
        }
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.os);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDescriptorFilterOs other = (NutsDescriptorFilterOs)obj;
        return Objects.equals(this.os, other.os);
    }

    public String toString() {
        return "Os{" + this.os + '}';
    }
}

