/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.filter;

import java.util.Objects;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.AbstractDescriptorFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

public class NutsDescriptorFilterDesktopEnvironment
extends AbstractDescriptorFilter {
    private final String desktopEnvironment;

    public NutsDescriptorFilterDesktopEnvironment(NutsSession session, String desktopEnvironment) {
        super(session, NutsFilterOp.CUSTOM);
        this.desktopEnvironment = desktopEnvironment;
    }

    public String getDesktopEnvironment() {
        return this.desktopEnvironment;
    }

    public boolean acceptDescriptor(NutsDescriptor descriptor, NutsSession session) {
        return CoreFilterUtils.matchesDesktopEnvironment(this.desktopEnvironment, descriptor.getCondition().getDesktopEnvironment(), session);
    }

    @Override
    public NutsDescriptorFilter simplify() {
        if (NutsBlankable.isBlank((String)this.desktopEnvironment)) {
            return null;
        }
        return this;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.desktopEnvironment);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDescriptorFilterDesktopEnvironment other = (NutsDescriptorFilterDesktopEnvironment)obj;
        return Objects.equals(this.desktopEnvironment, other.desktopEnvironment);
    }

    public String toString() {
        return "Platform{" + this.desktopEnvironment + '}';
    }
}

