/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.filter;

import java.util.Objects;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.AbstractDescriptorFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

public class NutsDescriptorFilterArch
extends AbstractDescriptorFilter {
    private final String arch;

    public NutsDescriptorFilterArch(NutsSession session, String packaging) {
        super(session, NutsFilterOp.CUSTOM);
        this.arch = packaging;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean acceptDescriptor(NutsDescriptor descriptor, NutsSession session) {
        return CoreFilterUtils.matchesArch(this.arch, descriptor.getCondition().getArch(), session);
    }

    @Override
    public NutsDescriptorFilter simplify() {
        if (NutsBlankable.isBlank((String)this.arch)) {
            return null;
        }
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.arch);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDescriptorFilterArch other = (NutsDescriptorFilterArch)obj;
        return Objects.equals(this.arch, other.arch);
    }

    public String toString() {
        return "Arch{" + this.arch + '}';
    }
}

