/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.AbstractDescriptorFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

public class NutsDescriptorFilterAnd
extends AbstractDescriptorFilter {
    private NutsDescriptorFilter[] all;

    public NutsDescriptorFilterAnd(NutsSession session, NutsDescriptorFilter ... all) {
        super(session, NutsFilterOp.AND);
        ArrayList<NutsDescriptorFilter> valid = new ArrayList<NutsDescriptorFilter>();
        if (all != null) {
            for (NutsDescriptorFilter filter : all) {
                if (filter == null) continue;
                valid.add(filter);
            }
        }
        this.all = valid.toArray(new NutsDescriptorFilter[0]);
    }

    public boolean acceptDescriptor(NutsDescriptor id, NutsSession session) {
        if (this.all.length == 0) {
            return true;
        }
        for (NutsDescriptorFilter filter : this.all) {
            if (filter.acceptDescriptor(id, session)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NutsDescriptorFilter simplify() {
        return CoreFilterUtils.simplifyFilterAnd(this.getSession(), NutsDescriptorFilter.class, this, (NutsFilter[])this.all);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Arrays.deepHashCode(this.all);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsDescriptorFilterAnd other = (NutsDescriptorFilterAnd)obj;
        return Arrays.deepEquals(this.all, other.all);
    }

    public String toString() {
        return String.join((CharSequence)" and ", Arrays.asList(this.all).stream().map(x -> "(" + x.toString() + ")").collect(Collectors.toList()));
    }

    @Override
    public NutsFilter[] getSubFilters() {
        return this.all;
    }
}

