/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.NutsDescriptorFilter;
import net.thevpc.nuts.NutsDescriptorFilters;
import net.thevpc.nuts.NutsDescriptorFlag;
import net.thevpc.nuts.NutsFilter;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdFilter;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsVersion;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.NutsDescriptorFilterAnd;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.NutsDescriptorFilterArch;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.NutsDescriptorFilterById;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.NutsDescriptorFilterDesktopEnvironment;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.NutsDescriptorFilterFalse;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.NutsDescriptorFilterNone;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.NutsDescriptorFilterOr;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.NutsDescriptorFilterOs;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.NutsDescriptorFilterOsDist;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.NutsDescriptorFilterPackaging;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.NutsDescriptorFilterParser;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.NutsDescriptorFilterPlatform;
import net.thevpc.nuts.runtime.standalone.descriptor.filter.NutsDescriptorFilterTrue;
import net.thevpc.nuts.runtime.standalone.id.filter.BootAPINutsDescriptorFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsDescriptorFlagsIdFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsExecCompanionFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsExecExtensionFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsExecRuntimeFilter;
import net.thevpc.nuts.runtime.standalone.id.filter.NutsLockedIdExtensionFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.InternalNutsTypedFilters;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class InternalNutsDescriptorFilters
extends InternalNutsTypedFilters<NutsDescriptorFilter>
implements NutsDescriptorFilters {
    public InternalNutsDescriptorFilters(NutsSession session) {
        super(session, NutsDescriptorFilter.class);
    }

    public NutsDescriptorFilter always() {
        this.checkSession();
        return new NutsDescriptorFilterTrue(this.getSession());
    }

    public NutsDescriptorFilter never() {
        this.checkSession();
        return new NutsDescriptorFilterFalse(this.getSession());
    }

    public NutsDescriptorFilter not(NutsFilter other) {
        this.checkSession();
        return new NutsDescriptorFilterNone(this.getSession(), (NutsDescriptorFilter)other);
    }

    public NutsDescriptorFilter byPackaging(String ... values) {
        this.checkSession();
        if (values == null || values.length == 0) {
            return this.always();
        }
        ArrayList<NutsDescriptorFilterPackaging> packs = new ArrayList<NutsDescriptorFilterPackaging>();
        for (String v : values) {
            packs.add(new NutsDescriptorFilterPackaging(this.getSession(), v));
        }
        if (packs.size() == 1) {
            return (NutsDescriptorFilter)packs.get(0);
        }
        return this.all((NutsFilter[])packs.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter byArch(String ... values) {
        this.checkSession();
        if (values == null || values.length == 0) {
            return this.always();
        }
        ArrayList<NutsDescriptorFilterArch> packs = new ArrayList<NutsDescriptorFilterArch>();
        for (String v : values) {
            packs.add(new NutsDescriptorFilterArch(this.getSession(), v));
        }
        if (packs.size() == 1) {
            return (NutsDescriptorFilter)packs.get(0);
        }
        return this.all((NutsFilter[])packs.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter byOsDist(String ... values) {
        this.checkSession();
        if (values == null || values.length == 0) {
            return this.always();
        }
        ArrayList<NutsDescriptorFilterOsDist> packs = new ArrayList<NutsDescriptorFilterOsDist>();
        for (String v : values) {
            packs.add(new NutsDescriptorFilterOsDist(this.getSession(), v));
        }
        if (packs.size() == 1) {
            return (NutsDescriptorFilter)packs.get(0);
        }
        return this.all((NutsFilter[])packs.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter byOs(String ... values) {
        this.checkSession();
        if (values == null || values.length == 0) {
            return this.always();
        }
        ArrayList<NutsDescriptorFilterOs> packs = new ArrayList<NutsDescriptorFilterOs>();
        for (String v : values) {
            packs.add(new NutsDescriptorFilterOs(this.getSession(), v));
        }
        if (packs.size() == 1) {
            return (NutsDescriptorFilter)packs.get(0);
        }
        return this.all((NutsFilter[])packs.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter byPlatform(String ... values) {
        this.checkSession();
        if (values == null || values.length == 0) {
            return this.always();
        }
        ArrayList<NutsDescriptorFilterPlatform> packs = new ArrayList<NutsDescriptorFilterPlatform>();
        for (String v : values) {
            packs.add(new NutsDescriptorFilterPlatform(this.getSession(), v));
        }
        if (packs.size() == 1) {
            return (NutsDescriptorFilter)packs.get(0);
        }
        return this.all((NutsFilter[])packs.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter byDesktopEnvironment(String ... values) {
        this.checkSession();
        if (values == null || values.length == 0) {
            return this.always();
        }
        ArrayList<NutsDescriptorFilterDesktopEnvironment> packs = new ArrayList<NutsDescriptorFilterDesktopEnvironment>();
        for (String v : values) {
            packs.add(new NutsDescriptorFilterDesktopEnvironment(this.getSession(), v));
        }
        if (packs.size() == 1) {
            return (NutsDescriptorFilter)packs.get(0);
        }
        return this.all((NutsFilter[])packs.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter byFlag(NutsDescriptorFlag ... flags) {
        return new NutsDescriptorFlagsIdFilter(this.getSession(), flags);
    }

    public NutsDescriptorFilter byExtension(NutsVersion targetApiVersion) {
        this.checkSession();
        return new NutsExecExtensionFilter(this.getSession(), targetApiVersion == null ? null : NutsId.of((String)"net.thevpc.nuts:nuts", (NutsSession)this.getSession()).builder().setVersion(targetApiVersion).build());
    }

    public NutsDescriptorFilter byRuntime(NutsVersion targetApiVersion) {
        this.checkSession();
        return new NutsExecRuntimeFilter(this.getSession(), targetApiVersion == null ? null : NutsId.of((String)"net.thevpc.nuts:nuts", (NutsSession)this.getSession()).builder().setVersion(targetApiVersion).build(), false);
    }

    public NutsDescriptorFilter byCompanion(NutsVersion targetApiVersion) {
        this.checkSession();
        return new NutsExecCompanionFilter(this.getSession(), targetApiVersion == null ? null : NutsId.of((String)"net.thevpc.nuts:nuts", (NutsSession)this.getSession()).builder().setVersion(targetApiVersion).build(), (String[])this.getSession().extensions().getCompanionIds().stream().map(NutsId::getShortName).toArray(String[]::new));
    }

    public NutsDescriptorFilter byApiVersion(NutsVersion apiVersion) {
        this.checkSession();
        if (apiVersion == null) {
            apiVersion = this.getSession().getWorkspace().getApiVersion();
        }
        return new BootAPINutsDescriptorFilter(this.getSession(), NutsId.of((String)"net.thevpc.nuts:nuts", (NutsSession)this.getSession()).builder().setVersion(apiVersion).build().getVersion());
    }

    public NutsDescriptorFilter byLockedIds(String ... ids) {
        this.checkSession();
        return new NutsLockedIdExtensionFilter(this.getSession(), (NutsId[])Arrays.stream(ids).map(x -> NutsId.of((String)x, (NutsSession)this.getSession())).toArray(NutsId[]::new));
    }

    public NutsDescriptorFilter as(NutsFilter a) {
        this.checkSession();
        if (a instanceof NutsDescriptorFilter) {
            return (NutsDescriptorFilter)a;
        }
        if (a instanceof NutsIdFilter) {
            return new NutsDescriptorFilterById((NutsIdFilter)a, this.getSession());
        }
        return null;
    }

    public NutsDescriptorFilter from(NutsFilter a) {
        this.checkSession();
        if (a == null) {
            return null;
        }
        NutsDescriptorFilter t = this.as(a);
        if (t == null) {
            throw new NutsIllegalArgumentException(this.getSession(), NutsMessage.cstyle((String)"not a DescriptorFilter", (Object[])new Object[0]));
        }
        return t;
    }

    public NutsDescriptorFilter all(NutsFilter ... others) {
        this.checkSession();
        List<NutsDescriptorFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsDescriptorFilter)all.get(0);
        }
        return new NutsDescriptorFilterAnd(this.getSession(), all.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter any(NutsFilter ... others) {
        this.checkSession();
        List<NutsDescriptorFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NutsDescriptorFilter)all.get(0);
        }
        return new NutsDescriptorFilterOr(this.getSession(), all.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter none(NutsFilter ... others) {
        this.checkSession();
        List<NutsDescriptorFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        return new NutsDescriptorFilterNone(this.getSession(), all.toArray(new NutsDescriptorFilter[0]));
    }

    public NutsDescriptorFilter parse(String expression) {
        this.checkSession();
        return (NutsDescriptorFilter)new NutsDescriptorFilterParser(expression, this.getSession()).parse();
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

