/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.NutsEnvCondition;
import net.thevpc.nuts.NutsEnvConditionBuilder;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsEnvCondition;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.util.MapToFunction;
import net.thevpc.nuts.runtime.standalone.util.collections.CoreArrayUtils;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsEnvConditionBuilder
implements NutsEnvConditionBuilder {
    private static final long serialVersionUID = 1L;
    private List<String> arch = new ArrayList<String>();
    private List<String> os = new ArrayList<String>();
    private List<String> osDist = new ArrayList<String>();
    private List<String> platform = new ArrayList<String>();
    private List<String> desktopEnvironment = new ArrayList<String>();
    private List<String> profiles = new ArrayList<String>();
    private transient NutsSession session;

    public DefaultNutsEnvConditionBuilder() {
    }

    public DefaultNutsEnvConditionBuilder(NutsSession session) {
        this.session = session;
    }

    public DefaultNutsEnvConditionBuilder(NutsEnvCondition other, NutsSession session) {
        this.session = session;
        this.setAll(other);
    }

    public NutsEnvConditionBuilder addDesktopEnvironment(String desktopEnvironment) {
        if (desktopEnvironment != null) {
            if (this.desktopEnvironment == null) {
                this.desktopEnvironment = new ArrayList<String>();
            }
            this.desktopEnvironment.add(desktopEnvironment);
        }
        return this;
    }

    public String[] getArch() {
        return CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.arch.toArray(new String[0]), new String[0][]);
    }

    public NutsEnvConditionBuilder setArch(String[] arch) {
        this.arch = new ArrayList<String>(Arrays.asList(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(arch, new String[0][])));
        return this;
    }

    public String[] getOs() {
        return CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.os.toArray(new String[0]), new String[0][]);
    }

    public NutsEnvConditionBuilder setOs(String[] os) {
        this.os = new ArrayList<String>(Arrays.asList(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(os, new String[0][])));
        return this;
    }

    public String[] getOsDist() {
        return CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.osDist.toArray(new String[0]), new String[0][]);
    }

    public NutsEnvConditionBuilder setOsDist(String[] osDist) {
        this.osDist = new ArrayList<String>(Arrays.asList(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(osDist, new String[0][])));
        return this;
    }

    public String[] getPlatform() {
        return CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.platform.toArray(new String[0]), new String[0][]);
    }

    public NutsEnvConditionBuilder setPlatform(String[] platform) {
        this.platform = new ArrayList<String>(Arrays.asList(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(platform, new String[0][])));
        return this;
    }

    public String[] getDesktopEnvironment() {
        return CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.desktopEnvironment.toArray(new String[0]), new String[0][]);
    }

    public NutsEnvConditionBuilder setDesktopEnvironment(String[] desktopEnvironment) {
        this.desktopEnvironment = new ArrayList<String>(Arrays.asList(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(desktopEnvironment, new String[0][])));
        return this;
    }

    public String[] getProfile() {
        return CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.profiles.toArray(new String[0]), new String[0][]);
    }

    public NutsEnvConditionBuilder setProfile(String[] profiles) {
        this.profiles = new ArrayList<String>(Arrays.asList(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(profiles, new String[0][])));
        return this;
    }

    public NutsEnvConditionBuilder addProfile(String profile) {
        if (this.profiles == null) {
            this.profiles = new ArrayList<String>();
        }
        this.profiles.add(profile);
        return this;
    }

    public NutsEnvConditionBuilder addOs(String os) {
        if (this.os == null) {
            this.os = new ArrayList<String>();
        }
        this.os.add(os);
        return this;
    }

    public NutsEnvConditionBuilder addOsDist(String osDist) {
        if (this.osDist == null) {
            this.osDist = new ArrayList<String>();
        }
        this.osDist.add(osDist);
        return this;
    }

    public NutsEnvConditionBuilder addArch(String arch) {
        if (this.arch == null) {
            this.arch = new ArrayList<String>();
        }
        this.arch.add(arch);
        return this;
    }

    public NutsEnvConditionBuilder addPlatform(String platform) {
        if (platform != null) {
            if (this.platform == null) {
                this.platform = new ArrayList<String>();
            }
            this.platform.add(platform);
        }
        return this;
    }

    public NutsEnvConditionBuilder removeOs(String os) {
        if (this.os != null) {
            this.os.remove(os);
        }
        return this;
    }

    public NutsEnvConditionBuilder removeOsDist(String osDist) {
        if (this.osDist != null) {
            this.osDist.remove(osDist);
        }
        return this;
    }

    public NutsEnvConditionBuilder removeArch(String arch) {
        if (this.arch != null) {
            this.arch.remove(arch);
        }
        return this;
    }

    public NutsEnvConditionBuilder removePlatform(String platform) {
        if (this.platform != null) {
            this.platform.remove(platform);
        }
        return this;
    }

    public NutsEnvConditionBuilder setAll(NutsEnvConditionBuilder other) {
        if (other != null) {
            this.setArch(other.getArch());
            this.setOs(other.getOs());
            this.setOsDist(other.getOsDist());
            this.setPlatform(other.getPlatform());
            this.setDesktopEnvironment(other.getDesktopEnvironment());
            this.setProfile(other.getProfile());
        } else {
            this.clear();
        }
        return this;
    }

    public NutsEnvConditionBuilder setAll(NutsEnvCondition other) {
        if (other != null) {
            this.setArch(other.getArch());
            this.setOs(other.getOs());
            this.setOsDist(other.getOsDist());
            this.setPlatform(other.getPlatform());
            this.setDesktopEnvironment(other.getDesktopEnvironment());
            this.setProfile(other.getProfile());
        } else {
            this.clear();
        }
        return this;
    }

    public NutsEnvConditionBuilder addAll(NutsEnvCondition other) {
        if (other != null) {
            this.setArch(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.getArch(), new String[][]{other.getArch()}));
            this.setOs(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.getOs(), new String[][]{other.getOs()}));
            this.setOsDist(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.getOsDist(), new String[][]{other.getOsDist()}));
            this.setPlatform(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.getPlatform(), new String[][]{other.getPlatform()}));
            this.setDesktopEnvironment(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.getDesktopEnvironment(), new String[][]{other.getDesktopEnvironment()}));
            this.setProfile(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.getProfile(), new String[][]{other.getProfile()}));
        }
        return this;
    }

    public NutsEnvConditionBuilder addAll(NutsEnvConditionBuilder other) {
        if (other != null) {
            this.setArch(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.getArch(), new String[][]{other.getArch()}));
            this.setOs(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.getOs(), new String[][]{other.getOs()}));
            this.setOsDist(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.getOsDist(), new String[][]{other.getOsDist()}));
            this.setPlatform(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.getPlatform(), new String[][]{other.getPlatform()}));
            this.setDesktopEnvironment(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.getDesktopEnvironment(), new String[][]{other.getDesktopEnvironment()}));
            this.setProfile(CoreArrayUtils.toDistinctTrimmedNonEmptyArray(this.getProfile(), new String[][]{other.getProfile()}));
        }
        return this;
    }

    public NutsEnvConditionBuilder clear() {
        this.setArch(null);
        this.setOs(null);
        this.setOsDist(null);
        this.setPlatform(null);
        this.setDesktopEnvironment(null);
        this.setProfile(null);
        return this;
    }

    public NutsEnvConditionBuilder removeDesktopEnvironment(String desktopEnvironment) {
        if (this.desktopEnvironment != null) {
            this.desktopEnvironment.remove(desktopEnvironment);
        }
        return this;
    }

    public NutsEnvCondition build() {
        return new DefaultNutsEnvCondition(this.getArch(), this.getOs(), this.getOsDist(), this.getPlatform(), this.getDesktopEnvironment(), this.getProfile(), this.session);
    }

    public NutsEnvConditionBuilder copy() {
        return new DefaultNutsEnvConditionBuilder(this.session).setAll(this);
    }

    public NutsEnvConditionBuilder applyProperties(Map<String, String> properties) {
        MapToFunction<String, String> map = new MapToFunction<String, String>(properties);
        this.setArch(CoreNutsUtils.applyStringProperties(this.getArch(), map));
        this.setOs(CoreNutsUtils.applyStringProperties(this.getOs(), map));
        this.setOsDist(CoreNutsUtils.applyStringProperties(this.getOsDist(), map));
        this.setPlatform(CoreNutsUtils.applyStringProperties(this.getPlatform(), map));
        this.setDesktopEnvironment(CoreNutsUtils.applyStringProperties(this.getDesktopEnvironment(), map));
        this.setProfile(CoreNutsUtils.applyStringProperties(this.getProfile(), map));
        return this;
    }

    public String toString() {
        String s = String.join((CharSequence)" & ", (CharSequence[])Arrays.stream(new String[]{this.ts("arch", this.arch.toArray(new String[0])), this.ts("os", this.os.toArray(new String[0])), this.ts("osDist", this.osDist.toArray(new String[0])), this.ts("platform", this.platform.toArray(new String[0])), this.ts("desktopEnvironment", this.desktopEnvironment.toArray(new String[0])), this.ts("profiles", this.profiles.toArray(new String[0]))}).filter(x -> x.length() > 0).toArray(String[]::new));
        if (s.isEmpty()) {
            return "blank";
        }
        return s;
    }

    private String ts(String n, String[] vs) {
        if (vs.length == 0) {
            return "";
        }
        return n + "=" + String.join((CharSequence)",", vs[0]);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

