/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor;

import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsEnvCondition;
import net.thevpc.nuts.NutsEnvConditionBuilder;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.util.collections.CoreArrayUtils;

public class DefaultNutsEnvCondition
implements NutsEnvCondition {
    private static final long serialVersionUID = 1L;
    protected transient NutsSession session;
    private String[] arch;
    private String[] profiles;
    private String[] os;
    private String[] osDist;
    private String[] platform;
    private String[] desktopEnvironment;

    public NutsEnvConditionBuilder builder() {
        return NutsEnvConditionBuilder.of((NutsSession)this.session).setAll((NutsEnvCondition)this);
    }

    public DefaultNutsEnvCondition(NutsEnvCondition d, NutsSession session) {
        this(d.getArch(), d.getOs(), d.getOsDist(), d.getPlatform(), d.getDesktopEnvironment(), d.getProfile(), session);
    }

    public DefaultNutsEnvCondition(NutsSession session) {
        this(null, null, null, null, null, null, session);
    }

    public DefaultNutsEnvCondition(String[] arch, String[] os, String[] osDist, String[] platform, String[] desktopEnvironment, String[] profiles, NutsSession session) {
        this.session = session;
        this.arch = CoreArrayUtils.toDistinctTrimmedNonEmptyArray(arch, new String[0][]);
        this.os = CoreArrayUtils.toDistinctTrimmedNonEmptyArray(os, new String[0][]);
        this.osDist = CoreArrayUtils.toDistinctTrimmedNonEmptyArray(osDist, new String[0][]);
        this.platform = CoreArrayUtils.toDistinctTrimmedNonEmptyArray(platform, new String[0][]);
        this.desktopEnvironment = CoreArrayUtils.toDistinctTrimmedNonEmptyArray(desktopEnvironment, new String[0][]);
        this.profiles = CoreArrayUtils.toDistinctTrimmedNonEmptyArray(profiles, new String[0][]);
    }

    public boolean isBlank() {
        for (String s : this.arch) {
            if (NutsBlankable.isBlank((String)s)) continue;
            return false;
        }
        for (String s : this.os) {
            if (NutsBlankable.isBlank((String)s)) continue;
            return false;
        }
        for (String s : this.osDist) {
            if (NutsBlankable.isBlank((String)s)) continue;
            return false;
        }
        for (String s : this.platform) {
            if (NutsBlankable.isBlank((String)s)) continue;
            return false;
        }
        for (String s : this.desktopEnvironment) {
            if (NutsBlankable.isBlank((String)s)) continue;
            return false;
        }
        for (String s : this.profiles) {
            if (NutsBlankable.isBlank((String)s)) continue;
            return false;
        }
        return true;
    }

    public String[] getProfile() {
        return this.profiles;
    }

    public String[] getArch() {
        return this.arch;
    }

    public String[] getOs() {
        return this.os;
    }

    public String[] getOsDist() {
        return this.osDist;
    }

    public String[] getPlatform() {
        return this.platform;
    }

    public String[] getDesktopEnvironment() {
        return this.desktopEnvironment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsEnvCondition that = (DefaultNutsEnvCondition)o;
        return Objects.equals(this.session, that.session) && Arrays.equals(this.arch, that.arch) && Arrays.equals(this.os, that.os) && Arrays.equals(this.osDist, that.osDist) && Arrays.equals(this.platform, that.platform) && Arrays.equals(this.desktopEnvironment, that.desktopEnvironment);
    }

    public int hashCode() {
        int result = Objects.hash(this.session);
        result = 31 * result + Arrays.hashCode(this.arch);
        result = 31 * result + Arrays.hashCode(this.os);
        result = 31 * result + Arrays.hashCode(this.osDist);
        result = 31 * result + Arrays.hashCode(this.platform);
        result = 31 * result + Arrays.hashCode(this.desktopEnvironment);
        return result;
    }

    public String toString() {
        String s = String.join((CharSequence)" & ", (CharSequence[])Arrays.stream(new String[]{this.ts("arch", this.arch), this.ts("os", this.os), this.ts("osDist", this.osDist), this.ts("platform", this.platform), this.ts("desktopEnvironment", this.desktopEnvironment)}).filter(x -> x.length() > 0).toArray(String[]::new));
        if (s.isEmpty()) {
            return "blank";
        }
        return s;
    }

    private String ts(String n, String[] vs) {
        if (vs.length == 0) {
            return "";
        }
        return n + "=" + String.join((CharSequence)",", vs[0]);
    }
}

