/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor;

import java.util.Objects;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDescriptorProperty;
import net.thevpc.nuts.NutsDescriptorPropertyBuilder;
import net.thevpc.nuts.NutsEnvCondition;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsDescriptorPropertyBuilder;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

class DefaultNutsDescriptorProperty
implements NutsDescriptorProperty {
    private final String name;
    private final String value;
    private final NutsEnvCondition condition;
    private final transient NutsSession session;

    public DefaultNutsDescriptorProperty(String name, String value, NutsEnvCondition condition, NutsSession session) {
        this.name = name;
        this.value = value;
        this.condition = CoreFilterUtils.trimToBlank(condition, session);
        this.session = session;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public NutsEnvCondition getCondition() {
        return this.condition;
    }

    public NutsDescriptorPropertyBuilder builder() {
        return new DefaultNutsDescriptorPropertyBuilder(this.session).setName(this.getName()).setValue(this.getValue()).setCondition(this.getCondition());
    }

    public boolean isBlank() {
        if (!NutsBlankable.isBlank((String)this.name)) {
            return false;
        }
        if (!NutsBlankable.isBlank((String)this.value)) {
            return false;
        }
        return NutsBlankable.isBlank((NutsBlankable)this.condition);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.condition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsDescriptorProperty that = (DefaultNutsDescriptorProperty)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.condition, that.condition) && Objects.equals(this.session, that.session);
    }

    public String toString() {
        return this.name + "='" + this.value + '\'' + (this.condition.isBlank() ? "" : " when " + this.condition);
    }
}

