/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.spi.NutsDescriptorContentParserContext;

public class DefaultNutsDescriptorContentParserContext
implements NutsDescriptorContentParserContext {
    private final NutsSession session;
    private final NutsPath file;
    private final String fileExtension;
    private final String mimeType;
    private byte[] bytes;
    private final String[] parseOptions;

    public DefaultNutsDescriptorContentParserContext(NutsSession session, Path file, String fileExtension, String mimeType, String[] parseOptions) {
        this.file = NutsPath.of((Path)file, (NutsSession)session);
        this.session = session;
        this.fileExtension = fileExtension;
        this.mimeType = mimeType;
        this.parseOptions = parseOptions;
    }

    public NutsWorkspace getWorkspace() {
        return this.getSession().getWorkspace();
    }

    public NutsSession getSession() {
        return this.session;
    }

    public String[] getParseOptions() {
        return this.parseOptions;
    }

    public InputStream getHeadStream() {
        if (this.bytes == null) {
            try (InputStream is = this.file.getInputStream();){
                this.bytes = CoreIOUtils.loadByteArray(is, 0xA00000, true, this.session);
            }
            catch (IOException e) {
                throw new NutsIOException(this.session, (Throwable)e);
            }
        }
        return CoreIOUtils.createBytesStream(this.bytes, NutsMessage.cstyle((String)"%s", (Object[])new Object[]{this.file}), this.file.getContentType(), this.file.getUserKind(), this.session);
    }

    public InputStream getFullStream() {
        return this.file.getInputStream();
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getName() {
        return this.file.getName();
    }
}

