/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyBuilder;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorBuilder;
import net.thevpc.nuts.NutsDescriptorFlag;
import net.thevpc.nuts.NutsDescriptorProperty;
import net.thevpc.nuts.NutsDescriptorPropertyBuilder;
import net.thevpc.nuts.NutsEnvCondition;
import net.thevpc.nuts.NutsEnvConditionBuilder;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdLocation;
import net.thevpc.nuts.NutsIdType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsDescriptor;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsEnvConditionBuilder;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsProperties;
import net.thevpc.nuts.runtime.standalone.descriptor.util.NutsDescriptorUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreNutsUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.MapToFunction;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsDescriptorBuilder
implements NutsDescriptorBuilder {
    private static final long serialVersionUID = 1L;
    private NutsId id;
    private NutsId[] parents = new NutsId[0];
    private NutsIdType idType = NutsIdType.REGULAR;
    private String packaging;
    private NutsArtifactCall executor;
    private NutsArtifactCall installer;
    private String name;
    private List<String> icons = new ArrayList<String>();
    private List<String> categories;
    private String genericName;
    private String description;
    private String solver;
    private NutsEnvConditionBuilder condition;
    private List<NutsIdLocation> locations = new ArrayList<NutsIdLocation>();
    private List<NutsDependency> dependencies = new ArrayList<NutsDependency>();
    private List<NutsDependency> standardDependencies = new ArrayList<NutsDependency>();
    private Set<NutsDescriptorFlag> flags = new LinkedHashSet<NutsDescriptorFlag>();
    private List<NutsDescriptorProperty> properties = new ArrayList<NutsDescriptorProperty>();
    private transient DefaultNutsProperties _propertiesBuilder = new DefaultNutsProperties();
    private transient NutsSession session;

    public DefaultNutsDescriptorBuilder() {
    }

    public DefaultNutsDescriptorBuilder(NutsSession session) {
        this.session = session;
        this.condition = new DefaultNutsEnvConditionBuilder(session);
    }

    public DefaultNutsDescriptorBuilder(NutsDescriptor other, NutsSession session) {
        this.session = session;
        this.condition = new DefaultNutsEnvConditionBuilder(session);
        this.setAll(other);
    }

    public NutsId getId() {
        return this.id;
    }

    public NutsDescriptorBuilder setId(NutsId id) {
        this.id = id;
        return this;
    }

    public NutsDescriptorBuilder setId(String id) {
        this.id = NutsId.of((String)id, (NutsSession)this.session);
        return this;
    }

    public NutsId[] getParents() {
        return this.parents;
    }

    public NutsDescriptorBuilder setParents(NutsId[] parents) {
        NutsId[] nutsIdArray = this.parents = parents == null ? new NutsId[]{} : new NutsId[parents.length];
        if (parents != null) {
            System.arraycopy(parents, 0, this.parents, 0, this.parents.length);
        }
        return this;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public NutsDescriptorBuilder setPackaging(String packaging) {
        this.packaging = NutsUtilStrings.trim((String)packaging);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public NutsDescriptorBuilder setName(String name) {
        this.name = NutsUtilStrings.trim((String)name);
        return this;
    }

    public String getSolver() {
        return this.solver;
    }

    public NutsDescriptorBuilder setSolver(String solver) {
        this.solver = solver;
        return this;
    }

    public String getGenericName() {
        return this.genericName;
    }

    public NutsDescriptorBuilder setGenericName(String name) {
        this.genericName = name;
        return this;
    }

    public List<String> getIcons() {
        return this.icons;
    }

    public NutsDescriptorBuilder setIcons(List<String> icons) {
        this.icons = icons == null ? new ArrayList<String>() : new ArrayList<String>(icons);
        return this;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public NutsDescriptorBuilder setCategories(List<String> categories) {
        this.categories = categories == null ? new ArrayList<String>() : new ArrayList<String>(categories);
        return this;
    }

    public NutsEnvConditionBuilder getCondition() {
        return this.condition;
    }

    public NutsDescriptorBuilder setCondition(NutsEnvConditionBuilder condition) {
        this.condition.setAll(condition);
        return this;
    }

    public NutsDescriptorBuilder setCondition(NutsEnvCondition condition) {
        this.condition.setAll(condition);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public NutsDescriptorBuilder setDescription(String description) {
        this.description = NutsUtilStrings.trim((String)description);
        return this;
    }

    public NutsIdLocation[] getLocations() {
        return this.locations == null ? new NutsIdLocation[]{} : this.locations.toArray(new NutsIdLocation[0]);
    }

    public NutsDescriptorBuilder setLocations(NutsIdLocation[] locations) {
        this.locations = locations == null ? new ArrayList<NutsIdLocation>() : new ArrayList<NutsIdLocation>(Arrays.asList(locations));
        return this;
    }

    public NutsDependency[] getStandardDependencies() {
        return this.standardDependencies == null ? new NutsDependency[]{} : this.standardDependencies.toArray(new NutsDependency[0]);
    }

    public NutsDescriptorBuilder setStandardDependencies(NutsDependency[] dependencies) {
        this.standardDependencies = new ArrayList<NutsDependency>();
        if (dependencies != null) {
            for (NutsDependency dependency : dependencies) {
                if (dependency == null) {
                    throw new NullPointerException();
                }
                this.standardDependencies.add(dependency);
            }
        }
        return this;
    }

    public NutsDependency[] getDependencies() {
        return this.dependencies == null ? new NutsDependency[]{} : this.dependencies.toArray(new NutsDependency[0]);
    }

    public NutsDescriptorBuilder setDependencies(NutsDependency[] dependencies) {
        this.dependencies = new ArrayList<NutsDependency>();
        if (dependencies != null) {
            for (NutsDependency dependency : dependencies) {
                if (dependency == null) {
                    throw new NullPointerException();
                }
                this.dependencies.add(dependency);
            }
        }
        return this;
    }

    public NutsArtifactCall getExecutor() {
        return this.executor;
    }

    public NutsDescriptorBuilder setExecutor(NutsArtifactCall executor) {
        this.executor = executor;
        return this;
    }

    public NutsArtifactCall getInstaller() {
        return this.installer;
    }

    public NutsDescriptorBuilder setInstaller(NutsArtifactCall installer) {
        this.installer = installer;
        return this;
    }

    public NutsDescriptorProperty[] getProperties() {
        return this.properties.toArray(new NutsDescriptorProperty[0]);
    }

    public NutsDescriptorBuilder setProperties(NutsDescriptorProperty[] properties) {
        this._rebuildPropertiesBuilder();
        this._propertiesBuilder.clear();
        if (properties != null && properties.length != 0) {
            this._propertiesBuilder.addAll(properties);
        }
        this._updateProperties();
        return this;
    }

    public NutsDescriptorBuilder addLocation(NutsIdLocation location) {
        if (this.locations == null) {
            this.locations = new ArrayList<NutsIdLocation>();
        }
        this.locations.add(location);
        return this;
    }

    public NutsDescriptorBuilder setProperty(String name, String value) {
        NutsDescriptorProperty pp = NutsDescriptorPropertyBuilder.of((NutsSession)this.session).setName(name).setValue(value).build();
        this._rebuildPropertiesBuilder();
        if (value == null) {
            this._propertiesBuilder.remove(pp);
        } else {
            this.properties.add(pp);
        }
        this._updateProperties();
        return this;
    }

    public NutsDescriptorBuilder setAll(NutsDescriptorBuilder other) {
        if (other != null) {
            this.setId(other.getId());
            this.setIdType(other.getIdType());
            this.setPackaging(other.getPackaging());
            this.setParents(other.getParents());
            this.setDescription(other.getDescription());
            this.setName(other.getName());
            this.setExecutor(other.getExecutor());
            this.setInstaller(other.getInstaller());
            this.setCondition(other.getCondition());
            this.setLocations(other.getLocations());
            this.setDependencies(other.getDependencies());
            this.setStandardDependencies(other.getStandardDependencies());
            this.setProperties(other.getProperties());
            this.setIcons(new ArrayList<String>(other.getIcons()));
            this.setCategories(other.getCategories());
            this.setGenericName(other.getGenericName());
            this.setSolver(other.getSolver());
            this.setFlags(other.getFlags());
        } else {
            this.clear();
        }
        return this;
    }

    public NutsDescriptorBuilder setAll(NutsDescriptor other) {
        if (other != null) {
            this.setId(other.getId());
            this.setIdType(other.getIdType());
            this.setPackaging(other.getPackaging());
            this.setParents(other.getParents());
            this.setDescription(other.getDescription());
            this.setName(other.getName());
            this.setExecutor(other.getExecutor());
            this.setInstaller(other.getInstaller());
            this.setCondition(other.getCondition());
            this.setLocations(other.getLocations());
            this.setDependencies(other.getDependencies());
            this.setStandardDependencies(other.getStandardDependencies());
            this.setProperties(other.getProperties());
            this.setIcons(new ArrayList<String>(Arrays.asList(other.getIcons())));
            this.setGenericName(other.getGenericName());
            this.setCategories(new ArrayList<String>(Arrays.asList(other.getCategories())));
            this.setSolver(other.getSolver());
            this.setFlags(other.getFlags());
        } else {
            this.clear();
        }
        return this;
    }

    public NutsDescriptorBuilder clear() {
        this.setId((NutsId)null);
        this.setIdType(null);
        this.setPackaging(null);
        this.setParents(null);
        this.setDescription(null);
        this.setFlags(new LinkedHashSet<NutsDescriptorFlag>());
        this.setName(null);
        this.setExecutor(null);
        this.setInstaller(null);
        this.setCondition((NutsEnvCondition)null);
        this.setLocations(null);
        this.setDependencies(null);
        this.setStandardDependencies(null);
        this.setProperties(null);
        this.setIcons(new ArrayList<String>());
        this.setCategories(null);
        this.setGenericName(null);
        this.setSolver(null);
        return this;
    }

    public NutsDescriptorBuilder removeDependency(NutsDependency dependency) {
        if (this.dependencies != null) {
            this.dependencies.remove(dependency);
        }
        return this;
    }

    public NutsDescriptorBuilder addDependency(NutsDependency dependency) {
        if (dependency == null) {
            throw new NullPointerException();
        }
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<NutsDependency>();
        }
        this.dependencies.add(dependency);
        return this;
    }

    public NutsDescriptorBuilder addDependencies(NutsDependency[] dependencies) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<NutsDependency>();
        }
        this.dependencies.addAll(Arrays.asList(dependencies));
        return this;
    }

    public NutsDescriptorBuilder removeStandardDependency(NutsDependency dependency) {
        if (this.standardDependencies != null) {
            this.standardDependencies.remove(dependency);
        }
        return this;
    }

    public NutsDescriptorBuilder addStandardDependency(NutsDependency dependency) {
        if (this.standardDependencies == null) {
            this.standardDependencies = new ArrayList<NutsDependency>();
        }
        this.standardDependencies.add(dependency);
        return this;
    }

    public NutsDescriptorBuilder addStandardDependencies(NutsDependency[] dependencies) {
        if (this.standardDependencies == null) {
            this.standardDependencies = new ArrayList<NutsDependency>();
        }
        this.standardDependencies.addAll(Arrays.asList(dependencies));
        return this;
    }

    public NutsDescriptorBuilder addProperty(NutsDescriptorProperty property) {
        this._rebuildPropertiesBuilder();
        this._propertiesBuilder.add(property);
        this._updateProperties();
        return this;
    }

    public NutsDescriptorBuilder removeProperties(NutsDescriptorProperty property) {
        this._rebuildPropertiesBuilder();
        this._propertiesBuilder.remove(property);
        this._updateProperties();
        return this;
    }

    public NutsDescriptorBuilder addProperties(NutsDescriptorProperty[] properties) {
        if (properties != null && properties.length != 0) {
            this._rebuildPropertiesBuilder();
            this._propertiesBuilder.addAll(properties);
            this._updateProperties();
        }
        return this;
    }

    public NutsDescriptorBuilder applyProperties() {
        return this.applyProperties(NutsDescriptorUtils.getPropertiesMap(this.getProperties(), this.session));
    }

    public NutsDescriptorBuilder applyParents(NutsDescriptor[] parentDescriptors) {
        NutsId n_id = this.getId();
        String n_packaging = this.getPackaging();
        LinkedHashSet<NutsDescriptorFlag> flags = new LinkedHashSet<NutsDescriptorFlag>();
        flags.addAll(this.getFlags());
        String n_name = this.getName();
        List<String> n_categories = this.getCategories();
        n_categories = n_categories == null ? new ArrayList<String>() : new ArrayList<String>(n_categories);
        List<String> n_icons = this.getIcons();
        n_icons = n_icons == null ? new ArrayList<String>() : new ArrayList<String>(n_icons);
        String n_genericName = this.getGenericName();
        String n_desc = this.getDescription();
        NutsArtifactCall n_executor = this.getExecutor();
        NutsArtifactCall n_installer = this.getInstaller();
        ArrayList<NutsDescriptorProperty> n_props = new ArrayList<NutsDescriptorProperty>();
        for (NutsDescriptor parentDescriptor : parentDescriptors) {
            n_props.addAll(Arrays.asList(parentDescriptor.getProperties()));
        }
        NutsDescriptorProperty[] properties = this.getProperties();
        if (properties != null) {
            n_props.addAll(Arrays.asList(properties));
        }
        NutsEnvConditionBuilder b = NutsEnvConditionBuilder.of((NutsSession)this.session);
        LinkedHashSet<NutsDependency> n_deps = new LinkedHashSet<NutsDependency>();
        LinkedHashSet<NutsDependency> n_sdeps = new LinkedHashSet<NutsDependency>();
        for (NutsDescriptor parentDescriptor : parentDescriptors) {
            n_id = CoreNutsUtils.applyNutsIdInheritance(n_id, parentDescriptor.getId(), this.session);
            flags.addAll(parentDescriptor.getFlags());
            if (n_executor == null) {
                n_executor = parentDescriptor.getExecutor();
            }
            if (n_executor == null) {
                n_installer = parentDescriptor.getInstaller();
            }
            n_name = CoreNutsUtils.applyStringInheritance(n_name, parentDescriptor.getName());
            n_genericName = CoreNutsUtils.applyStringInheritance(n_genericName, parentDescriptor.getGenericName());
            n_desc = CoreNutsUtils.applyStringInheritance(n_desc, parentDescriptor.getDescription());
            n_deps.addAll(Arrays.asList(parentDescriptor.getDependencies()));
            n_sdeps.addAll(Arrays.asList(parentDescriptor.getStandardDependencies()));
            b.addAll(parentDescriptor.getCondition());
            n_icons.addAll(Arrays.asList(parentDescriptor.getIcons()));
            n_categories.addAll(Arrays.asList(parentDescriptor.getCategories()));
        }
        n_deps.addAll(Arrays.asList(this.getDependencies()));
        n_sdeps.addAll(Arrays.asList(this.getStandardDependencies()));
        b.addAll(this.getCondition());
        NutsId[] n_parents = new NutsId[]{};
        this.setId(n_id);
        this.setParents(n_parents);
        this.setPackaging(n_packaging);
        this.setFlags(flags);
        this.setExecutor(n_executor);
        this.setInstaller(n_installer);
        this.setName(n_name);
        this.setGenericName(n_genericName);
        this.setCategories(n_categories);
        this.setIcons(n_icons);
        this.setDescription(n_desc);
        this.setCondition(b);
        this.setDependencies(n_deps.toArray(new NutsDependency[0]));
        this.setStandardDependencies(n_sdeps.toArray(new NutsDependency[0]));
        this.setProperties(n_props.toArray(new NutsDescriptorProperty[0]));
        return this;
    }

    public NutsDescriptorBuilder applyProperties(Map<String, String> properties) {
        properties = this.applyPropsToProps(properties);
        MapToFunction<String, String> map = new MapToFunction<String, String>(properties);
        NutsId n_id = this.getId().builder().apply(map).build();
        String n_packaging = CoreNutsUtils.applyStringProperties(this.getPackaging(), map);
        String n_name = CoreNutsUtils.applyStringProperties(this.getName(), map);
        String n_desc = CoreNutsUtils.applyStringProperties(this.getDescription(), map);
        NutsArtifactCall n_executor = this.getExecutor();
        NutsArtifactCall n_installer = this.getInstaller();
        DefaultNutsProperties n_props = new DefaultNutsProperties();
        for (NutsDescriptorProperty property : this.getProperties()) {
            String v = property.getValue();
            if (CoreStringUtils.containsVars("${")) {
                n_props.add(property.builder().setValue(CoreNutsUtils.applyStringProperties(v, map)).build());
                continue;
            }
            n_props.add(property);
        }
        LinkedHashSet<NutsDependency> n_deps = new LinkedHashSet<NutsDependency>();
        for (NutsDependency d2 : this.getDependencies()) {
            n_deps.add(this.applyNutsDependencyProperties(d2, map));
        }
        LinkedHashSet<NutsDependency> n_sdeps = new LinkedHashSet<NutsDependency>();
        for (NutsDependency d2 : this.getStandardDependencies()) {
            n_sdeps.add(this.applyNutsDependencyProperties(d2, map));
        }
        this.setId(n_id);
        this.setParents(this.getParents());
        this.setPackaging(n_packaging);
        this.setExecutor(n_executor);
        this.setInstaller(n_installer);
        this.setName(n_name);
        this.setDescription(n_desc);
        this.setGenericName(CoreNutsUtils.applyStringProperties(this.getGenericName(), map));
        this.setIcons(this.getIcons().stream().map(x -> CoreNutsUtils.applyStringProperties(x, (Function<String, String>)map)).collect(Collectors.toList()));
        this.setCategories(this.getCategories().stream().map(x -> CoreNutsUtils.applyStringProperties(x, (Function<String, String>)map)).collect(Collectors.toList()));
        this.getCondition().applyProperties(properties);
        this.setDependencies(n_deps.toArray(new NutsDependency[0]));
        this.setStandardDependencies(n_sdeps.toArray(new NutsDependency[0]));
        this.setProperties(n_props.getAll());
        return this;
    }

    public NutsDescriptorBuilder replaceProperty(Predicate<NutsDescriptorProperty> filter, Function<NutsDescriptorProperty, NutsDescriptorProperty> converter) {
        if (converter == null) {
            return this;
        }
        DefaultNutsProperties p = new DefaultNutsProperties();
        boolean someUpdate = false;
        for (NutsDescriptorProperty entry : this.getProperties()) {
            if (filter != null && !filter.test(entry)) continue;
            NutsDescriptorProperty v = converter.apply(entry);
            if (v != null) {
                if (!Objects.equals(v, entry)) {
                    someUpdate = true;
                }
                p.add(v);
                continue;
            }
            someUpdate = true;
        }
        if (someUpdate) {
            this.setProperties(p.getAll());
        }
        return this;
    }

    public NutsDescriptorBuilder replaceDependency(Predicate<NutsDependency> filter, UnaryOperator<NutsDependency> converter) {
        if (converter == null) {
            return this;
        }
        ArrayList<NutsDependency> dependenciesList = new ArrayList<NutsDependency>();
        for (NutsDependency d : this.getDependencies()) {
            if (filter == null || filter.test(d)) {
                if ((d = (NutsDependency)converter.apply(d)) == null) continue;
                dependenciesList.add(d);
                continue;
            }
            dependenciesList.add(d);
        }
        this.dependencies = dependenciesList;
        return this;
    }

    public NutsDescriptorBuilder removeDependency(Predicate<NutsDependency> dependency) {
        if (dependency == null) {
            return this;
        }
        Iterator<NutsDependency> it = this.dependencies.iterator();
        while (it.hasNext()) {
            NutsDependency d = it.next();
            if (!dependency.test(d)) continue;
            it.remove();
        }
        return this;
    }

    public NutsDescriptor build() {
        LinkedHashSet<NutsDescriptorFlag> flags = new LinkedHashSet<NutsDescriptorFlag>();
        NutsIdType idType = this.getIdType();
        block23: for (NutsDescriptorProperty property : this.getProperties()) {
            if (!NutsBlankable.isBlank((NutsBlankable)property.getCondition())) continue;
            switch (property.getName()) {
                case "nuts.application": {
                    if (!NutsUtilStrings.parseBoolean((String)property.getValue(), (Boolean)false, (Boolean)false).booleanValue()) continue block23;
                    flags.add(NutsDescriptorFlag.APP);
                    flags.add(NutsDescriptorFlag.EXEC);
                    continue block23;
                }
                case "nuts.executable": {
                    if (!NutsUtilStrings.parseBoolean((String)property.getValue(), (Boolean)false, (Boolean)false).booleanValue()) continue block23;
                    flags.add(NutsDescriptorFlag.EXEC);
                    continue block23;
                }
                case "nuts.term": {
                    if (!NutsUtilStrings.parseBoolean((String)property.getValue(), (Boolean)false, (Boolean)false).booleanValue()) continue block23;
                    flags.add(NutsDescriptorFlag.TERM);
                    continue block23;
                }
                case "nuts.gui": {
                    if (!NutsUtilStrings.parseBoolean((String)property.getValue(), (Boolean)false, (Boolean)false).booleanValue()) continue block23;
                    flags.add(NutsDescriptorFlag.GUI);
                    continue block23;
                }
                case "nuts.extension": {
                    if (!NutsUtilStrings.parseBoolean((String)property.getValue(), (Boolean)false, (Boolean)false).booleanValue()) continue block23;
                    idType = NutsIdType.EXTENSION;
                    continue block23;
                }
                case "nuts.runtime": {
                    if (!NutsUtilStrings.parseBoolean((String)property.getValue(), (Boolean)false, (Boolean)false).booleanValue()) continue block23;
                    idType = NutsIdType.RUNTIME;
                    continue block23;
                }
                case "nuts.companion": {
                    if (!NutsUtilStrings.parseBoolean((String)property.getValue(), (Boolean)false, (Boolean)false).booleanValue()) continue block23;
                    idType = NutsIdType.COMPANION;
                    continue block23;
                }
                case "nuts.api": {
                    if (!NutsUtilStrings.parseBoolean((String)property.getValue(), (Boolean)false, (Boolean)false).booleanValue()) continue block23;
                    flags.add(NutsDescriptorFlag.NUTS_API);
                }
            }
        }
        for (NutsDescriptorFlag flag : this.flags) {
            flags.add(flag);
            switch (flag) {
                case APP: 
                case TERM: 
                case GUI: {
                    flags.add(NutsDescriptorFlag.EXEC);
                }
            }
        }
        return new DefaultNutsDescriptor(this.getId(), idType, this.getParents(), this.getPackaging(), this.getExecutor(), this.getInstaller(), this.getName(), this.getDescription(), this.getCondition().build(), this.getDependencies(), this.getStandardDependencies(), this.getLocations(), this.getProperties(), this.genericName, this.categories == null ? new String[]{} : this.categories.toArray(new String[0]), this.icons == null ? new String[]{} : this.icons.toArray(new String[0]), flags.toArray(new NutsDescriptorFlag[0]), this.getSolver(), this.session);
    }

    public NutsDescriptorBuilder copy() {
        return new DefaultNutsDescriptorBuilder(this.session).setAll(this);
    }

    public Set<NutsDescriptorFlag> getFlags() {
        return this.flags;
    }

    public NutsDescriptorBuilder setFlags(Set<NutsDescriptorFlag> flags) {
        this.flags = flags == null ? new LinkedHashSet<NutsDescriptorFlag>() : new LinkedHashSet<NutsDescriptorFlag>(flags);
        return this;
    }

    public NutsDescriptorBuilder addFlag(NutsDescriptorFlag flag) {
        if (flag != null) {
            this.flags.add(flag);
        }
        return this;
    }

    public NutsDescriptorBuilder addFlags(NutsDescriptorFlag ... flags) {
        if (flags != null) {
            for (NutsDescriptorFlag flag : flags) {
                if (flag == null) continue;
                this.flags.add(flag);
            }
        }
        return this;
    }

    public NutsDescriptorBuilder removeFlag(NutsDescriptorFlag flag) {
        if (flag != null) {
            this.flags.remove(flag);
        }
        return this;
    }

    public NutsDescriptorBuilder removeFlags(NutsDescriptorFlag ... flags) {
        if (flags != null) {
            for (NutsDescriptorFlag flag : flags) {
                if (flag == null) continue;
                this.flags.remove(flag);
            }
        }
        return this;
    }

    public NutsDescriptorProperty getProperty(String name) {
        return Arrays.stream(this._propertiesBuilder.getAll()).filter(x -> x.getName().equals(name)).findFirst().orElse(null);
    }

    public String getPropertyValue(String name) {
        NutsDescriptorProperty p = this.getProperty(name);
        return p == null ? null : p.getValue();
    }

    public NutsIdType getIdType() {
        return this.idType;
    }

    public NutsDescriptorBuilder setIdType(NutsIdType idType) {
        this.idType = idType == null ? NutsIdType.REGULAR : idType;
        return this;
    }

    private Map<String, String> prepareGlobalProperties() {
        LinkedHashMap<String, String> global = new LinkedHashMap<String, String>();
        global.putAll(System.getProperties());
        NutsId ii = this.getId();
        for (String s : new String[]{"project.name", "pom.name"}) {
            global.put(s, this.getName());
        }
        if (ii != null) {
            if (ii.getVersion().getValue() != null) {
                for (String s : new String[]{"project.version", "version", "pom.version"}) {
                    global.put(s, ii.getVersion().getValue());
                }
            }
            for (String s : new String[]{"project.groupId", "pom.groupId"}) {
                global.put(s, ii.getGroupId());
            }
            for (String s : new String[]{"project.artifactId", "pom.artifactId"}) {
                global.put(s, ii.getArtifactId());
            }
        }
        return global;
    }

    private Map<String, String> applyPropsToProps(Map<String, String> properties) {
        LinkedHashMap<String, String> oldMap = new LinkedHashMap<String, String>(properties);
        for (Map.Entry<String, String> entry : this.prepareGlobalProperties().entrySet()) {
            if (oldMap.containsKey(entry.getKey())) continue;
            oldMap.put(entry.getKey(), entry.getValue());
        }
        TreeSet updated = new TreeSet();
        for (int i = 0; i < 16; ++i) {
            MapToFunction<String, String> fct = new MapToFunction<String, String>(oldMap);
            LinkedHashMap<String, String> newMap = new LinkedHashMap<String, String>(oldMap.size());
            updated = new TreeSet();
            for (Map.Entry entry : oldMap.entrySet()) {
                String v1;
                String v0 = (String)entry.getValue();
                if (!Objects.equals(v0, v1 = CoreNutsUtils.applyStringProperties(v0, fct))) {
                    updated.add(entry.getKey());
                }
                newMap.put((String)entry.getKey(), v1);
            }
            if (updated.isEmpty()) {
                return newMap;
            }
            oldMap = newMap;
        }
        throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"too many recursion applying properties %s", (Object[])new Object[]{updated}));
    }

    private void _rebuildPropertiesBuilder() {
        if (this._propertiesBuilder == null) {
            this._propertiesBuilder = new DefaultNutsProperties();
            this._propertiesBuilder.addAll(this.properties.toArray(new NutsDescriptorProperty[0]));
        }
    }

    private void _updateProperties() {
        this.properties.clear();
        this.properties.addAll(Arrays.asList(this._propertiesBuilder.getAll()));
    }

    private NutsEnvCondition applyNutsConditionProperties(NutsEnvCondition child, Function<String, String> properties) {
        return child.builder().setOs(CoreNutsUtils.applyStringProperties(child.getOs(), properties)).setOsDist(CoreNutsUtils.applyStringProperties(child.getOsDist(), properties)).setPlatform(CoreNutsUtils.applyStringProperties(child.getPlatform(), properties)).setProfile(CoreNutsUtils.applyStringProperties(child.getProfile(), properties)).setDesktopEnvironment(CoreNutsUtils.applyStringProperties(child.getDesktopEnvironment(), properties)).setArch(CoreNutsUtils.applyStringProperties(child.getArch(), properties)).build();
    }

    private NutsId applyNutsIdProperties(NutsId child, Function<String, String> properties) {
        return NutsIdBuilder.of((NutsSession)this.session).setRepository(CoreNutsUtils.applyStringProperties(child.getRepository(), properties)).setGroupId(CoreNutsUtils.applyStringProperties(child.getGroupId(), properties)).setArtifactId(CoreNutsUtils.applyStringProperties(child.getArtifactId(), properties)).setVersion(CoreNutsUtils.applyStringProperties(child.getVersion().getValue(), properties)).setCondition(this.applyNutsConditionProperties(child.getCondition(), properties)).setClassifier(CoreNutsUtils.applyStringProperties(child.getClassifier(), properties)).setPackaging(CoreNutsUtils.applyStringProperties(child.getPackaging(), properties)).setProperties(CoreNutsUtils.applyMapProperties(child.getProperties(), properties)).build();
    }

    private NutsDependency applyNutsDependencyProperties(NutsDependency child, Function<String, String> properties) {
        NutsId[] exclusions = child.getExclusions();
        for (int i = 0; i < exclusions.length; ++i) {
            exclusions[i] = this.applyNutsIdProperties(exclusions[i], properties);
        }
        return NutsDependencyBuilder.of((NutsSession)this.session).setRepository(CoreNutsUtils.applyStringProperties(child.getRepository(), properties)).setGroupId(CoreNutsUtils.applyStringProperties(child.getGroupId(), properties)).setArtifactId(CoreNutsUtils.applyStringProperties(child.getArtifactId(), properties)).setVersion(CoreNutsUtils.applyStringProperties(child.getVersion(), properties, this.session)).setClassifier(CoreNutsUtils.applyStringProperties(child.getClassifier(), properties)).setScope(CoreNutsUtils.applyStringProperties(child.getScope(), properties)).setOptional(CoreNutsUtils.applyStringProperties(child.getOptional(), properties)).setCondition(this.applyNutsConditionProperties(child.getCondition(), properties)).setType(CoreNutsUtils.applyStringProperties(child.getType(), properties)).setExclusions(exclusions).setProperties(CoreNutsUtils.applyStringProperties(child.getPropertiesQuery(), properties)).build();
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.idType, this.packaging, this.executor, this.installer, this.name, this.icons, this.categories, this.genericName, this.description, this.condition, this.locations, this.dependencies, this.standardDependencies, this.properties, this.flags, this.solver, this.session);
        result = 31 * result + Arrays.hashCode(this.parents);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsDescriptorBuilder that = (DefaultNutsDescriptorBuilder)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.idType, that.idType) && Arrays.equals(this.parents, that.parents) && Objects.equals(this.packaging, that.packaging) && Objects.equals(this.executor, that.executor) && Objects.equals(this.installer, that.installer) && Objects.equals(this.name, that.name) && Objects.equals(this.icons, that.icons) && Objects.equals(this.categories, that.categories) && Objects.equals(this.genericName, that.genericName) && Objects.equals(this.description, that.description) && Objects.equals(this.condition, that.condition) && Objects.equals(this.locations, that.locations) && Objects.equals(this.dependencies, that.dependencies) && Objects.equals(this.standardDependencies, that.standardDependencies) && Objects.equals(this.properties, that.properties) && Objects.equals(this.flags, that.flags) && Objects.equals(this.solver, that.solver) && Objects.equals(this.session, that.session);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

