/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsDescriptorFlag;
import net.thevpc.nuts.NutsDescriptorProperty;
import net.thevpc.nuts.NutsEnvCondition;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdLocation;
import net.thevpc.nuts.NutsIdType;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.descriptor.AbstractNutsDescriptor;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsProperties;
import net.thevpc.nuts.runtime.standalone.util.collections.CoreArrayUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

public class DefaultNutsDescriptor
extends AbstractNutsDescriptor {
    private static final long serialVersionUID = 1L;
    private final String solver;
    private final NutsArtifactCall executor;
    private final NutsArtifactCall installer;
    private final NutsEnvCondition condition;
    private final NutsIdLocation[] locations;
    private final NutsDependency[] dependencies;
    private final NutsDependency[] standardDependencies;
    private final NutsDescriptorProperty[] properties;
    private final Set<NutsDescriptorFlag> flags;
    private NutsId id;
    private NutsIdType idType;
    private NutsId[] parents;
    private String packaging;
    private String name;
    private String description;
    private String[] icons;
    private String[] categories;
    private String genericName;

    public DefaultNutsDescriptor(NutsDescriptor d, NutsSession session) {
        this(d.getId(), d.getIdType(), d.getParents(), d.getPackaging(), d.getExecutor(), d.getInstaller(), d.getName(), d.getDescription(), d.getCondition(), d.getDependencies(), d.getStandardDependencies(), d.getLocations(), d.getProperties(), d.getGenericName(), d.getCategories(), d.getIcons(), d.getFlags().toArray(new NutsDescriptorFlag[0]), d.getSolver(), session);
    }

    public DefaultNutsDescriptor(NutsId id, NutsIdType idType, NutsId[] parents, String packaging, NutsArtifactCall executor, NutsArtifactCall installer, String name, String description, NutsEnvCondition condition, NutsDependency[] dependencies, NutsDependency[] standardDependencies, NutsIdLocation[] locations, NutsDescriptorProperty[] properties, String genericName, String[] categories, String[] icons, NutsDescriptorFlag[] flags, String solver, NutsSession session) {
        super(session);
        int i;
        this.id = id == null ? NutsId.of((String)"", (NutsSession)session) : id;
        this.idType = idType == null ? NutsIdType.REGULAR : idType;
        this.packaging = NutsUtilStrings.trimToNull((String)packaging);
        NutsId[] nutsIdArray = this.parents = parents == null ? new NutsId[]{} : new NutsId[parents.length];
        if (parents != null) {
            System.arraycopy(parents, 0, this.parents, 0, this.parents.length);
        }
        this.description = NutsUtilStrings.trimToNull((String)description);
        this.name = NutsUtilStrings.trimToNull((String)name);
        this.genericName = NutsUtilStrings.trimToNull((String)genericName);
        this.icons = icons == null ? new String[]{} : (String[])Arrays.stream(icons).map(x -> x == null ? "" : x.trim()).filter(x -> x.length() > 0).toArray(String[]::new);
        this.categories = categories == null ? new String[]{} : (String[])Arrays.stream(categories).map(x -> x == null ? "" : x.trim()).filter(x -> x.length() > 0).toArray(String[]::new);
        this.executor = executor;
        this.installer = installer;
        this.condition = CoreFilterUtils.trimToBlank(condition, session);
        this.locations = CoreArrayUtils.toArraySet(locations);
        this.dependencies = dependencies == null ? new NutsDependency[]{} : new NutsDependency[dependencies.length];
        for (i = 0; i < this.dependencies.length; ++i) {
            if (dependencies[i] == null) {
                throw new NullPointerException();
            }
            this.dependencies[i] = dependencies[i];
        }
        this.standardDependencies = standardDependencies == null ? new NutsDependency[]{} : new NutsDependency[standardDependencies.length];
        for (i = 0; i < this.standardDependencies.length; ++i) {
            if (standardDependencies[i] == null) {
                throw new NullPointerException();
            }
            this.standardDependencies[i] = standardDependencies[i];
        }
        if (properties == null || properties.length == 0) {
            this.properties = null;
        } else {
            DefaultNutsProperties p = new DefaultNutsProperties();
            p.addAll(properties);
            this.properties = p.getAll();
        }
        this.flags = Collections.unmodifiableSet(new LinkedHashSet(Arrays.stream(flags == null ? new NutsDescriptorFlag[]{} : flags).filter(Objects::nonNull).collect(Collectors.toList())));
        this.solver = NutsUtilStrings.trimToNull((String)solver);
    }

    public NutsIdType getIdType() {
        return this.idType;
    }

    public boolean isBlank() {
        if (!NutsBlankable.isBlank((NutsBlankable)this.id)) {
            return false;
        }
        if (!NutsBlankable.isBlank((String)this.packaging)) {
            return false;
        }
        if (this.idType != NutsIdType.REGULAR) {
            return false;
        }
        if (this.parents != null) {
            for (NutsId nutsId : this.parents) {
                if (NutsBlankable.isBlank((NutsBlankable)nutsId)) continue;
                return false;
            }
        }
        if (!NutsBlankable.isBlank((String)this.description)) {
            return false;
        }
        if (!NutsBlankable.isBlank((String)this.name)) {
            return false;
        }
        if (!NutsBlankable.isBlank((String)this.genericName)) {
            return false;
        }
        if (this.icons != null) {
            for (String string : this.icons) {
                if (NutsBlankable.isBlank((String)string)) continue;
                return false;
            }
        }
        if (this.categories != null) {
            for (String string : this.categories) {
                if (NutsBlankable.isBlank((String)string)) continue;
                return false;
            }
        }
        if (!NutsBlankable.isBlank((NutsBlankable)this.executor)) {
            return false;
        }
        if (!NutsBlankable.isBlank((NutsBlankable)this.installer)) {
            return false;
        }
        if (!NutsBlankable.isBlank((NutsBlankable)this.condition)) {
            return false;
        }
        for (NutsIdLocation nutsIdLocation : this.locations) {
            if (NutsBlankable.isBlank((NutsBlankable)nutsIdLocation)) continue;
            return false;
        }
        if (this.dependencies != null) {
            for (NutsDependency nutsDependency : this.dependencies) {
                if (NutsBlankable.isBlank((NutsBlankable)nutsDependency)) continue;
                return false;
            }
        }
        if (this.standardDependencies != null) {
            for (NutsDependency nutsDependency : this.standardDependencies) {
                if (NutsBlankable.isBlank((NutsBlankable)nutsDependency)) continue;
                return false;
            }
        }
        if (this.properties != null && this.properties.length > 0) {
            for (NutsDescriptorProperty nutsDescriptorProperty : this.properties) {
                if (NutsBlankable.isBlank((NutsBlankable)nutsDescriptorProperty)) continue;
                return false;
            }
        }
        if (!this.flags.isEmpty()) {
            return false;
        }
        return NutsBlankable.isBlank((String)this.solver);
    }

    public boolean isValid() {
        if (NutsBlankable.isBlank((NutsBlankable)this.id)) {
            return false;
        }
        if (NutsBlankable.isBlank((String)this.id.getGroupId())) {
            return false;
        }
        if (NutsBlankable.isBlank((String)this.id.getArtifactId())) {
            return false;
        }
        if (NutsBlankable.isBlank((NutsBlankable)this.id.getVersion())) {
            return false;
        }
        return this.id.isLongId();
    }

    public void check() {
        if (NutsBlankable.isBlank((NutsBlankable)this.id)) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing id", (Object[])new Object[0]));
        }
        if (NutsBlankable.isBlank((String)this.id.getGroupId())) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing groupId", (Object[])new Object[0]));
        }
        if (NutsBlankable.isBlank((String)this.id.getArtifactId())) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing artifactId", (Object[])new Object[0]));
        }
        if (NutsBlankable.isBlank((NutsBlankable)this.id.getVersion())) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing version", (Object[])new Object[0]));
        }
        if (NutsBlankable.isBlank((String)this.id.getArtifactId())) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"missing artifactId for %s", (Object[])new Object[]{this.id}));
        }
        if (!this.id.isLongId()) {
            throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"id should not have query defined in descriptors : %s", (Object[])new Object[]{this.id}));
        }
    }

    public NutsId getId() {
        return this.id;
    }

    public NutsId[] getParents() {
        return this.parents;
    }

    public boolean isExecutable() {
        return this.getFlags().contains(NutsDescriptorFlag.EXEC);
    }

    public boolean isApplication() {
        return this.getFlags().contains(NutsDescriptorFlag.APP);
    }

    public Set<NutsDescriptorFlag> getFlags() {
        return this.flags;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getSolver() {
        return this.solver;
    }

    public NutsEnvCondition getCondition() {
        return this.condition;
    }

    public String getName() {
        return this.name;
    }

    public String[] getIcons() {
        return this.icons;
    }

    public String getGenericName() {
        return this.genericName;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public String getDescription() {
        return this.description;
    }

    public NutsIdLocation[] getLocations() {
        return this.locations;
    }

    public NutsDependency[] getStandardDependencies() {
        return this.standardDependencies;
    }

    public NutsDependency[] getDependencies() {
        return this.dependencies;
    }

    public NutsArtifactCall getExecutor() {
        return this.executor;
    }

    public NutsArtifactCall getInstaller() {
        return this.installer;
    }

    public NutsDescriptorProperty[] getProperties() {
        return this.properties == null ? new NutsDescriptorProperty[]{} : this.properties;
    }

    public NutsDescriptorProperty getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return Arrays.stream(this.properties).filter(x -> x.getName().equals(name)).findFirst().orElse(null);
    }

    public String getPropertyValue(String name) {
        NutsDescriptorProperty p = this.getProperty(name);
        return p == null ? null : p.getValue();
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.idType, this.packaging, this.executor, this.installer, this.name, this.description, this.genericName, this.condition, this.flags, this.solver);
        result = 31 * result + Arrays.hashCode(this.categories);
        result = 31 * result + Arrays.hashCode(this.properties);
        result = 31 * result + Arrays.hashCode(this.icons);
        result = 31 * result + Arrays.hashCode(this.parents);
        result = 31 * result + Arrays.hashCode(this.locations);
        result = 31 * result + Arrays.hashCode(this.dependencies);
        result = 31 * result + Arrays.hashCode(this.standardDependencies);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsDescriptor that = (DefaultNutsDescriptor)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.idType, that.idType) && Arrays.equals(this.parents, that.parents) && Objects.equals(this.solver, that.solver) && Objects.equals(this.packaging, that.packaging) && Objects.equals(this.executor, that.executor) && Objects.equals(this.installer, that.installer) && Objects.equals(this.name, that.name) && Arrays.equals(this.icons, that.icons) && Arrays.equals(this.categories, that.categories) && Objects.equals(this.genericName, that.genericName) && Objects.equals(this.description, that.description) && Objects.equals(this.condition, that.condition) && Arrays.equals(this.locations, that.locations) && Arrays.equals(this.dependencies, that.dependencies) && Arrays.equals(this.standardDependencies, that.standardDependencies) && Objects.equals(this.flags, that.flags) && Arrays.equals(this.properties, that.properties);
    }

    public String toString() {
        return "DefaultNutsDescriptor{id=" + this.id + ", idType=" + this.idType.id() + ", parents=" + Arrays.toString(this.parents) + ", packaging='" + this.packaging + '\'' + ", executor=" + this.executor + ", flags=" + this.flags + ", installer=" + this.installer + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", condition=" + this.condition + ", locations=" + Arrays.toString(this.locations) + ", dependencies=" + Arrays.toString(this.dependencies) + ", standardDependencies=" + Arrays.toString(this.standardDependencies) + ", icon=" + Arrays.toString(this.icons) + ", category=" + Arrays.toString(this.categories) + ", genericName=" + this.genericName + ", properties=" + Arrays.toString(this.properties) + ", solver=" + this.solver + '}';
    }
}

