/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsArtifactCallBuilder;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.descriptor.DefaultNutsArtifactCall;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsArtifactCallBuilder
implements NutsArtifactCallBuilder,
Serializable {
    private static final long serialVersionUID = 1L;
    private NutsId id;
    private String[] arguments = new String[0];
    private final Map<String, String> properties = new LinkedHashMap<String, String>();
    private NutsSession session;

    public DefaultNutsArtifactCallBuilder() {
    }

    public DefaultNutsArtifactCallBuilder(NutsSession session) {
        this.session = session;
    }

    public DefaultNutsArtifactCallBuilder(NutsArtifactCall value, NutsSession session) {
        this.session = session;
        this.setId(value.getId());
        this.setArguments(value.getArguments());
        this.setProperties(value.getProperties());
    }

    public NutsId getId() {
        return this.id;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public DefaultNutsArtifactCallBuilder setArguments(String ... arguments) {
        this.arguments = arguments == null ? new String[]{} : arguments;
        return this;
    }

    public DefaultNutsArtifactCallBuilder setProperties(Map<String, String> properties) {
        this.properties.clear();
        if (properties != null) {
            for (Map.Entry<String, String> stringStringEntry : properties.entrySet()) {
                if (stringStringEntry.getValue() != null) {
                    this.properties.put(stringStringEntry.getKey(), stringStringEntry.getValue());
                    continue;
                }
                this.properties.remove(stringStringEntry.getKey());
            }
        }
        return this;
    }

    public DefaultNutsArtifactCallBuilder setId(NutsId id) {
        this.id = id;
        return this;
    }

    public NutsArtifactCallBuilder set(NutsArtifactCallBuilder value) {
        return null;
    }

    public NutsArtifactCallBuilder set(NutsArtifactCall value) {
        if (value != null) {
            this.setId(value.getId());
            this.setArguments(value.getArguments());
            this.setProperties(value.getProperties());
        } else {
            this.clear();
        }
        return this;
    }

    public NutsArtifactCallBuilder clear() {
        this.setId(null);
        this.setArguments(new String[0]);
        this.setProperties((Map)null);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsArtifactCallBuilder that = (DefaultNutsArtifactCallBuilder)o;
        return Objects.equals(this.id, that.id) && Arrays.equals(this.arguments, that.arguments) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.properties);
        result = 31 * result + Arrays.hashCode(this.arguments);
        return result;
    }

    public NutsArtifactCall build() {
        return new DefaultNutsArtifactCall(this.id, this.arguments, this.properties);
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

