/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.NutsArtifactCall;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsId;

public class DefaultNutsArtifactCall
implements NutsArtifactCall,
Serializable {
    private static final long serialVersionUID = 1L;
    private NutsId id;
    private String[] arguments;
    private Map<String, String> properties;

    protected DefaultNutsArtifactCall() {
    }

    public DefaultNutsArtifactCall(NutsArtifactCall other) {
        this.id = other.getId();
        this.arguments = other.getArguments();
        this.properties = other.getProperties();
    }

    public boolean isBlank() {
        if (!NutsBlankable.isBlank((NutsBlankable)this.id)) {
            return false;
        }
        if (this.arguments != null) {
            for (String d : this.arguments) {
                if (NutsBlankable.isBlank((String)d)) continue;
                return false;
            }
        }
        if (this.properties != null) {
            for (Map.Entry entry : this.properties.entrySet()) {
                if (!NutsBlankable.isBlank((String)((String)entry.getKey()))) {
                    return false;
                }
                if (NutsBlankable.isBlank((String)((String)entry.getValue()))) continue;
                return false;
            }
        }
        return true;
    }

    public DefaultNutsArtifactCall(NutsId id) {
        this(id, null, null);
    }

    public DefaultNutsArtifactCall(NutsId id, String[] options) {
        this(id, options, null);
    }

    public DefaultNutsArtifactCall(NutsId id, String[] options, Map<String, String> properties) {
        this.id = id;
        this.arguments = options == null ? new String[]{} : options;
        this.properties = properties == null ? Collections.emptyMap() : properties;
    }

    public NutsId getId() {
        return this.id;
    }

    public String[] getArguments() {
        if (this.arguments == null) {
            this.arguments = new String[0];
        }
        return this.arguments;
    }

    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNutsArtifactCall that = (DefaultNutsArtifactCall)o;
        return Objects.equals(this.id, that.id) && Arrays.equals(this.arguments, that.arguments) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.properties);
        result = 31 * result + Arrays.hashCode(this.arguments);
        return result;
    }

    public String toString() {
        return "DefaultNutsArtifactCall{id=" + this.id + ", arguments=" + Arrays.toString(this.arguments) + ", properties=" + this.properties + '}';
    }
}

