/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.util;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Objects;
import net.thevpc.nuts.NutsClassLoaderNode;
import net.thevpc.nuts.NutsContent;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependencyTreeNode;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.dependency.util.NutsDependencyUtils;

public final class NutsClassLoaderUtils {
    public static NutsClassLoaderNode definitionToClassLoaderNode(NutsDefinition def, NutsSession session) {
        if (session == null) {
            throw new NullPointerException("session cannot be null");
        }
        if (def.getContent() == null || def.getContent().getURL() == null || def.getDependencies() == null) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"definition must provide content and dependencies", (Object[])new Object[0]));
        }
        return new NutsClassLoaderNode(def.getId().toString(), def.getContent().getURL(), true, true, (NutsClassLoaderNode[])def.getDependencies().transitiveNodes().stream().map(x -> NutsClassLoaderUtils.toClassLoaderNode(x, session)).filter(Objects::nonNull).toArray(NutsClassLoaderNode[]::new));
    }

    private static NutsClassLoaderNode toClassLoaderNode(NutsDependencyTreeNode d, NutsSession session) {
        return NutsClassLoaderUtils.toClassLoaderNodeWithOptional(d, false, session);
    }

    private static NutsClassLoaderNode toClassLoaderNodeWithOptional(NutsDependencyTreeNode d, boolean isOptional, NutsSession session) {
        URL url;
        NutsContent cc = null;
        if (!isOptional && !NutsDependencyUtils.isRequiredDependency(d.getDependency())) {
            isOptional = true;
        }
        try {
            cc = session.fetch().setId(d.getDependency().toId()).setSession(session).getResultContent();
        }
        catch (NutsNotFoundException nutsNotFoundException) {
            // empty catch block
        }
        if (cc != null && (url = cc.getURL()) != null) {
            ArrayList<NutsClassLoaderNode> aa = new ArrayList<NutsClassLoaderNode>();
            for (NutsDependencyTreeNode child : d.getChildren()) {
                NutsClassLoaderNode q = NutsClassLoaderUtils.toClassLoaderNodeWithOptional(child, isOptional, session);
                if (q == null) continue;
                aa.add(q);
            }
            return new NutsClassLoaderNode(d.getDependency().toId().toString(), url, true, true, aa.toArray(new NutsClassLoaderNode[0]));
        }
        if (isOptional) {
            return null;
        }
        throw new NutsNotFoundException(session, d.getDependency().toId());
    }

    public static URL[] resolveClasspathURLs(ClassLoader contextClassLoader) {
        ArrayList<URL> all = new ArrayList<URL>();
        if (contextClassLoader != null) {
            if (contextClassLoader instanceof URLClassLoader) {
                all.addAll(Arrays.asList(((URLClassLoader)contextClassLoader).getURLs()));
            } else {
                try {
                    Enumeration<URL> r = contextClassLoader.getResources("META-INF/MANIFEST.MF");
                    while (r.hasMoreElements()) {
                        URL u = r.nextElement();
                        if ("jrt".equals(u.getProtocol()) || !"jar".equals(u.getProtocol()) || !u.getFile().endsWith("!/META-INF/MANIFEST.MF")) continue;
                        String jar = u.getFile().substring(0, u.getFile().length() - "!/META-INF/MANIFEST.MF".length());
                        all.add(new URL(jar));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return all.toArray(new URL[0]);
    }
}

