/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.solver;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependencies;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDependencyTreeNode;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsNotFoundException;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.runtime.standalone.dependency.DefaultNutsDependencies;
import net.thevpc.nuts.runtime.standalone.dependency.DefaultNutsDependencyTreeNode;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.spi.NutsDependencySolver;

public class MavenNutsDependencySolver
implements NutsDependencySolver {
    private List<NutsDependencyTreeNodeBuild> defs = new ArrayList<NutsDependencyTreeNodeBuild>();
    private List<RootInfo> pending = new ArrayList<RootInfo>();
    private NutsWorkspace ws;
    private NutsSession session;
    private NutsDependencyFilter dependencyFilter;
    private NutsDependencyFilter effDependencyFilter;
    private boolean shouldIncludeContent = false;
    private boolean failFast;

    public MavenNutsDependencySolver(NutsSession session) {
        this.session = session;
        this.ws = session.getWorkspace();
    }

    public NutsDependencySolver addRootId(NutsId id) {
        this.pending.add(new RootInfo(id.toDependency(), null));
        return this;
    }

    public NutsDependencySolver add(NutsDefinition def) {
        this.pending.add(new RootInfo(null, def));
        return this;
    }

    public NutsDependencySolver add(NutsDependency dependency) {
        this.pending.add(new RootInfo(dependency, null));
        return this;
    }

    public NutsDependencySolver setFilter(NutsDependencyFilter dependencyFilter) {
        this.dependencyFilter = dependencyFilter;
        this.effDependencyFilter = null;
        return this;
    }

    public NutsDependencies solve() {
        for (RootInfo rootInfo : this.pending) {
            this.addRootDefinition0(rootInfo.dependency, rootInfo.def, this.session);
        }
        this.pending.clear();
        ArrayList<NutsDependencyTreeNodeBuild> mergedRootNodeBuilders = new ArrayList<NutsDependencyTreeNodeBuild>();
        ArrayList<NutsDependencyTreeNodeBuild> nonMergedRootNodeBuilders = new ArrayList<NutsDependencyTreeNodeBuild>();
        ArrayDeque<NutsDependencyTreeNodeBuild> queue = new ArrayDeque<NutsDependencyTreeNodeBuild>();
        LinkedHashSet<NutsId> sourceIds = new LinkedHashSet<NutsId>();
        LinkedHashSet<NutsDependency> immediates = new LinkedHashSet<NutsDependency>();
        NutsDependencyInfoSet mergedVisitedSet = new NutsDependencyInfoSet();
        NutsDependencyInfoSet nonMergedVisitedSet = new NutsDependencyInfoSet();
        NutsDependencyFilter effDependencyFilter = null;
        NutsDependencyFilters filter = NutsDependencyFilters.of((NutsSession)this.session);
        effDependencyFilter = this.dependencyFilter == null ? (NutsDependencyFilter)filter.always() : this.dependencyFilter;
        for (NutsDependencyTreeNodeBuild currentNode : this.defs) {
            NutsId id = currentNode.getEffectiveId();
            if (!sourceIds.add(id) || !mergedVisitedSet.add(currentNode.key)) continue;
            mergedRootNodeBuilders.add(currentNode);
            NutsDependency[] immediate = CoreFilterUtils.filterDependencies(id, currentNode.getEffectiveDescriptor().getDependencies(), effDependencyFilter, this.session);
            immediates.addAll(Arrays.asList(immediate));
            NutsDependency[] nutsDependencyArray = currentNode.def.getEffectiveDescriptor().getDependencies();
            int n = nutsDependencyArray.length;
            for (int i = 0; i < n; ++i) {
                NutsDependency dependency = nutsDependencyArray[i];
                dependency = dependency.builder().setProperty("provided-by", currentNode.id.toString()).build();
                NutsDependency effDependency = dependency.builder().setScope(this.combineScopes(currentNode.effDependency.getScope(), dependency.getScope())).build();
                if (!effDependencyFilter.acceptDependency(currentNode.def.getId(), effDependency, this.session) || currentNode.exclusions.contains(dependency.toId().getShortId())) continue;
                NutsDefinition def22 = null;
                try {
                    def22 = (NutsDefinition)this.session.search().addId(dependency.toId()).setSession(this.session).setEffective(true).setContent(this.shouldIncludeContent).setLatest(true).getResultDefinitions().required();
                }
                catch (NutsNotFoundException nutsNotFoundException) {
                    // empty catch block
                }
                NutsDependencyTreeNodeBuild info = new NutsDependencyTreeNodeBuild(currentNode, def22, dependency, effDependency, currentNode.depth + 1, this.session);
                info.exclusions.addAll(currentNode.exclusions);
                NutsId[] nutsIdArray = dependency.getExclusions();
                int n2 = nutsIdArray.length;
                for (int j = 0; j < n2; ++j) {
                    NutsId exclusion = nutsIdArray[j];
                    info.exclusions.add(exclusion.getShortId());
                }
                currentNode.children.add(info);
                nonMergedRootNodeBuilders.add(info);
                queue.add(info);
            }
        }
        while (!queue.isEmpty()) {
            NutsDependencyTreeNodeBuild currentNode = (NutsDependencyTreeNodeBuild)queue.remove();
            NutsDependencyInfo nextId = currentNode.key;
            if (!mergedVisitedSet.contains(nextId) && nonMergedVisitedSet.add(nextId)) {
                mergedVisitedSet.add(nextId);
                NutsDescriptor effectiveDescriptor = currentNode.getEffectiveDescriptor();
                if (effectiveDescriptor == null) continue;
                for (NutsDependency dependency : effectiveDescriptor.getDependencies()) {
                    dependency = dependency.builder().setProperty("provided-by", currentNode.id.toString()).build();
                    NutsDependency effDependency = dependency.builder().setScope(this.combineScopes(currentNode.effDependency.getScope(), dependency.getScope())).build();
                    if (!effDependencyFilter.acceptDependency(currentNode.getEffectiveId(), effDependency, this.session) || currentNode.exclusions.contains(dependency.toId().getShortId())) continue;
                    NutsDefinition def2 = null;
                    try {
                        def2 = (NutsDefinition)this.session.search().addId(dependency.toId()).setSession(this.session).setEffective(true).setContent(this.shouldIncludeContent).setLatest(true).getResultDefinitions().required();
                    }
                    catch (NutsNotFoundException def22) {
                        // empty catch block
                    }
                    NutsDependencyTreeNodeBuild info = new NutsDependencyTreeNodeBuild(currentNode, def2, dependency, effDependency, currentNode.depth + 1, this.session);
                    info.exclusions.addAll(currentNode.exclusions);
                    for (NutsId exclusion : dependency.getExclusions()) {
                        info.exclusions.add(exclusion.getShortId());
                    }
                    currentNode.children.add(info);
                    queue.add(info);
                }
                continue;
            }
            currentNode.alreadyVisited = true;
        }
        List<NutsDependencyTreeNode> mergedRootNodes = mergedRootNodeBuilders.stream().map(x -> ((NutsDependencyTreeNodeBuild)x).build()).collect(Collectors.toList());
        List<NutsDependencyTreeNode> nonMergedRootNodes = nonMergedRootNodeBuilders.stream().map(x -> ((NutsDependencyTreeNodeBuild)x).build()).collect(Collectors.toList());
        NutsDependency[] mergedDepsList = (NutsDependency[])mergedVisitedSet.visitedSet.values().stream().map(NutsDependencyInfo::getDependency).toArray(NutsDependency[]::new);
        NutsDependency[] nonMergedDepsList = (NutsDependency[])nonMergedVisitedSet.visitedSet.values().stream().map(NutsDependencyInfo::getDependency).toArray(NutsDependency[]::new);
        return new DefaultNutsDependencies(this.getName(), sourceIds.toArray(new NutsId[0]), effDependencyFilter, immediates.toArray(new NutsDependency[0]), nonMergedDepsList, nonMergedRootNodes.toArray(new NutsDependencyTreeNode[0]), mergedDepsList, mergedRootNodes.toArray(new NutsDependencyTreeNode[0]), e -> e.ofString("solver"), this.session);
    }

    public NutsDependencySolver add(NutsDependency dependency, NutsDefinition def) {
        this.pending.add(new RootInfo(dependency, def));
        return this;
    }

    public NutsDependencySolver addRootDefinition0(NutsDependency dependency, NutsDefinition def, NutsSession session) {
        if (dependency == null) {
            if (def != null) {
                dependency = def.getId().toDependency();
            } else {
                throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"missing dependency", (Object[])new Object[0]));
            }
        }
        if (def == null) {
            def = (NutsDefinition)session.search().addId(dependency.toId()).setSession(session).setEffective(true).setContent(this.shouldIncludeContent).setEffective(true).setLatest(true).getResultDefinitions().required();
        }
        if (!def.isSetEffectiveDescriptor()) {
            throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"expected an effective definition for %s", (Object[])new Object[]{def.getId()}));
        }
        NutsDependencyTreeNodeBuild info = new NutsDependencyTreeNodeBuild(null, def, dependency, dependency, 0, session);
        for (NutsId exclusion : dependency.getExclusions()) {
            info.exclusions.add(exclusion.getShortId());
        }
        this.defs.add(info);
        return this;
    }

    public NutsDependencyFilter getDependencyFilter() {
        return this.dependencyFilter;
    }

    private NutsDependencyScope combineScopes(String parentScope0, String childScope0) {
        NutsDependencyScope parentScope = NutsDependencyScope.parseLenient((String)parentScope0, (NutsDependencyScope)NutsDependencyScope.API, (NutsDependencyScope)NutsDependencyScope.API);
        NutsDependencyScope childScope = NutsDependencyScope.parseLenient((String)childScope0, (NutsDependencyScope)NutsDependencyScope.API, (NutsDependencyScope)NutsDependencyScope.API);
        return this.combineScopes(parentScope, childScope);
    }

    private NutsDependencyScope combineScopes(NutsDependencyScope parentScope, NutsDependencyScope childScope) {
        boolean api;
        boolean other = parentScope.isOther() || childScope.isOther();
        boolean test = parentScope.isTest() || childScope.isTest();
        boolean system = !other && (parentScope.isSystem() || childScope.isSystem());
        boolean provided = !other && (parentScope.isProvided() || childScope.isProvided());
        boolean runtime = !other && (parentScope.isRuntime() || childScope.isRuntime());
        boolean impl = !other && !provided && !runtime && !system && (parentScope.isImplementation() || childScope.isImplementation());
        boolean bl = api = !other && !provided && !runtime && !system && !impl;
        if (test) {
            if (other) {
                return NutsDependencyScope.TEST_OTHER;
            }
            if (system) {
                return NutsDependencyScope.TEST_SYSTEM;
            }
            if (provided) {
                return NutsDependencyScope.TEST_PROVIDED;
            }
            if (runtime) {
                return NutsDependencyScope.TEST_RUNTIME;
            }
            if (impl) {
                return NutsDependencyScope.TEST_IMPLEMENTATION;
            }
            return NutsDependencyScope.TEST_API;
        }
        if (other) {
            return NutsDependencyScope.OTHER;
        }
        if (system) {
            return NutsDependencyScope.SYSTEM;
        }
        if (provided) {
            return NutsDependencyScope.PROVIDED;
        }
        if (runtime) {
            return NutsDependencyScope.RUNTIME;
        }
        if (impl) {
            return NutsDependencyScope.IMPLEMENTATION;
        }
        return NutsDependencyScope.API;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public MavenNutsDependencySolver setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public String getName() {
        return "maven";
    }

    private class NutsDependencyTreeNodeBuild {
        NutsDependencyTreeNodeBuild parent;
        NutsId id;
        NutsDefinition def;
        NutsDependency dependency;
        NutsDependency effDependency;
        List<NutsDependencyTreeNodeBuild> children = new ArrayList<NutsDependencyTreeNodeBuild>();
        List<NutsId> exclusions = new ArrayList<NutsId>();
        boolean alreadyVisited;
        int depth;
        NutsDescriptor effDescriptor;
        NutsDependencyInfo key;
        NutsSession session;

        public NutsDependencyTreeNodeBuild(NutsDependencyTreeNodeBuild parent, NutsDefinition def, NutsDependency dependency, NutsDependency effDependency, int depth, NutsSession session) {
            this.parent = parent;
            this.def = def;
            this.dependency = dependency;
            this.effDependency = effDependency;
            this.depth = depth;
            this.id = def != null ? def.getId() : (dependency != null ? dependency.toId() : null);
            this.key = NutsDependencyInfo.of(this);
            this.session = session;
        }

        private NutsId getEffectiveId() {
            return this.getEffectiveDescriptor().getId();
        }

        private NutsDescriptor getEffectiveDescriptor() {
            if (this.effDescriptor == null && this.def != null) {
                this.effDescriptor = this.def.getEffectiveDescriptor();
                if (this.effDescriptor == null) {
                    throw new NutsIllegalArgumentException(this.session, NutsMessage.cstyle((String)"expected an effective definition for %s", (Object[])new Object[]{this.def.getId()}));
                }
            }
            return this.effDescriptor;
        }

        private NutsDependencyTreeNode build() {
            NutsDependencyTreeNode[] nchildren = new NutsDependencyTreeNode[this.children.size()];
            for (int i = 0; i < nchildren.length; ++i) {
                nchildren[i] = this.children.get(i).build();
            }
            return new DefaultNutsDependencyTreeNode(this.dependency, nchildren, this.alreadyVisited);
        }
    }

    private static class NutsDependencyInfo {
        NutsId normalized;
        NutsId real;
        int depth;
        NutsDependency dependency;

        public NutsDependencyInfo(NutsId normalized, NutsId real, NutsDependency dependency, int depth) {
            this.normalized = normalized;
            this.real = real;
            this.depth = depth;
            this.dependency = dependency;
        }

        public static NutsDependencyInfo of(NutsDependencyTreeNodeBuild currentNode) {
            NutsId id;
            NutsId nutsId = id = currentNode.def == null ? null : currentNode.def.getId();
            if (id == null) {
                id = currentNode.dependency.toId();
            }
            return new NutsDependencyInfo(id.getShortId(), id, currentNode.dependency, currentNode.depth);
        }

        public NutsDependency getDependency() {
            return this.dependency;
        }
    }

    private static class NutsDependencyInfoSet {
        Map<NutsId, NutsDependencyInfo> visitedSet = new LinkedHashMap<NutsId, NutsDependencyInfo>();

        private NutsDependencyInfoSet() {
        }

        public boolean contains(NutsDependencyInfo other) {
            NutsDependencyInfo old = this.visitedSet.get(other.normalized);
            if (old == null) {
                return false;
            }
            return old.depth != other.depth || other.real.getVersion().compareTo(old.real.getVersion()) <= 0;
        }

        public boolean add(NutsDependencyInfo other) {
            NutsDependencyInfo old = this.visitedSet.get(other.normalized);
            if (old == null) {
                this.visitedSet.put(other.normalized, other);
                return true;
            }
            if (old.depth == other.depth && other.real.getVersion().compareTo(old.real.getVersion()) > 0) {
                this.visitedSet.put(other.normalized, other);
                return true;
            }
            return false;
        }
    }

    private static class RootInfo {
        NutsDependency dependency;
        NutsDefinition def;

        public RootInfo(NutsDependency dependency, NutsDefinition def) {
            this.dependency = dependency;
            this.def = def;
        }
    }
}

