/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.format;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFormat;
import net.thevpc.nuts.NutsIdBuilder;
import net.thevpc.nuts.NutsIdFormat;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.spi.NutsSupportLevelContext;

public class DefaultNutsDependencyFormat
extends DefaultFormatBase<NutsDependencyFormat>
implements NutsDependencyFormat {
    private boolean omitRepository;
    private boolean omitGroup;
    private boolean omitImportedGroup;
    private boolean omitQuery = false;
    private boolean highlightImportedGroup;
    private NutsDependency value;
    private Set<String> queryPropertiesOmitted = new HashSet<String>();

    public DefaultNutsDependencyFormat(NutsSession session) {
        super(session, "dependency-format");
    }

    @Override
    public NutsDependencyFormat setNtf(boolean ntf) {
        super.setNtf(ntf);
        return this;
    }

    public boolean isOmitRepository() {
        return this.omitRepository;
    }

    public NutsDependencyFormat setOmitRepository(boolean omitRepository) {
        this.omitRepository = omitRepository;
        return this;
    }

    public boolean isOmitGroupId() {
        return this.omitGroup;
    }

    public NutsDependencyFormat setOmitGroupId(boolean omitGroup) {
        this.omitGroup = omitGroup;
        return this;
    }

    public boolean isOmitImportedGroupId() {
        return this.omitImportedGroup;
    }

    public NutsDependencyFormat setOmitImportedGroup(boolean omitImportedGroup) {
        this.omitImportedGroup = omitImportedGroup;
        return this;
    }

    public boolean isOmitOtherProperties() {
        return this.omitQuery;
    }

    public NutsDependencyFormat setOmitOtherProperties(boolean value) {
        this.omitQuery = value;
        return this;
    }

    public boolean isHighlightImportedGroup() {
        return this.highlightImportedGroup;
    }

    public NutsDependencyFormat setHighlightImportedGroup(boolean highlightImportedGroup) {
        this.highlightImportedGroup = highlightImportedGroup;
        return this;
    }

    @Override
    public NutsString format() {
        NutsIdBuilder id = this.value.toId().builder();
        Map q = id.getProperties();
        block10: for (Map.Entry e : q.entrySet()) {
            switch ((String)e.getKey()) {
                case "scope": 
                case "optional": 
                case "classifier": 
                case "exclusions": 
                case "type": {
                    continue block10;
                }
            }
            if (!this.isOmitOtherProperties()) continue;
            id.setProperty((String)e.getKey(), null);
        }
        NutsIdFormat id1 = NutsIdFormat.of((NutsSession)this.getSession());
        for (String omitQueryProperty : this.getOmitQueryProperties()) {
            id1.setOmitProperty(omitQueryProperty, true);
        }
        return id1.setSession(this.getSession()).setValue(id.build()).setHighlightImportedGroupId(this.isHighlightImportedGroup()).setOmitOtherProperties(false).setOmitGroupId(this.isOmitGroupId()).setOmitImportedGroupId(this.isOmitImportedGroupId()).setOmitRepository(this.isOmitRepository()).setNtf(this.isNtf()).format();
    }

    public NutsDependency getValue() {
        return this.value;
    }

    public NutsDependencyFormat setValue(NutsDependency id) {
        this.value = id;
        return this;
    }

    public boolean isOmitClassifier() {
        return this.isOmitQueryProperty("classifier");
    }

    public NutsDependencyFormat setOmitClassifier(boolean value) {
        return this.setOmitQueryProperty("classifier", value);
    }

    public boolean isOmitOptional() {
        return this.isOmitQueryProperty("optional");
    }

    public NutsDependencyFormat setOmitOptional(boolean value) {
        return this.setOmitQueryProperty("optional", value);
    }

    public boolean isOmitExclusions() {
        return this.isOmitQueryProperty("exclusions");
    }

    public NutsDependencyFormat setOmitExclusions(boolean value) {
        return this.setOmitQueryProperty("exclusions", value);
    }

    public boolean isOmitScope() {
        return this.isOmitQueryProperty("scope");
    }

    public NutsDependencyFormat setOmitScope(boolean value) {
        return this.setOmitQueryProperty("scope", value);
    }

    public String[] getOmitQueryProperties() {
        return this.queryPropertiesOmitted.toArray(new String[0]);
    }

    public boolean isOmitQueryProperty(String name) {
        return this.queryPropertiesOmitted.contains(name);
    }

    public NutsDependencyFormat setOmitQueryProperty(String name, boolean value) {
        if (value) {
            this.queryPropertiesOmitted.add(name);
        } else {
            this.queryPropertiesOmitted.remove(name);
        }
        return this;
    }

    @Override
    public void print(NutsPrintStream out) {
        out.print(this.format());
    }

    public boolean configureFirst(NutsCommandLine cmdLine) {
        NutsArgument a = cmdLine.peek();
        if (a == null) {
            return false;
        }
        boolean enabled = a.isActive();
        switch (a.getKey().getString()) {
            case "--omit-env": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitOtherProperties(val);
                }
                return true;
            }
            case "--omit-group": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitGroupId(val);
                }
                return true;
            }
            case "--omit-imported-group": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitImportedGroup(val);
                }
                return true;
            }
            case "--omit-repo": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setOmitRepository(val);
                }
                return true;
            }
            case "--highlight-imported-group": {
                boolean val = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                if (enabled) {
                    this.setHighlightImportedGroup(val);
                }
                return true;
            }
        }
        return false;
    }

    public int getSupportLevel(NutsSupportLevelContext context) {
        return 10;
    }
}

