/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.EnumSet;
import java.util.Objects;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;

public class ScopeNutsDependencyFilter
extends AbstractDependencyFilter {
    private EnumSet<NutsDependencyScope> scopes = EnumSet.noneOf(NutsDependencyScope.class);

    public ScopeNutsDependencyFilter(NutsSession session, NutsDependencyScopePattern ... scopes) {
        super(session, NutsFilterOp.CUSTOM);
        for (NutsDependencyScopePattern scope : scopes) {
            if (scope == null) continue;
            this.scopes.addAll(scope.toScopes());
        }
    }

    public boolean acceptDependency(NutsId from, NutsDependency dependency, NutsSession session) {
        NutsDependencyScope d = NutsDependencyScope.parseLenient((String)dependency.getScope(), (NutsDependencyScope)NutsDependencyScope.API, (NutsDependencyScope)NutsDependencyScope.API);
        return d != null && this.scopes.contains(d);
    }

    @Override
    public NutsDependencyFilter simplify() {
        return this;
    }

    public String toString() {
        return "(" + this.scopes + ")";
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.scopes);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScopeNutsDependencyFilter other = (ScopeNutsDependencyFilter)obj;
        return Objects.equals(this.scopes, other.scopes);
    }
}

