/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.xtra.glob.GlobUtils;

public class NutsExclusionDependencyFilter
extends AbstractDependencyFilter {
    private final NutsDependencyFilter base;
    private final NutsId[] exclusions;

    public NutsExclusionDependencyFilter(NutsSession session, NutsDependencyFilter base, NutsId[] exclusions) {
        super(session, NutsFilterOp.CUSTOM);
        this.base = base;
        this.exclusions = exclusions;
    }

    public boolean acceptDependency(NutsId from, NutsDependency dependency, NutsSession session) {
        if (this.base != null && !this.base.acceptDependency(from, dependency, session)) {
            return false;
        }
        for (NutsId exclusion : this.exclusions) {
            NutsId nutsId = dependency.toId();
            if (!GlobUtils.ofExact(exclusion.getGroupId()).matcher(NutsUtilStrings.trim((String)nutsId.getGroupId())).matches() || !GlobUtils.ofExact(exclusion.getArtifactId()).matcher(NutsUtilStrings.trim((String)nutsId.getArtifactId())).matches() || !exclusion.getVersion().filter().acceptVersion(nutsId.getVersion(), session)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NutsDependencyFilter simplify() {
        if (this.exclusions.length == 0) {
            return this.base;
        }
        NutsDependencyFilter base2 = CoreFilterUtils.simplify(this.base);
        if (base2 != this.base) {
            return new NutsExclusionDependencyFilter(this.getSession(), base2, this.exclusions);
        }
        return this;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.base);
        hash = 67 * hash + Arrays.deepHashCode(this.exclusions);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NutsExclusionDependencyFilter other = (NutsExclusionDependencyFilter)obj;
        if (!Objects.equals(this.base, other.base)) {
            return false;
        }
        return Arrays.deepEquals(this.exclusions, other.exclusions);
    }

    public String toString() {
        return this.base + (this.exclusions == null ? "" : " excludes " + Arrays.stream(this.exclusions).map(x -> x.getLongName()).collect(Collectors.joining(",")));
    }
}

