/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Collectors;
import net.thevpc.nuts.NutsDependency;
import net.thevpc.nuts.NutsDependencyFilter;
import net.thevpc.nuts.NutsDependencyFilters;
import net.thevpc.nuts.NutsDependencyScope;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsFilterOp;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.standalone.util.CoreEnumUtils;

public class NutsDependencyScopeFilter
extends AbstractDependencyFilter {
    private EnumSet<NutsDependencyScope> scope = EnumSet.noneOf(NutsDependencyScope.class);

    public NutsDependencyScopeFilter(NutsSession session) {
        super(session, NutsFilterOp.CUSTOM);
    }

    private NutsDependencyScopeFilter(NutsSession session, Collection<NutsDependencyScope> scope) {
        super(session, NutsFilterOp.CUSTOM);
        this.scope = EnumSet.copyOf(scope);
    }

    public NutsDependencyScopeFilter add(Collection<NutsDependencyScope> scope) {
        EnumSet<NutsDependencyScope> s2 = EnumSet.copyOf(this.scope);
        s2.addAll(scope);
        return new NutsDependencyScopeFilter(this.getSession(), s2);
    }

    public NutsDependencyScopeFilter addScopePatterns(Collection<NutsDependencyScopePattern> scope) {
        EnumSet<NutsDependencyScope> s2 = EnumSet.copyOf(this.scope);
        for (NutsDependencyScopePattern ss : scope) {
            if (ss == null) continue;
            s2.addAll(ss.toScopes());
        }
        return new NutsDependencyScopeFilter(this.getSession(), s2);
    }

    public boolean acceptDependency(NutsId from, NutsDependency dependency, NutsSession session) {
        return this.scope.isEmpty() || this.scope.contains(NutsDependencyScope.parseLenient((String)dependency.getScope(), (NutsDependencyScope)NutsDependencyScope.API, (NutsDependencyScope)NutsDependencyScope.API));
    }

    public String toString() {
        return this.scope.isEmpty() ? "true" : "scope in (" + this.scope.stream().map(CoreEnumUtils::getEnumString).collect(Collectors.joining(", ")) + ')';
    }

    @Override
    public NutsDependencyFilter simplify() {
        return this.scope.isEmpty() ? (NutsDependencyFilter)NutsDependencyFilters.of((NutsSession)this.getSession()).always() : this;
    }
}

